<?php
/**
 * View: Eye icon.
 *
 * @since 4.6.0
 * @version 4.6.0
 *
 * @var array<int, string>|null $classes     List of classes to add to the icon.
 * @var bool|null               $aria_hidden Whether to hide the icon from screen readers.
 * @var Template                $this        The template instance.
 *
 * @package LearnDash\Core
 */

/** NOTICE: This code is currently under development and may not be stable.
 *  Its functionality, behavior, and interfaces may change at any time without notice.
 *  Please refrain from using it in production or other critical systems.
 *  By using this code, you assume all risks and liabilities associated with its use.
 *  Thank you for your understanding and cooperation.
 **/

use LearnDash\Core\Template\Template;

$icon_classes = [ 'ld-icon', 'ld-icon--eye' ];

if ( ! empty( $classes ) ) {
	$icon_classes = array_merge( $icon_classes, $classes );
}

$aria_hidden = $aria_hidden ?? true;
?>
<?php $this->template( 'components/icons/icon/start', compact( 'icon_classes', 'aria_hidden' ) ); ?>
<path fill-rule="evenodd" clip-rule="evenodd" d="M5.75037 12C5.81332 12.1057 5.8905 12.2309 5.98158 12.3709C6.27885 12.8281 6.71884 13.4356 7.28936 14.04C8.4453 15.2647 10.0404 16.3784 12.0001 16.3784C13.9597 16.3784 15.5548 15.2647 16.7108 14.04C17.2813 13.4356 17.7213 12.8281 18.0186 12.3709C18.1096 12.2309 18.1868 12.1057 18.2498 12C18.1868 11.8943 18.1096 11.7691 18.0186 11.6291C17.7213 11.1719 17.2813 10.5644 16.7108 9.95995C15.5548 8.73532 13.9597 7.62162 12.0001 7.62162C10.0404 7.62162 8.4453 8.73532 7.28936 9.95995C6.71884 10.5644 6.27885 11.1719 5.98158 11.6291C5.8905 11.7691 5.81332 11.8943 5.75037 12ZM19.1839 12C19.9141 11.6374 19.9138 11.6368 19.9138 11.6368L19.9126 11.6345L19.9102 11.6296L19.9023 11.6144C19.8958 11.6018 19.8867 11.5844 19.875 11.5625C19.8517 11.5187 19.8181 11.4568 19.7743 11.3795C19.6867 11.225 19.5583 11.008 19.3901 10.7493C19.0547 10.2335 18.5559 9.54373 17.9019 8.85086C16.6088 7.4809 14.612 6 12.0001 6C9.38816 6 7.39136 7.4809 6.09825 8.85086C5.44425 9.54373 4.94545 10.2335 4.61005 10.7493C4.44184 11.008 4.3134 11.225 4.22588 11.3795C4.18208 11.4568 4.14845 11.5187 4.12511 11.5625C4.11344 11.5844 4.10434 11.6018 4.09782 11.6144L4.08999 11.6296L4.08753 11.6345L4.08667 11.6362L4.08632 11.6368C4.08632 11.6368 4.08604 11.6374 4.81621 12L4.08632 11.6368C3.97141 11.8651 3.97113 12.1343 4.08604 12.3626L4.81621 12C4.08604 12.3626 4.08604 12.3626 4.08604 12.3626L4.08667 12.3638L4.08753 12.3655L4.08999 12.3704L4.09782 12.3856C4.10434 12.3982 4.11344 12.4156 4.12511 12.4375C4.14845 12.4813 4.18208 12.5432 4.22588 12.6205C4.3134 12.775 4.44184 12.992 4.61005 13.2507C4.94545 13.7665 5.44425 14.4563 6.09825 15.1491C7.39136 16.5191 9.38816 18 12.0001 18C14.612 18 16.6088 16.5191 17.9019 15.1491C18.5559 14.4563 19.0547 13.7665 19.3901 13.2507C19.5583 12.992 19.6867 12.775 19.7743 12.6205C19.8181 12.5432 19.8517 12.4813 19.875 12.4375C19.8867 12.4156 19.8958 12.3982 19.9023 12.3856L19.9102 12.3704L19.9126 12.3655L19.9138 12.3632C19.9138 12.3632 19.9141 12.3626 19.1839 12ZM19.1839 12L19.9138 12.3632C20.0287 12.1349 20.0287 11.8651 19.9138 11.6368L19.1839 12Z" fill="currentColor"/>
<path fill-rule="evenodd" clip-rule="evenodd" d="M12.0001 10.8649C11.3689 10.8649 10.8572 11.3731 10.8572 12C10.8572 12.6269 11.3689 13.1351 12.0001 13.1351C12.6313 13.1351 13.143 12.6269 13.143 12C13.143 11.3731 12.6313 10.8649 12.0001 10.8649ZM9.22449 12C9.22449 10.4775 10.4672 9.24324 12.0001 9.24324C13.533 9.24324 14.7757 10.4775 14.7757 12C14.7757 13.5225 13.533 14.7568 12.0001 14.7568C10.4672 14.7568 9.22449 13.5225 9.22449 12Z" fill="currentColor"/>
<?php $this->template( 'components/icons/icon/end' ); ?>
