<?php
defined( 'ABSPATH' ) || die();

$past_exams = OEM_M_Record::get_past_exams( $record_id );
?>
<div class="oem-menu-page-title">
	<span><?php esc_html_e( 'Your Past Exams', 'online-exam-management' ); ?></span>
</div>

<div class="oem-menu-page-content">
	<?php
	if ( count( $past_exams ) ) {
		foreach ( $past_exams as $row ) {
			$exam_id_esolution = $row->ID;
			/* $record_id is current user id */
		?>
	<ul class="oem-list oem-list-exam">
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Title:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::stripslashes( $row->exam_title ) ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Code:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( $row->exam_code ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Date and Time:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::get_at_text( $row->exam_at ) ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Duration (in minutes):', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo absint( $row->duration ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Roll Number:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::get_text( $row->roll_number ) ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Explaination Link:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<a href="<?php echo esc_url($on_going_exam->exam_explaination_link); ?>" target="_blank"><?php esc_html_e( 'Click to view Exam Explaination', 'online-exam-management' ); ?></a>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Solution Download:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<a href="#" class="answer_key_download" data-exam_id="<?php echo $exam_id_esolution; ?>" data-student_id = "<?php echo $record_id; ?>" data-toggle="modal" data-target="#answersheet">
					<?php esc_html_e( 'Click to download', 'online-exam-management' ); ?>	
				</a>
			</span>
		</li>
	</ul>
		<?php
		}
	} else {
	?>
	<div class="oem-text-danger">
		<?php esc_html_e( 'No past exam found.', 'online-exam-management' ); ?>
	</div>
	<?php
	}
	?>
</div>
<!-- The Modal -->
<div id="answersheet" class="modal">
	<div class="modal_header">
		<span class="close_cutom_modal">&times;</span>
	</div>
  <!-- Modal content -->
  <div class="modal-content">
    
    
  </div>  
</div>


