<?php
defined( 'ABSPATH' ) || die();

$on_going_exam = OEM_M_Record::get_on_going_exam( $record_id );
$exam_id = (isset($on_going_exam->ID)) ? $on_going_exam->ID : '' ;
$student_id     =    OEM_M_Record::fetch_student_data($record_id);
$attempt_response =  OEM_M_Response::fetch_responses($student_id->ID ,$exam_id);
$exam_page_url = OEM_Helper::online_exam_page_url();
?>
<div class="oem-menu-page-title">
	<span><?php esc_html_e( 'Your On-going Exam', 'online-exam-management' ); ?></span>
</div>

<div class="oem-menu-page-content">
	<?php
	if ( $on_going_exam ) {
		?>
	<ul class="oem-list oem-list-exam">
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Title:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::stripslashes( $on_going_exam->exam_title ) ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Code:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( $on_going_exam->exam_code ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Date and Time:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::get_at_text( $on_going_exam->exam_at ) ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Duration (in minutes):', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo absint( $on_going_exam->duration ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Roll Number:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<?php echo esc_html( OEM_Helper::get_text( $on_going_exam->roll_number ) ); ?>
			</span>
		</li>
		<li>
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Explaination Link:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<a href="<?php echo esc_url($on_going_exam->exam_explaination_link); ?>" target="_blank"><?php esc_html_e( 'Click to view Exam Explaination', 'online-exam-management' ); ?></a>
			</span>
		</li>
		
		<li>
			<span class="oem-list-value">
				<div class="oem-exam-results-section">
					<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-p-load-exam-results-form">

						<input type="hidden" name="oem_nonce" value="<?php echo esc_attr( wp_create_nonce( 'oem_nonce' ) ); ?>">
						<input type="hidden" name="action" value="oem-p-load-exam-results">

						<input type="hidden" name="exam" value="<?php echo esc_attr( $on_going_exam->ID ); ?>" id="oem_exam">
						<div class="oem-form-group oem-mb-2">
							<input type="hidden" name="roll_number" class="oem-form-control" id="oem_roll_number" value="<?php echo esc_html( OEM_Helper::get_text( $on_going_exam->roll_number ) ); ?>">
						</div>

						<div class="oem-form-group oem-mb-2">
							<input type="hidden" name="name" class="oem-form-control" id="oem_name" value="<?php echo esc_html( OEM_Helper::stripslashes( $record->oem_name ) );?>">
						</div>
					
						<div class="oem-border-top oem-pt-2 oem-mt-1">
							<button class="button oem-btn btn btn-primary" type="submit" id="oem-p-load-exam-results-btn">
								<?php esc_html_e( 'Result', 'online-exam-management' ); ?>
							</button>
						</div>
					</form>

					<div class="oem-exam-results oem-mt-3"></div>
				</div>
			</span>
		</li>
		<?php if(empty($attempt_response)){ ?>
		<li>
			<a target="_blank" href="<?php echo esc_url( $exam_page_url.'?id='.$on_going_exam->ID. '' ); ?>">
				<?php esc_html_e( 'Visit Online Exam Portal', 'online-exam-management' ); ?>
			</a>
		</li>
		<?php }  ?>
	</ul>
		<?php
	} else {
	?>	
	<div class="oem-text-danger">
		<?php esc_html_e( 'No on-going exam found.', 'online-exam-management' ); ?>
	</div>
	<?php
	}
	?>
	<div class="oem-text-danger">
			<span class="oem-font-bold oem-list-key">
				<?php esc_html_e( 'Exam Explaination Link:', 'online-exam-management' ); ?>
			</span>
			<span class="oem-list-value">
				<a href="<?php if(isset($on_going_exam) ) {
				 echo esc_url($on_going_exam->exam_explaination_link); } ?>" target="_blank"><?php esc_html_e( 'Click to view Exam Explaination', 'online-exam-management' ); ?></a>
			</span>
	</div>
</div>
