<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Exam.php';

$exam_id = '';

if ( isset( $attr['id'] ) ) {
	$exam_id = absint( $attr['id'] );

	$exam = OEM_M_Exam::get_shortcode_exam( $exam_id );
	if ( ! $exam ) {
		$invalid_message = esc_html__( 'Exam not found.', 'online-exam-management' );
		return require_once OEM_PLUGIN_DIR_PATH . 'public/inc/partials/invalid.php';
	}
} else {
	$exam = '';
	$exams = OEM_M_Exam::get_shortcode_exams();
}
?>
<div class="oem">
	<div class="oem-exam-results-section">
		<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-p-load-exam-results-form">

			<input type="hidden" name="oem_nonce" value="<?php echo esc_attr( wp_create_nonce( 'oem_nonce' ) ); ?>">
			<input type="hidden" name="action" value="oem-p-load-exam-results">

			<?php if ( $exam ) { ?>
			<input type="hidden" name="exam" value="<?php echo esc_attr( $exam_id ); ?>" id="oem_exam">
			<?php } else { ?>
			<div class="oem-form-group oem-mb-2">
				<label for="oem_exam" class="oem-font-bold">
					<span class="oem-text-danger">*</span> <?php esc_html_e( 'Exam', 'online-exam-management' ); ?>:
				</label>
				<br>
				<select name="exam" class="oem-form-control" id="oem_exam">
					<option value=""><?php esc_html_e( 'Select Exam', 'online-exam-management' ); ?></option>
					<?php foreach ( $exams as $exam ) { ?>
					<option value="<?php echo esc_attr( $exam->ID ); ?>">
						<?php
						printf(
							/* translators: 1: exam title, 2: exam code */
							esc_html_x( '%1$s (%2$s)', 'Exam title and code', 'online-exam-management' ),
							esc_html( OEM_Helper::stripslashes( $exam->exam_title ) ),
							esc_html( $exam->exam_code )
						);
						?>
					</option>
					<?php } ?>
				</select>
			</div>
			<?php } ?>

			<div class="oem-form-group oem-mb-2">
				<label for="oem_roll_number" class="oem-font-bold">
					<span class="oem-text-danger">*</span> <?php esc_html_e( 'Roll Number', 'online-exam-management' ); ?>:
				</label>
				<br>
				<input type="text" name="roll_number" class="oem-form-control" id="oem_roll_number" placeholder="<?php esc_attr_e( 'Enter roll number', 'online-exam-management' ); ?>">
			</div>

			<div class="oem-form-group oem-mb-2">
				<label for="oem_name" class="oem-font-bold">
					<span class="oem-text-danger">*</span> <?php esc_html_e( 'Name', 'online-exam-management' ); ?>:
				</label>
				<br>
				<input type="text" name="name" class="oem-form-control" id="oem_name" placeholder="<?php esc_attr_e( 'Enter name', 'online-exam-management' ); ?>">
			</div>

			<div class="oem-border-top oem-pt-2 oem-mt-1">
				<button class="button oem-btn btn btn-primary" type="submit" id="oem-p-load-exam-results-btn">
					<?php esc_html_e( 'Search Result', 'online-exam-management' ); ?>
				</button>
			</div>
		</form>

		<div class="oem-exam-results oem-mt-3"></div>
	</div>
</div>
<?php
return ob_get_clean();
