<?php
defined('ABSPATH') || die();

$current_page_url = home_url(add_query_arg(array(), $wp->request));
$logout_url       = wp_logout_url($current_page_url);
if (isset($_GET['id']) && !empty($_GET['id'])) {
	$student_roll_number = ($_GET['id']);
}

$user = wp_get_current_user();
$user_id = $user->ID;

$student_roll_number =  "$student_roll_number";
global $wpdb;
$rows = $wpdb->get_results($wpdb->prepare("SELECT os.exam_id FROM " . OEM_STUDENTS . " as os
		WHERE os.roll_number = %d", $student_roll_number));

$rows2 = $wpdb->get_results($wpdb->prepare("SELECT os.roll_number FROM " . OEM_STUDENTS . " as os
		WHERE os.user_id = %d AND os.exam_id =%d", $user_id , $student_roll_number));
// var_dump($rows2);


$exam_id = $student_roll_number;
if ($exam_id) {
	$student_roll_number = $rows2[0]->roll_number;
}
$exam = OEM_M_Exam::fetch_exam($exam_id);

if (!$exam) {
	die;
}

// Allow only activated exam.
if (!$exam->is_activated) {
	require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/not_activated.php';
	return;
}

$exam_title   = $exam->exam_title;
$exam_code    = $exam->exam_code;
$exam_center  = $exam->exam_center;
$exam_at      = $exam->exam_at;
$duration     = $exam->duration;
$instructions = $exam->instructions;

$exam_status = OEM_Helper::get_exam_status_text($exam_at, $duration, true, true);

// if ( 'completed' === $exam_status['key'] ) {
// 	return require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/redirect_to_exam_status.php';
// }
?>
<div class="oem oem-container-exam-window" id="oem-container-exam-window">
	<input type="hidden" name="student_roll_number" id="student_roll_number" value="<?php if ($student_roll_number) {
																						echo $student_roll_number;
																					} ?>">
	<input type="hidden" name="student_exam_id" id="student_exam_id" value="<?php if ($exam_id) {
																				echo $exam_id;
																			} ?>">
	<!-- Exam Instructions -->
	<div class="oem-exam-instructions oem-content-padding">
		<?php
		if ('active' !== $exam_status['key']) {
			echo wp_kses_post(stripcslashes($instructions));
		}
		?>
	</div>

	<?php
	if ('active' === $exam_status['key']) {
	?>
		<!-- Question box -->
		<div class="oem-question-box oem-content-padding"></div>

		<div class="oem-w-md-40">
			<!-- Action on Question buttons -->
			<div class="oem-action-buttons oem-content-padding">
				<button type="button" id="oem-mark-for-review-next-btn" data-mark-text="<?php esc_attr_e('Mark for Review', 'online-exam-management'); ?>" data-unmark-text="<?php esc_attr_e('Remove Mark', 'online-exam-management'); ?>">
					<?php esc_html_e('Mark for Review', 'online-exam-management'); ?>
				</button>

				<button type="button" id="oem-clear-btn">
					<?php esc_html_e('Clear Response', 'online-exam-management'); ?>
				</button>

				<button type="button" id="oem-previous-btn">
					<?php esc_html_e('Save & Back', 'online-exam-management'); ?>
				</button>

				<button type="button" id="oem-save-next-btn" data-save-text="<?php esc_attr_e('Save', 'online-exam-management'); ?>" data-next-text="<?php esc_attr_e('Save & Next', 'online-exam-management'); ?>">
					<?php esc_html_e('Save & Next', 'online-exam-management'); ?>
				</button>
			</div>

			<!-- Exam time remaining -->
			<div class="oem-exam-timer-box oem-content-padding">
				<?php
				// If exam is on-going, then show the time remaining.
				$js_handle = 'oem-public';

				require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_timer.php';
				?>
			</div>
			<?php  
			global $wpdb;
			$registration_page_url = OEM_Helper::registration_page_url();
			$registration_page_url = $registration_page_url."?action=on_going_exam";
			?>
			<div class="oem-finish-exam oem-content-padding">
				<a class="oem-finish-exam-button" id="oem-attempt-response" href="<?php echo esc_url($registration_page_url); ?>" data-confirm="<?php esc_attr_e('Are you sure to finish the exam now?', 'online-exam-management'); ?>" data-message="<?php esc_attr_e("Thank you! You will be redirected to dashboard", 'online-exam-management'); ?>">
					<?php esc_html_e('Finish Exam', 'online-exam-management'); ?>
				</a>
			</div>
		</div>
    
		<div class="oem-w-md-60">
			<!-- Question navigation buttons -->
			<div class="oem-questions-navigation oem-content-padding">
				<div class="oem-question-palette-wrapper"></div>
				<div class="oem-question-legend oem-window-section">
					<span class="oem-question-legend-label oem-window-section-label">
						<?php esc_html_e('Legend', 'online-exam-management'); ?>
					</span>
					<div class="oem-question-legend-items">
						<span class="oem-question-legend-item">
							<span class="oem-question-palette-number oem-color-answered"></span>
							<span class="oem-question-palette-number-label">
								<?php esc_html_e('Answered', 'online-exam-management'); ?>
							</span>
						</span>
						<span class="oem-question-legend-item">
							<span class="oem-question-palette-number oem-color-not-answered"></span>
							<span class="oem-question-palette-number-label">
								<?php esc_html_e('Not Answered', 'online-exam-management'); ?>
							</span>
						</span>
						<span class="oem-question-legend-item">
							<span class="oem-question-palette-number oem-color-marked"></span>
							<span class="oem-question-palette-number-label">
								<?php esc_html_e('Marked', 'online-exam-management'); ?>
							</span>
						</span>
						<span class="oem-question-legend-item">
							<span class="oem-question-palette-number oem-color-not-visited"></span>
							<span class="oem-question-palette-number-label">
								<?php esc_html_e('Not Visited', 'online-exam-management'); ?>
							</span>
						</span>
						<span class="oem-question-legend-item">
							<span class="oem-question-palette-number oem-color-answered-marked"></span>
							<span class="oem-question-palette-number-label">
								<?php esc_html_e('Answered & Marked for Review', 'online-exam-management'); ?>
							</span>
						</span>
					</div>
				</div>
			</div>
		</div>

		<!-- Additional section -->
		<div class="oem-additonal-section oem-content-padding oem-text-right">
			<input type="hidden" name="student_roll_number" id="student_roll_number" value="<?php if ($student_roll_number) {
																								echo $student_roll_number;
																							} ?>">
			<button type="button" class="oem-additonal-btn oem-view-exam-instructions-btn">
				<?php esc_html_e('View Instructions', 'online-exam-management'); ?>
			</button>
		</div>
	<?php
	}
	?>

	<?php
	if ('active' !== $exam_status['key']) {
	?>
		<!-- Start exam buttons -->
		<div class="oem-text-center oem-mt-3 oem-start-exam-action oem-content-padding">
			<?php
			$start_exam_btn_text = esc_html__('Start Exam', 'online-exam-management');

			// If exam is goining to start, then show the timer and start exam when timer reaches to zero by showing the first question of the exam.
			$js_handle = 'oem-public';
			?>
			<span class="oem-time-remaining text-secondary"><?php esc_html_e('Starting in:', 'online-exam-management'); ?></span>
			<div class="oem-flex oem-justify-center">
				<?php
				require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_starting_in.php';
				?>
			</div>

			<?php $enable_photo = OEM_Helper::enable_photo(); ?>
			<?php if ($enable_photo): ?>
			
			
			<!-- save photo of student -->
			<div class="oem-flex oem-justify-center">
				<form method="POST" action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" id="oem-p-photo-form">
				<input type="hidden" name="oem_nonce" value="<?php echo esc_attr( wp_create_nonce( 'oem_nonce' ) ); ?>">
				<input type="hidden" name="action" value="oem-p-photo">
					<div class="row">
						<div class="col-md-6">
							<div id="my_camera" ></div>
							<br/>
							<input type=button value="Take Snapshot" onClick="take_snapshot()">
							
							<input type="hidden" name="image" class="image-tag">
							<input type="hidden" name="student_id" value="<?php echo $user_id; ?>">
							<input type="hidden" name="exam_id" value="<?php echo $exam_id; ?>">
						</div>
						<div class="col-md-6">
						<br>
							<div id="results">
								<?php esc_html_e( 'Your captured image will appear here...', 'online-exam-management' ); ?>
							</div>
						</div>
						<div class="col-md-12 text-center">
							<br/>
							<button class="button oem-btn btn btn-primary" id="oem-p-photo-btn">
								<?php esc_html_e( 'Submit', 'online-exam-management' ); ?>
							</button>
						</div>
					</div>
				</form>
			</div>
			<script src="https://cdnjs.cloudflare.com/ajax/libs/webcamjs/1.0.25/webcam.min.js"></script>
			<script language="JavaScript">
				Webcam.set({
					width: 490,
					height: 300,
					image_format: 'jpeg',
					jpeg_quality: 90
				});
			
				Webcam.attach( '#my_camera' );
			
				function take_snapshot() {
					Webcam.snap( function(data_uri) {
						jQuery(".image-tag").val(data_uri);
						document.getElementById('results').innerHTML = '<img src="'+data_uri+'"/>';
					} );
				}
			</script>
			

			<?php endif ?>
		</div>
	<?php
	}
	?>
</div>
