<?php
defined('ABSPATH') || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Student.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Result.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Record.php';

global $wp;
$registration_page_url = OEM_Helper::registration_page_url();
$current_page_url = '';
$student_roll_number  = '';
?>

<div class="oem">
	<?php if (is_user_logged_in()) : ?>
		<?php
		if (isset($_GET['id']) && !empty($_GET['id'])) {
			$student_roll_number = ($_GET['id']);
		}
		$record_id = get_current_user_id();

		$record = OEM_M_Record::find($record_id);

		$logout_url = wp_logout_url($current_page_url);
		global $wpdb;
		$student_data = $wpdb->get_results(
			$wpdb->prepare( 'SELECT * FROM ' . OEM_STUDENTS . ' as s WHERE s.user_id = %d AND s.exam_id = %d', $record_id, $student_roll_number )
		);

		?>
		<div class="oem-logged-in-info " style="float: right;">
			<span class="oem-logged-in-text"><?php esc_html_e('You are logged in.', 'online-exam-management'); ?></span>
			<a class="oem-logout-link oem-text-danger " href="<?php echo esc_url($logout_url); ?>">
				<?php esc_html_e('Logout', 'online-exam-management'); ?>
			</a>
		</div>
		<a class="oem-button btn btn-secondary" id="oem-button" href="<?php echo ($registration_page_url) ?>"><?php esc_html_e('Go To Dashboard', 'online-exam-management'); ?></a><br><br>

		<div class="oem-registration-info">
			<div class="oem-question-header">
						<span class="oem-question-number">
						<?php
					echo wp_kses(
						sprintf(
							/* translators: 1: student name, 2: registration number */
							__('Welcome!, <span class="pl-5">Name: </span><span class="oem-font-bold pr-5 font-weight-bold">%1$s</span><br>  Your Registration Number is: <span class="oem-font-bold font-weight-bold">%2$s</span> ', 'online-exam-management'),
							esc_html(OEM_Helper::stripslashes($record->oem_name)),
							esc_html($record->oem_reg_number)
						),
						array(
							'span' => array('class' => array()),
						)
					);
					?>
						</span>
						
						<?php if (isset($student_data[0]->exam_photos)): ?>
							<span class="oem-question-marks">
							<img src="<?php echo ( $student_data[0]->exam_photos );?>" width="150" height="150" alt="student_photo" >
						</span>
						<?php endif ?>
						
			</div>
		</div>
		
		<?php if (!$student_roll_number) {

			require_once OEM_PLUGIN_DIR_PATH . 'public/inc/registration/dashboard/on_going_exam.php';
		} ?>

	<?php endif ?>
	<?php
	$current_page_url = home_url(add_query_arg(array(), $wp->request));
	$exam_window_url  = add_query_arg(array('action' => 'exam_window'), $current_page_url);
	if (is_user_logged_in()) {

		$student = OEM_M_Student::get_logged_in_student();

		if ($student) {
			require_once OEM_PLUGIN_DIR_PATH . 'public/inc/account/student/route.php';
		} else {
			require_once OEM_PLUGIN_DIR_PATH . 'public/inc/account/no_record.php';
		}
	} else {
	?>
		<div class="oem-container oem-container-login">
			<div class="oem-login-box">
				<?php
				$login_form_args = array(
					'form_id'        => 'oem-login-form',
					'id_username'    => 'oem-login-username',
					'id_password'    => 'oem-login-password',
					'id_remember'    => 'oem-login-remember',
					'id_submit'      => 'oem-login-submit',
					'value_username' => '',
				);
				wp_login_form($login_form_args);
				?>
				<a href="<?php echo get_home_url().'/wp-login.php?action=lostpassword'?>"><?php esc_html_e('Lost Password?', 'online-exam-management'); ?></a>
			</div>
			
		</div>
	<?php
	}
	?>

	<?php
