<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';

class OEM_Shortcode {
	public static function online_exam( $attr ) {
		self::enqueue_assets();
		ob_start();
		return require_once OEM_PLUGIN_DIR_PATH . 'public/inc/account/route.php';
	}

	public static function online_exam_results( $attr ) {
		self::enqueue_assets();
		ob_start();
		return require_once OEM_PLUGIN_DIR_PATH . 'public/inc/forms/exam_results.php';
	}

	public static function online_exam_all_results( $attr ) {
		self::enqueue_assets();
		ob_start();
		return require_once OEM_PLUGIN_DIR_PATH . 'public/inc/forms/exam_all_results.php';
	}

	public static function online_exam_registration( $attr ) {
		self::enqueue_assets();
		ob_start();
		return require_once OEM_PLUGIN_DIR_PATH . 'public/inc/registration/route.php';
	}

	public static function enqueue_assets() {
		wp_enqueue_style( 'jquery-confirm', OEM_PLUGIN_URL . 'assets/css/jquery-confirm.min.css' );
		wp_enqueue_style( 'toastr', OEM_PLUGIN_URL . 'assets/css/toastr.min.css' );

		wp_enqueue_style( 'oem-admin', OEM_PLUGIN_URL . 'assets/css/oem.css', array(), '1.4', 'all' );
		wp_enqueue_style( 'zebra-datepicker', OEM_PLUGIN_URL . 'assets/css/zebra_datepicker.min.css' );

		wp_enqueue_script( 'jquery-confirm', OEM_PLUGIN_URL . 'assets/js/jquery-confirm.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'toastr', OEM_PLUGIN_URL . 'assets/js/toastr.min.js', array( 'jquery' ), true, true );

		wp_enqueue_script( 'oem-public', OEM_PLUGIN_URL . 'assets/js/oem.js', array( 'jquery', 'jquery-form' ), '1.4', true );
		wp_enqueue_script( 'stripe-checkout', '//checkout.stripe.com/checkout.js', array(), NULL, true );
		wp_enqueue_script( 'zebra-datepicker', OEM_PLUGIN_URL . 'assets/js/zebra_datepicker.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'oem-admin', OEM_PLUGIN_URL . 'assets/js/oem-admin.js', array( 'jquery', 'jquery-form' ), '1.4', true );
		wp_localize_script( 'oem-public', 'oemsecurity', ( wp_create_nonce( 'oem-security' ) ) );
		wp_localize_script( 'oem-public', 'oemdateformat',( OEM_Helper::date_format() ) );
		wp_localize_script( 'oem-public', 'oemtimeformat', ( OEM_Helper::time_format() ) );
		wp_localize_script( 'oem-public', 'oematformat', ( OEM_Helper::at_format() ) );
		wp_localize_script( 'oem-public', 'oemajaxurl', ( admin_url( 'admin-ajax.php' ) ) );
		wp_localize_script( 'oem-public', 'oemadminurl', ( admin_url() ) );
		wp_localize_script( 'oem-public', 'oemnonce', ( wp_create_nonce( 'oem_nonce' ) ) );
	}
}
