<?php
/*
 * Plugin Name: Online Exam Management
 * Plugin URI: https://weblizar.com/plugins/online-exam-management/
 * Description: Online Exam Management is a WordPress plugin to create and manage online exams for students and publish exam results.
 * Version: 4.0
 * Author: Weblizar
 * Author URI: https://weblizar.com
 * Text Domain: online-exam-management
*/

defined( 'ABSPATH' ) || die();

if ( ! defined( 'OEM_PLUGIN_URL' ) ) {
	define( 'OEM_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
}

if ( ! defined( 'OEM_PLUGIN_DIR_PATH' ) ) {
	define( 'OEM_PLUGIN_DIR_PATH', plugin_dir_path( __FILE__ ) );
}

final class OEM_Online_Exam_Management {
	private static $instance = NULL;

	private function __construct() {
		$this->initialize_hooks();
		$this->setup_database();
	}

	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	private function initialize_hooks() {
		require_once OEM_PLUGIN_DIR_PATH . 'includes/constants.php';

		if ( is_admin() ) {
			require_once OEM_PLUGIN_DIR_PATH . 'admin/admin.php';
		}
		require_once OEM_PLUGIN_DIR_PATH . 'public/public.php';
	}

	private function setup_database() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Database.php';
		register_activation_hook( __FILE__, array( 'OEM_Database', 'activation' ) );
		register_activation_hook( __FILE__, array( 'OEM_Database', 'deactivation' ) );
		register_activation_hook( __FILE__, array( 'OEM_Database', 'uninstall' ) );
	}
}
OEM_Online_Exam_Management::get_instance();
