<?php
defined( 'ABSPATH' ) || die();
?>
<div class="oem-row">
	<div class="oem-student-exam-detail oem-col-md-9">
		<ul class="oem-list oem-content-padding">
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( 'Student Name:', 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
					<?php echo esc_html( OEM_Helper::stripslashes( $student->name ) ); ?>
				</span>
			</li>
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( 'Roll Number:', 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
					<?php echo esc_html( OEM_Helper::get_text( $student->roll_number ) ); ?>
				</span>
			</li>
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( 'Exam:', 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
				<?php 
					printf(
						wp_kses(
							/* translators: 1: exam title, 2: exam code, 3: date and time, 4: number of minutes */
							__( '%1$s (%2$s) (%3$s - %4$s minutes)', 'online-exam-management' ),
							array(
								'span' => array( 'class' => array() )
							)
						),
						esc_html( OEM_Helper::stripslashes( $exam->exam_title ) ),
						esc_html( $exam->exam_code ),
						esc_html( OEM_Helper::get_at_text( $exam->exam_at ) ),
						esc_html( $exam->duration )
					);
				?>
				</span>
			</li>
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( 'Phone:', 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
					<?php echo esc_html( OEM_Helper::get_text( $student->phone ) ); ?>
				</span>
			</li>
			<li>
				<span class="oem-list-item-key oem-font-bold"><?php esc_html_e( "Father's Name:", 'online-exam-management' ); ?></span>
				<span class="oem-list-item-value">
					<?php echo esc_html( OEM_Helper::stripslashes( $student->father_name ) ); ?>
				</span>
			</li>
		</ul>
	</div>

	<?php if ( ! empty ( $student->photo_id ) && ( $photo_url = wp_get_attachment_url( $student->photo_id ) ) ) { ?>
	<div class="oem-student-photo oem-col-md-3 oem-text-center oem-text-md-right">
		<img src="<?php echo esc_url( $photo_url ); ?>" class="img-responsive oem-photo">
	</div>
	<?php } ?>

	<?php 
	global $wpdb;
	$student_data = $wpdb->get_results(
		$wpdb->prepare( 'SELECT * FROM ' . OEM_STUDENTS . ' as s WHERE s.user_id = %d AND s.exam_id = %d', $student->user_id, $student->exam_id )
	);
		?>
		<?php if (!empty($student_data[0]->exam_photos)): ?>
			<div class="oem-student-photo oem-col-md-3 oem-text-center oem-text-md-right">
	<span> <strong><?php esc_html_e('Studnet exam photo', 'online-exam-management' )?> </strong></span><br>
		
		<img src="<?php echo ( $student_data[0]->exam_photos );?>" width="150" height="150"  >
	</div>
		<?php endif ?>
	
</div>

<?php 
// Questions.
$questions = OEM_M_Question::fetch_questions( $exam_id );

// Total questions in this exam.
$questions_count = count( $questions );

// Total maximum marks of questions in this exam.
$maximum_marks_sum = OEM_M_Question::get_questions_maximum_marks_sum( $exam_id );

// Exam question options.
$options = OEM_M_Question::get_exam_options( $exam_id );

require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result_stats.php';
?>
<!-- Student Exam result -->
<?php require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result.php'; ?>	


<br>
<button type="button" class="oem-btn oem-btn-primary" id="oem-print-answer-sheet-btn" data-styles='["<?php echo esc_url( OEM_PLUGIN_URL . 'assets/css/bootstrap.min.css' ); ?>","<?php echo esc_url( OEM_PLUGIN_URL . 'assets/css/oem-print.css' ); ?>","<?php echo esc_url( OEM_PLUGIN_URL . 'assets/css/print/answer_sheet.css' ); ?>"]' data-title="<?php
printf(
	/* translators: 1: exam title, 2: exam code */
	esc_attr__( 'Answer Sheet - %1$s (%2$s)', 'online-exam-management' ),
	esc_html( '' ),
	esc_html( $exam_id )
);
?>"><?php esc_html_e( 'Print Answer Sheet Card', 'online-exam-management' ); ?>
</button>

<div class="oem-questions-box" id="oem-print-answer-sheet">
	<?php	
	foreach ( $questions as $key => $question ) {
		$question_options = array_filter(
			$options, function( $option ) use ( $question ) {
				return $question->ID === $option->question_id;
			}
		);
	?>
	<br>
	<div class="oem-question-box col">
		<div class="oem-question-detail">
			<div class="mb-1 oem-font-bold">
				<span class="border-bottom border-dark">
					<?php
					printf(
						wp_kses(
							/* translators: %s: Question number. */
							__( '<span class="oem-font-bold">Question No.</span> <span class="oem-font-extra-bold">%s</span>', 'online-exam-management' ),
							array(
								'span' => array( 'class' => array() )
							)
						),
						esc_html( $key + 1 )
					);
					?>
				</span>
				<span class="text-secondary float-right oem-font-small-medium"><?php echo esc_html( OEM_Helper::question_type( $question->type ) ); ?></span>
			</div>
			<span class="oem-question-maximum-marks oem-font-small-medium float-right d-inline-block ml-3">
				<?php
				printf(
					wp_kses(
						/* translators: %s: Maximum marks. */
						__( '<span class="oem-font-bold">Maximum marks:</span> <span class="oem-font-extra-bold">%s</span>', 'online-exam-management' ),
						array(
							'span' => array( 'class' => array() )
						)
					),
					esc_html( OEM_Helper::sanitize_marks( $question->maximum_marks ) )
				);
				?>
			</span>
			<span class="oem-question-description">
				<?php echo wp_kses_post( stripcslashes( $question->description ) ); ?>
			</span>
			<?php
			if ( 'subjective' !== $question->type ) {
			?>
			<div class="oem-question-options">
				<?php
				$question_correct_option_ids = array();

				$option_number = 0;
				foreach ( $question_options as $key => $option ) {
					$option_number++;
				?>
				<div class="oem-option-wrapper">
					<hr>
					<div class="oem-option-value">
						<span class="oem-option-number oem-font-bold"><?php echo esc_html( $option_number ); ?>.</span>
						<?php echo wp_kses_post( $option->value ); ?>
						<?php
						if ( $option->is_correct ) {
							array_push( $question_correct_option_ids, $option->ID );
						?>
						<br>
						-
						<span class="oem-text-success oem-font-bold">
							<?php esc_html_e( 'Correct', 'online-exam-management' ); ?>
						</span>
						<?php
						}
						?>
					</div>
				</div>
				<?php
				}
				?>
			</div>
			<?php
			}
			?>
		</div>

		<hr>

		<div class="oem-question-response">
			<div class="mb-1 oem-font-bold">
				<span class="border-bottom border-dark text-danger">
					<?php esc_html_e( "Student's Response:", 'online-exam-management' ); ?>
				</span>
			</div>
			<?php
			// Check if student attempted the question.
			$student_attempted_question = array_filter(
				$questions_attempted, function( $question_attempted ) use ( $question ) {
					return $question->ID === $question_attempted->ID;
				}
			);
			if ( ! empty( $student_attempted_question ) ) {
			?>
			<span class="oem-text-primary"><?php esc_html_e( 'Attempted', 'online-exam-management' ); ?></span>
			<div class="oem-question-student-answer mt-2">
				<?php
				if ( 'subjective' === $question->type ) {
					// Get subjective obtained marks of this question.
					$student_subjective_response = '';
					foreach ( $subjective_responses as $subjective_response ) {
						if ( $question->ID === $subjective_response->question_id ) {
							$student_subjective_response = $subjective_response;
							break;
						}
					}

					if ( $student_subjective_response ) {
						$student_obtained_marks = OEM_Helper::sanitize_marks( $student_subjective_response->sbj_marks_obtained );
					} else {
						$student_obtained_marks = 0;
					}
					?>
					<div class="text-right">
						<span class="oem-font-bold oem-font-small-medium">
							<?php esc_html_e( 'Obtained Marks:', 'online-exam-management' ); ?>
						</span>
						<span class="oem-text-success">
							<?php echo esc_html( $student_obtained_marks ); ?>
						</span>
					</div>
					<?php
				} else {
					?>
					<div class="mb-1 oem-font-bold">
						<span class="border-bottom border-dark text-danger">
							<?php esc_html_e( "Student's Answer:", 'online-exam-management' ); ?>
						</span>
					</div>
					<?php
					// Get student answer(s) of this question.
					$question_student_answers = array_filter(
						$student_answers,
						function( $student_answer ) use ( $question ) {
							return $question->ID === $student_answer->question_id;
						}
					);
					// Get student answer(s) option_id(s) of this question.
					$question_student_answers_option_ids = array_map(
						function( $question_student_answer ) {
							return $question_student_answer->option_id;
						},
						$question_student_answers
					);

					$option_numbers = array();
					$option_number  = 0;
					foreach ( $question_options as $key => $option ) {
						$option_number++;
						if ( in_array( $option->ID, $question_student_answers_option_ids ) ) {
							array_push( $option_numbers, $option_number );
						}
					}

					if ( ! empty( $option_numbers ) ) {
					?>
					<span class="oem-font-bold">
						<?php echo esc_html( implode( ', ', $option_numbers ) ); ?>
					</span>
					<?php
					}

					// Check if two arrays are equal.
					$same = ( count( $question_correct_option_ids ) === count( $question_student_answers_option_ids ) && ! array_diff( $question_correct_option_ids, $question_student_answers_option_ids ) );
					?>
					-
					<?php
					if ( $same ) {
						// Student's answer is correct.
						?>
						<span class="oem-text-success oem-font-bold">
							<?php esc_html_e( 'Correct', 'online-exam-management' ); ?>
						</span>
						<div class="text-right">
							<span class="oem-font-bold oem-font-small-medium">
								<?php esc_html_e( 'Obtained Marks:', 'online-exam-management' ); ?>
							</span>
							<span class="oem-text-success">
								<?php echo esc_html( OEM_Helper::sanitize_marks( $question->maximum_marks ) ); ?>
							</span>
						</div>
						<?php
					} else {
						// Student's answer is incorrect.
						?>
						<span class="oem-text-danger oem-font-bold">
							<?php esc_html_e( 'Incorrect', 'online-exam-management' ); ?>
						</span>
						<div class="text-right">
							<span class="oem-font-bold oem-font-small-medium">
								<?php esc_html_e( 'Negative Marks:', 'online-exam-management' ); ?>
							</span>
							<span class="oem-text-danger">
								<?php echo esc_html( OEM_Helper::sanitize_marks( $question->negative_marks ) ); ?>
							</span>
						</div>
						<?php
					}
				}
				?>
			</div>
			<?php
			} else {
			?>
			<span class="oem-text-danger"><?php esc_html_e( 'Not Attempted', 'online-exam-management' ); ?></span>
			<?php
			}
			?>
		</div>
	</div>
	<?php
	}
	?>
</div>
<!-- subjects wise results -->
<?php require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/Subject_wise_result.php'; ?>