<?php
defined( 'ABSPATH' ) || die();
?>
<div class="oem-questions-box">
	<?php
	foreach ( $questions as $key => $question ) {
		$question_options = array_filter(
			$options, function( $option ) use ( $question ) {
				return $question->ID === $option->question_id;
			}
		);
	?>
	<div class="oem-question-box col">
		<div class="oem-question-detail">
			<div class="mb-1 oem-font-bold">
				<span class="border-bottom border-dark">
					<?php
					printf(
						wp_kses(
							/* translators: %s: Question number. */
							__( '<span class="oem-font-bold">Question No.</span> <span class="oem-font-extra-bold">%s</span>', 'online-exam-management' ),
							array(
								'span' => array( 'class' => array() )
							)
						),
						esc_html( $key + 1 )
					);
					?>
				</span>
				<span class="text-secondary float-right oem-font-small-medium"><?php echo esc_html( OEM_Helper::question_type( $question->type ) ); ?></span>
			</div>
			<span class="oem-question-maximum-marks oem-font-small-medium float-right d-inline-block ml-3">
				<?php
				printf(
					wp_kses(
						/* translators: %s: Maximum marks. */
						__( '<span class="oem-font-bold">Maximum marks:</span> <span class="oem-font-extra-bold">%s</span>', 'online-exam-management' ),
						array(
							'span' => array( 'class' => array() )
						)
					),
					esc_html( OEM_Helper::sanitize_marks( $question->maximum_marks ) )
				);
				?>
			</span>
			<span class="oem-question-description">
				<?php echo wp_kses_post( stripcslashes( $question->description ) ); ?>
			</span>
			<?php
			if ( 'subjective' !== $question->type ) {
			?>
			<div class="oem-question-options">
				<?php
				$question_correct_option_ids = array();

				$option_number = 0;
				foreach ( $question_options as $key => $option ) {
					$option_number++;
				?>
				<div class="oem-option-wrapper">
					<hr>
					<div class="oem-option-value">
						<span class="oem-option-number oem-font-bold"><?php echo esc_html( $option_number ); ?>.</span>
						<?php echo wp_kses_post( $option->value ); ?>
						<?php
						if ( $option->is_correct ) {
							array_push( $question_correct_option_ids, $option->ID );
						?>
						<br>
						-
						<span class="oem-text-success oem-font-bold">
							<?php esc_html_e( 'Correct', 'online-exam-management' ); ?>
						</span>
						<?php
						}
						?>
					</div>
				</div>
				<?php
				}
				?>
			</div>
			<?php
			}
			?>
		</div>

		<hr>

		<div class="oem-question-response">
			<div class="mb-1 oem-font-bold">
				<span class="border-bottom border-dark text-danger">
					<?php esc_html_e( "Student's Response:", 'online-exam-management' ); ?>
				</span>
			</div>
			<?php
			// Check if student attempted the question.
			$student_attempted_question = array_filter(
				$questions_attempted, function( $question_attempted ) use ( $question ) {
					return $question->ID === $question_attempted->ID;
				}
			);
			if ( ! empty( $student_attempted_question ) ) {
			?>
			<span class="oem-text-primary"><?php esc_html_e( 'Attempted', 'online-exam-management' ); ?></span>
			<div class="oem-question-student-answer mt-2">
				<?php
				if ( 'subjective' === $question->type ) {
					// Get subjective obtained marks of this question.
					$student_subjective_response = '';
					foreach ( $subjective_responses as $subjective_response ) {
						if ( $question->ID === $subjective_response->question_id ) {
							$student_subjective_response = $subjective_response;
							break;
						}
					}

					if ( $student_subjective_response ) {
						$student_obtained_marks = OEM_Helper::sanitize_marks( $student_subjective_response->sbj_marks_obtained );
					} else {
						$student_obtained_marks = 0;
					}
					?>
					<div class="text-right">
						<span class="oem-font-bold oem-font-small-medium">
							<?php esc_html_e( 'Obtained Marks:', 'online-exam-management' ); ?>
						</span>
						<span class="oem-text-success">
							<?php echo esc_html( $student_obtained_marks ); ?>
						</span>
					</div>
					<?php
				} else {
					?>
					<div class="mb-1 oem-font-bold">
						<span class="border-bottom border-dark text-danger">
							<?php esc_html_e( "Student's Answer:", 'online-exam-management' ); ?>
						</span>
					</div>
					<?php
					// Get student answer(s) of this question.
					$question_student_answers = array_filter(
						$student_answers,
						function( $student_answer ) use ( $question ) {
							return $question->ID === $student_answer->question_id;
						}
					);
					// Get student answer(s) option_id(s) of this question.
					$question_student_answers_option_ids = array_map(
						function( $question_student_answer ) {
							return $question_student_answer->option_id;
						},
						$question_student_answers
					);

					$option_numbers = array();
					$option_number  = 0;
					foreach ( $question_options as $key => $option ) {
						$option_number++;
						if ( in_array( $option->ID, $question_student_answers_option_ids ) ) {
							array_push( $option_numbers, $option_number );
						}
					}

					if ( ! empty( $option_numbers ) ) {
					?>
					<span class="oem-font-bold">
						<?php echo esc_html( implode( ', ', $option_numbers ) ); ?>
					</span>
					<?php
					}

					// Check if two arrays are equal.
					$same = ( count( $question_correct_option_ids ) === count( $question_student_answers_option_ids ) && ! array_diff( $question_correct_option_ids, $question_student_answers_option_ids ) );
					?>
					-
					<?php
					if ( $same ) {
						// Student's answer is correct.
						?>
						<span class="oem-text-success oem-font-bold">
							<?php esc_html_e( 'Correct', 'online-exam-management' ); ?>
						</span>
						<div class="text-right">
							<span class="oem-font-bold oem-font-small-medium">
								<?php esc_html_e( 'Obtained Marks:', 'online-exam-management' ); ?>
							</span>
							<span class="oem-text-success">
								<?php echo esc_html( OEM_Helper::sanitize_marks( $question->maximum_marks ) ); ?>
							</span>
						</div>
						<?php
					} else {
						// Student's answer is incorrect.
						?>
						<span class="oem-text-danger oem-font-bold">
							<?php esc_html_e( 'Incorrect', 'online-exam-management' ); ?>
						</span>
						<div class="text-right">
							<span class="oem-font-bold oem-font-small-medium">
								<?php esc_html_e( 'Negative Marks:', 'online-exam-management' ); ?>
							</span>
							<span class="oem-text-danger">
								<?php echo esc_html( OEM_Helper::sanitize_marks( $question->negative_marks ) ); ?>
							</span>
						</div>
						<?php
					}
				}
				?>
			</div>
			<?php
			} else {
			?>
			<span class="oem-text-danger"><?php esc_html_e( 'Not Attempted', 'online-exam-management' ); ?></span>
			<?php
			}
			?>
		</div>
	</div>
	<?php
	}
	?>
</div>
