<?php
defined( 'ABSPATH' ) || die();
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Database.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Student.php';

class OEM_Notify {

	public static function notify_for_student_admission( $data ) {
		$settings = OEM_Helper::get_email_template();

		$user_id = $data['user_id'];
		$exam_id = $data['exam_id'];		

		if ( $settings['registration_template'] ) {
			global $wpdb;
			$student = $wpdb->get_row(
				$wpdb->prepare(
					'SELECT * FROM ' . OEM_STUDENTS . ' as s 
                JOIN ' . OEM_USERS . ' as u ON s.user_id = u.ID
                WHERE s.user_id = %d AND s.exam_id = %d',
					$exam_id, $user_id )
			);

			$email_to = $student->user_email;

			$for  = 'registration_template';
			$name = $student->name;

			$placeholders = array(
				'[STUDENT_NAME]'   => $student->name,
				'[CLASS]'          => stripcslashes( $student->class ),
				'[SECTION]'        => stripcslashes( $student->section ),
				'[ROLL_NUMBER]'    => $student->roll_number,
				'[LOGIN_USERNAME]' => $student->user_login,
				'[LOGIN_EMAIL]'    => $student->user_email,
			);

			if ( $email_to ) {
				// Student Admission Email template.
				$subject = $settings['registration_subject'];
				$body    = $settings['email_registration_body'];

				OEM_Helper::send_email( $email_to, $subject, $body, $name, $for, $placeholders );
			}
		}
	}
	
	public static function notify_for_student_result( $data ) {
		$settings = OEM_Helper::get_email_template();
		$exam_id    = $data['exam_id'];
		$student_id = $data['student_id'];

		if ( $settings['result_template'] ) {
			global $wpdb;
			
			$student = OEM_M_Student::fetch_student( $student_id, $exam_id );
			$exam = OEM_M_Exam::fetch_exam( $student->exam_id );
			
			require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Question.php';
			require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Response.php';
			require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Result.php';
			
			// $name = $student->name;
			$exam_id    = $exam->ID;
			$student_id = $student->ID;
			$email_to = $student->login_email;

			// Total questions in this exam.
			$questions_count = OEM_M_Question::get_questions_count( $exam_id );

			// Total maximum marks of questions in this exam.
			$maximum_marks_sum = OEM_M_Question::get_questions_maximum_marks_sum( $exam_id );

			// Passing percentage.
			$passing_percentage = OEM_Helper::sanitize_marks( $exam->passing_percentage );

			require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result_stats.php';		

			$for  = 'result_template';	

			if ( $email_to ) {
				// Student Admission Email template.
				$subject = $settings['registration_subject'];
				$body    = " Exam Result Of $exam->exam_title <br>
							Student Name: $student->name <br>
							Student Roll Number: $student->roll_number <br>
							Total Questions : $questions_count<br>
							Questions Attempted: $questions_attempted_count<br>
							Correct Answers: $correct_answers_count<br>
							Maximum Marks: $incorrect_answers_count<br>
							Obtained Marks: $maximum_marks_sum<br> ";

				OEM_Helper::send_email( $email_to, $subject, $body, $name, $for, $placeholders );
			}
		}
	}
}
