<?php
defined( 'ABSPATH' ) || die();

class OEM_M_Subject {
	public static function fetch_query( $exam_id ) {
		$query = 'SELECT sj.ID, sj.exam_id, sj.subject_name, sj.subject_order, sj.is_default, COUNT(DISTINCT q.ID) as questions_count FROM ' . OEM_SUBJECTS . ' as sj 
		LEFT OUTER JOIN ' . OEM_QUESTIONS . ' as q ON q.subject_id = sj.ID 
		WHERE sj.exam_id = ' . absint( $exam_id );
		return $query;
	}

	public static function fetch_query_group_by() {
		$group_by = 'GROUP BY sj.ID';
		return $group_by;
	}

	public static function fetch_query_count( $exam_id ) {
		$query = 'SELECT COUNT(DISTINCT sj.ID) FROM ' . OEM_SUBJECTS . ' as sj WHERE sj.exam_id = ' . absint( $exam_id );
		return $query;
	}

	public static function get_subject( $subject_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT sj.ID FROM ' . OEM_SUBJECTS . ' as sj WHERE sj.ID = %d AND sj.exam_id = %d', $subject_id, $exam_id )
		);
	}

	public static function fetch_subject( $subject_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT sj.ID, sj.subject_name, sj.subject_order, sj.is_default FROM ' . OEM_SUBJECTS . ' as sj WHERE sj.ID = %d AND sj.exam_id = %d', $subject_id, $exam_id )
		);
	}

	public static function get_questions( $subject_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID FROM ' . OEM_QUESTIONS . ' as q WHERE q.subject_id = %d ORDER BY q.question_order ASC', $subject_id )
		);
	}

	public static function get_questions_count( $subject_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(q.ID) FROM ' . OEM_QUESTIONS . ' as q WHERE q.subject_id = %d ORDER BY q.question_order ASC', $subject_id )
		);
	}
}
