<?php
defined( 'ABSPATH' ) || die();

class OEM_M_Student {
	public static function fetch_query( $exam_id ) {
		$query = 'SELECT s.ID, s.exam_id, s.name, s.roll_number, s.class, s.section, s.phone, s.father_name, s.exam_photos, s.father_phone, u.user_login as username, u.user_email as login_email FROM ' . OEM_STUDENTS . ' as s
		LEFT OUTER JOIN ' . OEM_USERS . ' as u ON u.ID = s.user_id
		WHERE s.exam_id = ' . absint( $exam_id );
		return $query;
	}

	public static function fetch_query_group_by() {
		$group_by = 'GROUP BY s.ID';
		return $group_by;
	}

	public static function fetch_query_count( $exam_id ) {
		$query = 'SELECT COUNT(DISTINCT s.ID) FROM ' . OEM_STUDENTS . ' as s
		LEFT OUTER JOIN ' . OEM_USERS . ' as u ON u.ID = s.user_id
		WHERE s.exam_id = ' . absint( $exam_id );
		return $query;
	}

	public static function get_student( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT s.ID, s.user_id, s.photo_id FROM ' . OEM_STUDENTS . ' as s WHERE s.ID = %d AND s.exam_id = %d', $student_id, $exam_id )
		);
	}

	public static function fetch_student( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT s.ID, s.exam_id, s.name, s.roll_number, s.class, s.section, s.phone, s.address, s.father_name, s.father_phone, s.photo_id, s.gender, s.dob, s.id_number, s.user_id, u.user_login as username, u.user_email as login_email, s.record_user_id FROM ' . OEM_STUDENTS . ' as s
			LEFT OUTER JOIN ' . OEM_USERS . ' as u ON u.ID = s.user_id
			WHERE s.ID = %d AND s.exam_id = %d', $student_id, $exam_id )
		);
	}

	public static function fetch_students( $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT s.*, u.user_login as username, u.user_email as login_email FROM ' . OEM_STUDENTS . ' as s
			LEFT OUTER JOIN ' . OEM_USERS . ' as u ON u.ID = s.user_id
			WHERE s.exam_id = %d', $exam_id )
		);
	}
	public static function fetch_all_students( $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT s.*, u.user_login as username, u.user_email as login_email FROM ' . OEM_STUDENTS . ' as s
			LEFT OUTER JOIN ' . OEM_USERS . ' as u ON u.ID = s.user_id
			WHERE s.exam_id = %d', $exam_id )
		);
	}

	public static function fetch_exam_students_for_setup( $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT s.ID, s.record_user_id FROM ' . OEM_STUDENTS . ' as s
			LEFT OUTER JOIN ' . OEM_USERS . ' as ru ON ru.ID = s.record_user_id
			WHERE s.exam_id = %d AND s.user_id IS NULL AND s.record_user_id IS NOT NULL', $exam_id )
		);
	}

	public static function get_student_by_roll_number( $roll_number, $exam_id, $skip_student_id = NULL ) {
		global $wpdb;

		$prepare = array( $roll_number, $exam_id );

		if ( $skip_student_id ) {
			array_push( $prepare, $skip_student_id );
			$skip_student_query = ' AND s.ID != %d';
		} else {
			$skip_student_query = '';
		}

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT s.ID FROM ' . OEM_STUDENTS . ' as s WHERE s.roll_number = %s AND s.exam_id = %d' . $skip_student_query, $prepare )
		);
	}

	public static function get_student_by_roll_number_and_start_name( $roll_number, $name_start, $exam_id, $skip_student_id = NULL ) {
		global $wpdb;

		$prepare = array( $roll_number, $exam_id );

		if ( $skip_student_id ) {
			array_push( $prepare, $skip_student_id );
			$skip_student_query = ' AND s.ID != %d';
		} else {
			$skip_student_query = '';
		}

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT s.ID FROM ' . OEM_STUDENTS . ' as s WHERE s.roll_number = %s AND LOWER(s.name) LIKE "' . strtolower( $name_start ) . '%" AND s.exam_id = %d' . $skip_student_query, $prepare )
		);
	}

	public static function reset_recorded_user_id( $user_id, $exam_id ) {
		global $wpdb;

		$student_id = $wpdb->get_var(
			$wpdb->prepare( 'SELECT s.ID FROM ' . OEM_STUDENTS . ' as s WHERE s.record_user_id = %d AND s.exam_id = %d', $user_id, $exam_id )
		);

		if ( $student_id ) {
			$success = $wpdb->update( OEM_STUDENTS, array( 'record_user_id' => NULL ), array( 'ID' => $student_id ) );
		}
	}

	public static function get_logged_in_student() {
		global $wpdb;

		$user_id = get_current_user_id();

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT s.ID, s.name, s.roll_number, s.class, s.section, s.phone, s.father_name, s.father_phone, s.photo_id, s.user_id, s.exam_id, u.user_login as username, u.user_email as login_email FROM ' . OEM_STUDENTS . ' as s
			JOIN ' . OEM_USERS . ' as u ON u.ID = s.user_id
			JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = s.exam_id
			WHERE s.user_id = %d', $user_id )
		);
	}

	public static function get_logged_in_student_with_exam( $student_roll_number, $student_exam_id ) {
		global $wpdb;

		$user_id = get_current_user_id();
		$student_roll_number = "'$student_roll_number'";
		return $wpdb->get_results($wpdb->prepare
			( "SELECT s.ID, s.exam_id, ex.exam_at, ex.duration as exam_duration, ex.is_randomized, ex.is_activated as exam_is_activated FROM " . OEM_STUDENTS . " as s
			JOIN " . OEM_USERS . " as u ON u.ID = s.user_id
			JOIN " . OEM_EXAMS . " as ex ON ex.ID = s.exam_id
			WHERE s.roll_number = $student_roll_number  
			AND s.exam_id = $student_exam_id")
		);
	}
}
