<?php
defined( 'ABSPATH' ) || die();

class OEM_M_Result {
	public static function get_questions_attempted( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID, q.type, q.maximum_marks, q.negative_marks, rp.ID as response_id FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 GROUP BY q.ID', $student_id, $exam_id )
		);
	}

	public static function get_questions_attempted_subject( $student_id, $exam_id, $subject_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID, q.type, q.maximum_marks, q.negative_marks, rp.ID as response_id FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 AND q.ID = %d GROUP BY q.subject_id', $student_id, $exam_id, $subject_id )
		);
	}

	public static function get_questions_attempted_count( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(DISTINCT q.ID) FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1', $student_id, $exam_id )
		);
	}

	public static function get_questions_attempted_correct_options( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT op.ID, q.ID as question_id FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_OPTIONS . ' as op ON op.question_id = q.ID
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 AND op.is_correct = 1 GROUP BY op.ID ORDER BY q.ID', $student_id, $exam_id )
		);
	}

	public static function get_questions_attempted_correct_options_subject( $student_id, $exam_id, $subject_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT op.ID, q.ID as question_id FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_OPTIONS . ' as op ON op.question_id = q.ID
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 AND op.is_correct = 1 AND q.subject_id = %d GROUP BY op.ID ORDER BY q.ID', $student_id, $exam_id , $subject_id )
		);
	}

	public static function get_student_answers( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT ar.ID, q.ID as question_id, ar.option_id FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_ANSWERS . ' as ar ON ar.response_id = rp.ID
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 GROUP BY ar.ID ORDER BY ar.ID', $student_id, $exam_id )
		);
	}
	
	public static function get_student_answers_subject( $student_id, $exam_id, $subject_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT ar.ID, q.ID as question_id, ar.option_id FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_ANSWERS . ' as ar ON ar.response_id = rp.ID
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 AND q.subject_id = %d GROUP BY ar.ID ORDER BY ar.ID', $student_id, $exam_id, $subject_id)
		);
	}

	public static function get_subjective_marks_obtained( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID as question_id, rp.sbj_marks_obtained FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 AND q.type = "subjective" GROUP BY q.ID ORDER BY q.ID', $student_id, $exam_id )
		);
	}

	public static function get_subjective_marks_obtained_subject( $student_id, $exam_id, $subject_id) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID as question_id, rp.sbj_marks_obtained FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 AND q.subject_id = %d GROUP BY q.ID ORDER BY q.ID', $student_id, $exam_id, $subject_id)
		);
	}

	public static function get_subjective_marks_status( $student_id, $exam_id, $get_keys = false, $color = true ) {
		global $wpdb;

		$questions_with_no_obtained_marks_count = $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(DISTINCT q.ID) FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 AND q.type = "subjective" AND (rp.sbj_marks_obtained IS NULL OR rp.sbj_marks_obtained = "")', $student_id, $exam_id )
		);

		if ( $questions_with_no_obtained_marks_count > 0 ) {
			$key = 'incomplete';
		} else {
			$key = 'complete';
		}

		return OEM_Helper::get_subjective_marks_status( $key, $get_keys, $color );
	}

	public static function is_subjective_result_incomplete( $student_id, $exam_id ) {
		$subjective_marks_status = self::get_subjective_marks_status( $student_id, $exam_id, true, false );
		if ( 'incomplete' === $subjective_marks_status['key'] ) {
			return true;
		}

		return false;
	}

	public static function get_subjective_questions_attempted_with_responses( $student_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID, q.description, q.maximum_marks, rp.value as student_answer, rp.sbj_marks_obtained FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				LEFT OUTER JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND rp.is_submitted = 1 AND q.type = "subjective" GROUP BY q.ID ORDER BY sj.subject_order * 1 ASC, q.question_order * 1 ASC', $student_id, $exam_id )
		);
	}

	public static function get_subjective_question_attempted_with_response( $student_id, $exam_id, $question_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT DISTINCT q.ID, q.maximum_marks, rp.ID as response_id FROM ' . OEM_RESPONSES . ' as rp
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = rp.question_id
				JOIN ' . OEM_STUDENTS . ' as s ON s.ID = rp.student_id
				WHERE rp.student_id = %d AND q.exam_id = %d AND q.ID = %d AND rp.is_submitted = 1 AND q.type = "subjective"', $student_id, $exam_id, $question_id )
		);
	}
}
