<?php
defined( 'ABSPATH' ) || die();

class OEM_M_Record {
	public static function args( $current_page, $per_page, $count_total, $s_meta_query = array(), $s_columns_query = array() ) {
		$meta_query = array(
			array(
				'key'     => 'oem_account_type',
				'value'   => 'student',
				'compare' => '='
			)
		);

		if ( ! empty( $s_meta_query ) ) {
			$meta_query = array_merge( $meta_query, $s_meta_query );
		}

		$args = array(
			'meta_query'  => $meta_query,
			'count_total' => $count_total,
			'number'      => $per_page,
			'paged'       => $current_page,
			'orderby'     => 'user_registered',
			'order'       => 'DESC'
		);

		if ( ! empty( $s_columns_query ) ) {
			$args = array_merge( $args, $s_columns_query );
		}

		return $args;
	}

	public static function query( $current_page = 1, $per_page = 15, $s_meta_query = array(), $s_columns_query = array(), $count_total = true ) {
		return new \WP_User_Query( self::args( $current_page, $per_page, $count_total, $s_meta_query, $s_columns_query ) );
	}

	public static function find( $user_id ) {
		$args = self::args( 1, 1, false );

		$args['include'] = array( $user_id );

		$user_query = new \WP_User_Query( $args );

		$user = $user_query->get_results();

		if ( ! $user ) {
			return null;
		}

		return $user[0];
	}

	public static function delete( $user_id ) {
		$success = is_multisite() ? wpmu_delete_user( $user_id ) : wp_delete_user( $user_id );
		if ( ! $success ) {
			throw new \Exception( esc_html__( 'Unable to delete this registration.', 'online-exam-management' ) );
		}
	}

	public static function save( $user_id, $data ) {
		update_user_meta( $user_id, 'oem_account_type', 'student' );

		if ( isset( $data['reg_number'] ) && $data['reg_number'] ) {
			update_user_meta( $user_id, 'oem_reg_number', $data['reg_number'] );
		}

		if ( isset( $data['name'] ) && $data['name'] ) {
			update_user_meta( $user_id, 'oem_name', $data['name'] );
		}

		if ( isset( $data['phone'] ) && $data['phone'] ) {
			update_user_meta( $user_id, 'oem_phone', $data['phone'] );
		}

		if ( isset( $data['address'] ) && $data['address'] ) {
			update_user_meta( $user_id, 'oem_address', $data['address'] );
		}

		if ( isset( $data['father_name'] ) && $data['father_name'] ) {
			update_user_meta( $user_id, 'oem_father_name', $data['father_name'] );
		}

		if ( isset( $data['father_phone'] ) && $data['father_phone'] ) {
			update_user_meta( $user_id, 'oem_father_phone', $data['father_phone'] );
		}

		if ( isset( $data['photo_id'] ) && $data['photo_id'] ) {
			update_user_meta( $user_id, 'oem_photo_id', $data['photo_id'] );
		}
		
		if ( isset( $data['dob'] ) && $data['dob'] ) {
			update_user_meta( $user_id, 'oem_dob', $data['dob'] );
		}
		
		if ( isset( $data['gender'] ) && $data['gender'] ) {
			update_user_meta( $user_id, 'oem_gender', $data['gender'] );
		}

		if ( isset( $data['id_number'] ) && $data['id_number'] ) {
			update_user_meta( $user_id, 'oem_id_number', $data['id_number'] );
		}
	}

	public static function get_record_by_reg_number( $reg_number, $skip_user_id = NULL ) {
		$args = self::args( 1, 1, false );

		if ( $skip_user_id ) {
			$args['exclude'] = array( $skip_user_id );
		}

		$reg_number_meta_query = array(
			'key'     => 'oem_reg_number',
			'value'   => $reg_number,
			'compare' => '='
		);

		array_push( $args['meta_query'], $reg_number_meta_query );

		$user_query = new \WP_User_Query( $args );

		$user = $user_query->get_results();

		if ( ! $user ) {
			return null;
		}

		return $user[0];
	}

	public static function get_record_students_exams( $record_user_id ) {
		global $wpdb;

		$record_exams = $wpdb->get_results(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration, s.ID as student_id, s.roll_number FROM ' . OEM_STUDENTS . ' as s 
				JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = s.exam_id 
				WHERE s.record_user_id = %d GROUP BY ex.ID ORDER BY ex.exam_at DESC', $record_user_id )
		);

		return $record_exams;
	}

	public static function get_record_students_exams_id( $record_user_id ) {
		global $wpdb;

		$record_exams_id =$wpdb->get_col(
			$wpdb->prepare( 'SELECT ex.ID FROM ' . OEM_STUDENTS . ' as s 
				JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = s.exam_id 
				WHERE s.record_user_id = %d GROUP BY ex.ID ORDER BY ex.exam_at DESC', $record_user_id )
		);

		return $record_exams_id;
	}

	public static function get_record_students_exams_count( $record_user_id ) {
		global $wpdb;

		$record_exams_count = $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(DISTINCT ex.ID) FROM ' . OEM_STUDENTS . ' as s 
				JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = s.exam_id 
				WHERE s.record_user_id = %d', $record_user_id )
		);

		return $record_exams_count;
	}

	public static function get_past_exams( $record_user_id ) {
		global $wpdb;

		$now = OEM_Helper::now();

		$past_exams = $wpdb->get_results(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration, ex.exam_explaination_link, s.roll_number  FROM ' . OEM_STUDENTS . ' as s 
				JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = s.exam_id 
				JOIN ' . OEM_USERS . ' as ru ON ru.ID = s.record_user_id 
				WHERE (ADDTIME(ex.exam_at, SEC_TO_TIME(ex.duration*60)) < %s) AND s.record_user_id = %d GROUP BY ex.ID ORDER BY ex.exam_at DESC', $now, $record_user_id )
		);

		return $past_exams;
	}

	public static function get_upcoming_exams( $record_user_id ) {
		global $wpdb;

		$now = OEM_Helper::now();

		$upcoming_exams = $wpdb->get_results(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration, s.roll_number, u.ID as user_id FROM ' . OEM_STUDENTS . ' as s 
				JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = s.exam_id 
				JOIN ' . OEM_USERS . ' as ru ON ru.ID = s.record_user_id 
				LEFT OUTER JOIN ' . OEM_USERS . ' as u ON u.ID = s.user_id 
				WHERE (ex.exam_at > %s) AND s.record_user_id = %d GROUP BY ex.ID ORDER BY ex.exam_at DESC', $now, $record_user_id )
		);

		return $upcoming_exams;
	}

	public static function get_on_going_exam( $record_user_id ) {
		global $wpdb;

		$now = OEM_Helper::now();

		$on_going_exam = $wpdb->get_row(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration, ex.exam_explaination_link, s.roll_number  FROM ' . OEM_STUDENTS . ' as s 
				JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = s.exam_id 
				JOIN ' . OEM_USERS . ' as ru ON ru.ID = s.record_user_id 
				WHERE (ADDTIME(ex.exam_at, SEC_TO_TIME(ex.duration*60)) >= %s) AND (ex.exam_at <= %s) AND s.record_user_id = %d', $now, $now, $record_user_id )
		);

		return $on_going_exam;
	}

	public static function fetch_student_data( $record_id ) {
		global $wpdb;
        $query = $wpdb->get_row('SELECT s.ID as ID FROM ' . OEM_STUDENTS . ' as s
        LEFT OUTER JOIN ' . OEM_USERS . ' as u ON u.ID = s.user_id
        WHERE s.user_id = ' . absint( $record_id ));
        return $query;
    }

	public static function get_upcoming_exams_for_payment() {
		global $wpdb;

		$now = OEM_Helper::now();

		$upcoming_exams = $wpdb->get_results(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration, ex.exam_fee FROM ' . OEM_EXAMS . ' as ex 
				WHERE (ex.exam_at > %s) AND ex.show_in_payment_form = 1 GROUP BY ex.ID ORDER BY ex.exam_at DESC', $now )
		);

		return $upcoming_exams;
	}
}
