<?php
defined( 'ABSPATH' ) || die();

class OEM_M_Question {
	public static function fetch_query( $exam_id ) {
		$query = 'SELECT q.ID, q.exam_id, q.description, q.maximum_marks, q.negative_marks, q.question_order, q.type, sj.subject_name FROM ' . OEM_QUESTIONS . ' as q
		LEFT OUTER JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
		WHERE q.exam_id = ' . absint( $exam_id );
		return $query;
	}

	public static function fetch_query_group_by() {
		$group_by = 'GROUP BY q.ID';
		return $group_by;
	}

	public static function fetch_query_count( $exam_id ) {
		$query = 'SELECT COUNT(DISTINCT q.ID) FROM ' . OEM_QUESTIONS . ' as q
		LEFT OUTER JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
		WHERE q.exam_id = ' . absint( $exam_id );
		return $query;
	}

	public static function get_question( $question_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT q.ID FROM ' . OEM_QUESTIONS . ' as q WHERE q.ID = %d AND q.exam_id = %d', $question_id, $exam_id )
		);
	}

	public static function fetch_question( $question_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT q.ID, q.subject_id, q.description, q.maximum_marks, q.negative_marks, q.question_order, q.type FROM ' . OEM_QUESTIONS . ' as q WHERE q.ID = %d AND q.exam_id = %d', $question_id, $exam_id )
		);
	}

	public static function fetch_questions( $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID, q.description, q.maximum_marks, q.negative_marks, q.type FROM ' . OEM_QUESTIONS . ' as q
				LEFT OUTER JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
				WHERE q.exam_id = %d ORDER BY sj.subject_order * 1 ASC, q.question_order * 1 ASC', $exam_id )
		);
	}

	public static function fetch_question_by_index( $q_index, $exam_id, $is_randomized = false, $student_id = '' ) {
		global $wpdb;

		if ( $is_randomized ) {
			$question_order = 'rand(' . absint( $student_id ) . ') ';
		} else {
			$question_order = 'q.question_order * 1 ASC ';
		}

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT q.ID, q.description, q.maximum_marks, q.negative_marks, q.type, sj.subject_name  FROM ' . OEM_QUESTIONS . ' as q
				JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
				WHERE q.exam_id = %d
				ORDER BY sj.subject_order * 1 ASC, ' . $question_order . '
				LIMIT %d, 1', $exam_id, $q_index - 1 )
		);
	}

	public static function fetch_questions_with_ids( $exam_id, $is_randomized = false, $student_id = '' ) {
		global $wpdb;

		if ( $is_randomized ) {
			$question_order = 'rand(' . absint( $student_id ) . ')';
		} else {
			$question_order = 'q.question_order * 1 ASC';
		}

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID FROM ' . OEM_QUESTIONS . ' as q
				LEFT OUTER JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
				WHERE q.exam_id = %d
				ORDER BY sj.subject_order * 1 ASC, ' . $question_order, $exam_id )
		);
	}

	public static function fetch_question_by_id( $question_id, $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT q.ID, q.type FROM ' . OEM_QUESTIONS . ' as q WHERE q.ID = %d AND q.exam_id = %d', $question_id, $exam_id )
		);
	}

	public static function get_questions_count( $exam_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(DISTINCT q.ID) FROM ' . OEM_QUESTIONS . ' as q WHERE q.exam_id = %d', $exam_id )
		);
	}
	public static function get_questions_count_subject( $student_id, $exam_id, $subject_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(DISTINCT q.ID) FROM ' . OEM_QUESTIONS . ' as q 
			JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
			JOIN ' . OEM_RESPONSES . ' as r ON r.question_id = q.ID
			JOIN ' . OEM_STUDENTS . ' as s ON s.ID = r.student_id			
			WHERE q.exam_id = %d AND q.subject_id = %d 	', $exam_id, $subject_id, $student_id)
		);
	}	
	
	public static function get_questions_count_subject_count( $student_id, $exam_id, $subject_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(DISTINCT q.ID) FROM ' . OEM_QUESTIONS . ' as q 
			JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
			JOIN ' . OEM_RESPONSES . ' as r ON r.question_id = q.ID
			JOIN ' . OEM_STUDENTS . ' as s ON s.ID = r.student_id			
			WHERE q.exam_id = %d AND q.subject_id = %d AND r.student_id=%d AND r.is_submitted = 1	', $exam_id, $subject_id, $student_id)
		);
	}

	// public static function get_subjects_results($exam_id) {
	// 	return $wpdb->get_row(
	// 		$wpdb->prepare( 'SELECT q.ID, q.description, q.maximum_marks, q.negative_marks, q.type, sj.subject_name  FROM ' . OEM_QUESTIONS . ' as q
	// 			JOIN ' . OEM_SUBJECTS . ' as sj ON sj.ID = q.subject_id
	// 			WHERE q.exam_id = %d
	// 			ORDER BY sj.subject_order * 1 ASC, ' . $question_order . '
	// 			LIMIT %d, 1', $exam_id, $q_index - 1 )
	// 	);
	// }

	public static function get_questions_maximum_marks_sum( $exam_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COALESCE(SUM(q.maximum_marks), 0) FROM ' . OEM_QUESTIONS . ' as q WHERE q.exam_id = %d', $exam_id )
		);
	}

	public static function get_questions_maximum_marks_sum_subject( $exam_id, $subject_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COALESCE(SUM(q.maximum_marks), 0) FROM ' . OEM_QUESTIONS . ' as q WHERE q.exam_id = %d AND q.subject_id = %d', $exam_id, $subject_id )
		);
	}

	public static function get_options( $question_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT op.ID, op.value, op.is_correct FROM ' . OEM_OPTIONS . ' as op WHERE op.question_id = %d ORDER BY op.ID ASC', $question_id )
		);
	}

	public static function get_options_count( $question_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(op.ID) FROM ' . OEM_OPTIONS . ' as op WHERE op.question_id = %d ORDER BY op.ID ASC', $question_id )
		);
	}

	public static function get_exam_options( $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT q.ID as question_id, op.ID, op.value, op.is_correct FROM ' . OEM_OPTIONS . ' as op
				JOIN ' . OEM_QUESTIONS . ' as q ON q.ID = op.question_id
				JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = q.exam_id
				WHERE ex.ID = %d GROUP BY op.ID ORDER BY op.ID ASC', $exam_id )
		);
	}

	public static function get_subjects( $exam_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT sj.ID, sj.subject_name FROM ' . OEM_SUBJECTS . ' as sj WHERE sj.exam_id = %d ORDER BY sj.ID ASC', $exam_id )
		);
	}
}
