<?php
defined( 'ABSPATH' ) || die();

class OEM_M_Payment {
	public static function fetch_query() {
		$query = 'SELECT p.ID, p.amount, p.transaction_id, p.payment_method, p.status, p.receipt, p.created_at, p.record_user_id FROM ' . OEM_PAYMENTS . ' as p 
		LEFT OUTER JOIN ' . OEM_USERS . ' as ru ON ru.ID = p.record_user_id';
		return $query;
	}

	public static function fetch_query_group_by() {
		$group_by = 'GROUP BY p.ID';
		return $group_by;
	}

	public static function fetch_query_count() {
		$query = 'SELECT COUNT(DISTINCT p.ID) FROM ' . OEM_PAYMENTS . ' as p 
		LEFT OUTER JOIN ' . OEM_USERS . ' as ru ON ru.ID = p.record_user_id';
		return $query;
	}

	public static function get_payment( $payment_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT p.ID FROM ' . OEM_PAYMENTS . ' as p WHERE p.ID = %d', $payment_id )
		);
	}

	public static function fetch_payment( $payment_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT p.ID, p.amount, p.transaction_id, p.payment_method, p.status, p.receipt, p.access_type, p.created_at, p.record_user_id FROM ' . OEM_PAYMENTS . ' as p WHERE p.ID = %d', $payment_id )
		);
	}

	public static function get_payment_exams( $payment_id ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration FROM ' . OEM_EXAM_PAYMENT . ' as ep
			JOIN ' . OEM_EXAMS . ' as ex ON ex.ID = ep.exam_id 
			JOIN ' . OEM_PAYMENTS . ' as p ON p.ID = ep.payment_id 
		 	WHERE p.ID = %d GROUP BY ex.ID', $payment_id )
		);
	}

	public static function get_payment_by_receipt_number( $receipt_number, $skip_payment_id = NULL ) {
		global $wpdb;

		$prepare = array( $receipt_number );

		if ( $skip_payment_id ) {
			array_push( $prepare, $skip_payment_id );
			$skip_payment_query = ' AND p.ID != %d';
		} else {
			$skip_payment_query = '';
		}

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT p.ID FROM ' . OEM_PAYMENTS . ' as p WHERE p.receipt = %s' . $skip_payment_query, $prepare )
		);
	}

	public static function fetch_payment_by_order_id( $order_id, $payment_method = '' ) {
		global $wpdb;

		$prepare = array( $order_id );

		if ( $payment_method ) {
			array_push( $prepare, $payment_method );
			$payment_method_query = ' AND p.payment_method = %s';
		} else {
			$payment_method_query = '';
		}

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT p.ID, p.status, p.access_type, p.receipt, p.record_user_id FROM ' . OEM_PAYMENTS . ' as p WHERE p.order_id = %s' . $payment_method_query, $prepare )
		);
	}
}
