<?php
defined( 'ABSPATH' ) || die();

class OEM_M_Exam {
	public static function fetch_query() {
		$query = 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_center, ex.exam_at, ex.duration, ex.show_result_on_completion, COUNT(DISTINCT q.ID) as questions_count, COALESCE(SUM(q.maximum_marks), 0) as maximum_marks FROM ' . OEM_EXAMS . ' as ex
		LEFT OUTER JOIN ' . OEM_QUESTIONS . ' as q ON q.exam_id = ex.ID';
		return $query;
	}

	public static function fetch_query_group_by() {
		$group_by = 'GROUP BY ex.ID';
		return $group_by;
	}

	public static function fetch_query_count() {
		$query = 'SELECT COUNT(DISTINCT ex.ID) FROM ' . OEM_EXAMS . ' as ex
		LEFT OUTER JOIN ' . OEM_QUESTIONS . ' as q ON q.exam_id = ex.ID';
		return $query;
	}

	public static function fetch_students_query() {
		$query = 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration, COUNT(DISTINCT s.ID) as students_count FROM ' . OEM_EXAMS . ' as ex
		LEFT OUTER JOIN ' . OEM_STUDENTS . ' as s ON s.exam_id = ex.ID';
		return $query;
	}

	public static function fetch_students_query_count() {
		$query = 'SELECT COUNT(DISTINCT ex.ID) FROM ' . OEM_EXAMS . ' as ex
		LEFT OUTER JOIN ' . OEM_STUDENTS . ' as s ON s.exam_id = ex.ID';
		return $query;
	}

	public static function fetch_results_query() {
		$query = 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration, ex.show_result_on_completion, ex.show_result_in_form FROM ' . OEM_EXAMS . ' as ex';
		return $query;
	}

	public static function fetch_results_query_count() {
		$query = 'SELECT COUNT(DISTINCT ex.ID) FROM ' . OEM_EXAMS . ' as ex';
		return $query;
	}

	public static function get_exam( $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT ex.ID FROM ' . OEM_EXAMS . ' as ex WHERE ex.ID = %d', $exam_id )
		);
	}

	public static function get_exam_roll_number_settings( $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT ex.ID, ex.roll_no_prefix, ex.roll_no_base, ex.last_roll_no_index FROM ' . OEM_EXAMS . ' as ex WHERE ex.ID = %d', $exam_id )
		);
	}

	public static function get_exam_title( $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code FROM ' . OEM_EXAMS . ' as ex WHERE ex.ID = %d', $exam_id )
		);
	}

	public static function fetch_exam( $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_center, ex.exam_at, ex.exam_fee, ex.duration, ex.passing_percentage, ex.instructions, ex.is_randomized, ex.is_activated, ex.group_by_subject, ex.show_result_on_completion, ex.show_result_in_form, ex.show_in_payment_form, ex.roll_no_prefix, ex.roll_no_base, ex.last_roll_no_index, ex.exam_explaination_link FROM ' . OEM_EXAMS . ' as ex WHERE ex.ID = %d', $exam_id )
		);
	}

	public static function get_exams_by_keyword( $keyword, $skip_exam_id = 0 ) {
		global $wpdb;

		return $wpdb->get_results(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at FROM ' . OEM_EXAMS . ' as ex WHERE ex.ID != %d AND (ex.exam_title LIKE "%%%s%%" OR ex.exam_code LIKE "%%%s%%")', $skip_exam_id, $wpdb->esc_like( $keyword ), $wpdb->esc_like( $keyword ) )
		);
	}

	public static function fetch_exam_instructions( $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT ex.instructions FROM ' . OEM_EXAMS . ' as ex WHERE ex.ID = %d', $exam_id )
		);
	}

	public static function get_maximum_marks( $exam_id ) {
		global $wpdb;

		return $wpdb->get_var(
			$wpdb->prepare( 'SELECT COALESCE(SUM(q.maximum_marks), 0) as maximum_marks FROM ' . OEM_EXAMS . ' as ex
				LEFT OUTER JOIN ' . OEM_QUESTIONS . ' as q ON q.exam_id = ex.ID
				WHERE ex.ID = %d', $exam_id )
		);
	}

	public static function get_default_subject( $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT sj.ID FROM ' . OEM_SUBJECTS . ' as sj WHERE sj.is_default = 1 AND sj.exam_id = %d', $exam_id )
		);
	}

	public static function has_subjective_question( $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT q.ID FROM ' . OEM_QUESTIONS . ' as q WHERE q.exam_id = %d AND q.type = "subjective"', $exam_id )
		);
	}

	public static function get_stats() {
		global $wpdb;

		$exams = $wpdb->get_results( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration FROM ' . OEM_EXAMS . ' as ex ORDER BY ex.exam_at DESC' );

		$count_total     = count( $exams );
		$count_on_going  = 0;
		$count_completed = 0;
		$count_upcoming  = 0;

		$upcoming_exams = array();
		$recent_exams   = array();

		foreach ( $exams as $exam ) {
			$status = OEM_Helper::get_exam_status_text( $exam->exam_at, $exam->duration, false, true );
			$key    = $status['key'];

			if ( 'completed' === $key ) {
				$count_completed++;

				if ( count( $recent_exams ) < 7 ) {
					array_push( $recent_exams, $exam );
				}

			} elseif ( 'active' === $key ) {
				$count_on_going++;

			} else {
				$count_upcoming++;

				if ( count( $upcoming_exams ) < 5 ) {
					array_push( $upcoming_exams, $exam );
				}
			}
		}

		return array(
			'count_total'     => $count_total,
			'count_on_going'  => $count_on_going,
			'count_completed' => $count_completed,
			'count_upcoming'  => $count_upcoming,
			'upcoming_exams'  => $upcoming_exams,
			'recent_exams'    => $recent_exams,
		);
	}

	public static function get_exam_stats() {
		global $wpdb;

		$now = OEM_Helper::now();

		$count_total = $wpdb->get_var( 'SELECT COUNT(ex.ID) FROM ' . OEM_EXAMS . ' as ex' );

		$count_on_going = $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(ex.ID) FROM ' . OEM_EXAMS . ' as ex WHERE (ADDTIME(ex.exam_at, SEC_TO_TIME(ex.duration*60)) >= %s) AND (ex.exam_at <= %s)', $now, $now )
		);

		$count_completed = $wpdb->get_var(
			$wpdb->prepare( 'SELECT COUNT(ex.ID) FROM ' . OEM_EXAMS . ' as ex WHERE ADDTIME(ex.exam_at, SEC_TO_TIME(ex.duration*60)) < %s', $now )
		);

		$recent_exams = $wpdb->get_results( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration FROM ' . OEM_EXAMS . ' as ex ORDER BY ex.exam_at DESC LIMIT 7' );

		$upcoming_exams = $wpdb->get_results(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration FROM ' . OEM_EXAMS . ' as ex WHERE ex.exam_at > %s ORDER BY ex.exam_at DESC LIMIT 7', $now )
		);

		$count_upcoming = count( $upcoming_exams );

		return array(
			'count_total'     => $count_total,
			'count_on_going'  => $count_on_going,
			'count_completed' => $count_completed,
			'count_upcoming'  => $count_upcoming,
			'upcoming_exams'  => $upcoming_exams,
			'recent_exams'    => $recent_exams,
		);
	}

	public static function get_shortcode_exams() {
		global $wpdb;

		return $wpdb->get_results( 'SELECT ex.ID, ex.exam_title, ex.exam_code FROM ' . OEM_EXAMS . ' as ex WHERE ex.show_result_in_form = 1' );
	}

	public static function get_shortcode_exam( $exam_id ) {
		global $wpdb;

		return $wpdb->get_row(
			$wpdb->prepare( 'SELECT ex.ID, ex.exam_title, ex.exam_code, ex.exam_at, ex.duration, ex.passing_percentage FROM ' . OEM_EXAMS . ' as ex WHERE ex.ID = %d AND ex.show_result_in_form = 1', $exam_id )
		);
	}
}
