(function($) {
	'use strict';
	$(document).ready(function() {
		// Initialize current question index and total number of questions to 0.
		var oemCurrentQIndex = 0;
		var oemTotalQuestions = 0;

		// If user refresh the page and exam is active, then show the first question.
		var oemQuesionBox = $('.oem-question-box');
		if(oemQuesionBox.length > 0) {
			oemLoadQuestion(1);
		}

		    // Print answer sheet.
			$(document).on("click", "#oem-print-answer-sheet-btn", function () {
				var targetId = "#oem-print-answer-sheet";
				var title = $(this).data("title");
				if (title) {
				  title = "<title>" + title + "</title>";
				}
				var styleSheets = $(this).data("styles");
		  
				oemPrint(targetId, title, styleSheets);
			  });

			// Print.
			function oemPrint(targetId, title, styleSheets, css = "") {
				var target = $(targetId).html();
		  
				var frame = $("<iframe />");
				frame[0].name = "frame";
				frame.css({ position: "absolute", top: "-1000000px" });
		  
				var that = frame.appendTo("body");
				var frameDoc = frame[0].contentWindow
				  ? frame[0].contentWindow
				  : frame[0].contentDocument.document
				  ? frame[0].contentDocument.document
				  : frame[0].contentDocument;
				frameDoc.document.open();
		  
				// Create a new HTML document.
				frameDoc.document.write("<html><head>" + title);
				frameDoc.document.write("</head><body>");
		  
				// Append the external CSS file.
				styleSheets.forEach(function (styleSheet, index) {
				  $(that)
					.contents()
					.find("head")
					.append(
					  '<link href="' +
						styleSheet +
						'" rel="stylesheet" type="text/css" referrerpolicy="origin" />'
					);
				});
		  
				if (css) {
				  frameDoc.document.write("<style>" + css + "</style>");
				}
		  
				// Append the target.
				frameDoc.document.write(target);
				frameDoc.document.write("</body></html>");
				frameDoc.document.close();
		  
				setTimeout(function () {
				  window.frames["frame"].focus();
				  window.frames["frame"].print();
				  frame.remove();
				}, 1000);
			  }

		// Load exam instructions.
		function oemLoadExamInstructions(data = {}) {
			data['action'] = 'oem-p-load-exam-instructions';
			data['oem_nonce'] = oemnonce;
			var student_roll_number = $('#student_roll_number').val();
			data['student_roll_number'] = student_roll_number;
			var student_exam_id = $('#student_exam_id').val();
			data['student_exam_id'] = student_exam_id;
			$.dialog({
				title: '',
				content: function() {
					var self = this;
					return $.ajax({
						url: oemajaxurl,
						data: data,
						type: 'POST',
						beforeSend: function() {
							return true;
						},
						success: function(response) {
							if(response.success) {
								console.log(response)
								self.setContent(response.data.exam_instructions);
							} else {
								self.setContent('');
							}
						},
						error: function(response) {
							self.setContent('');
						},
						complete: function(event, xhr, settings) {
						},
					});
				},
				theme: 'bootstrap',
				useBootstrap: false,
				columnClass: 'xlarge',
				backgroundDismiss: true
			});
		}

		function oemPrint(targetId, title, styleSheets, css = '') {
            var target = $(targetId).html();

            var frame = $('<iframe />');
            frame[0].name = 'frame';
            frame.css({ 'position': 'absolute', 'top': '-1000000px' });

            var that = frame.appendTo('body');
            var frameDoc = frame[0].contentWindow ? frame[0].contentWindow : frame[0].contentDocument.document ? frame[0].contentDocument.document : frame[0].contentDocument;
            frameDoc.document.open();

            // Create a new HTML document.
            frameDoc.document.write('<html><head>' + title);
            frameDoc.document.write('</head><body>');

            // Append the external CSS file.
            styleSheets.forEach(function(styleSheet, index) {
                $(that).contents().find('head').append('<link href="' + styleSheet + '" rel="stylesheet" type="text/css" referrerpolicy="origin" />');
            });

            if(css) {
                frameDoc.document.write('<style>' + css + '</style>');
            }

            // Append the target.
            frameDoc.document.write(target);
            frameDoc.document.write('</body></html>');
            frameDoc.document.close();

            setTimeout(function () {
                window.frames["frame"].focus();
                window.frames["frame"].print();
                frame.remove();
            }, 1000);
        }

		$(document).on('click', '#oem-exam-result-pdf-button', function() {
			var targetId = '#oem-answersheet-block';
			var title = $(this).data('title');
			if(title) {
				title = '<title>' + title  + '</title>';
			}
			var styleSheets = $(this).data('styles');
		
			oemPrint(targetId, title, styleSheets);
		});

		//Download the answer key 
		/*function oemDownloadanswewrkey(exam_id, student_id) {			
			// console.log(`${exam_id} and ${student_id}`);		
			$('#answersheet').toggle();	
			$.ajax({
				url: oemajaxurl,
				data: {
					action: 'oem-p-download-exam-key',
					student_id: student_id,
					exam_id: exam_id
				},
				type: 'POST',
				success: function(response) {
					// console.log(response);
					// answersheet
					
					$('.modal-content').html(response);
					 
				}
			});
		}*/

		// Load the question with options.
		function oemLoadQuestion(q_index = '', data = {}) {
			data['action'] = 'oem-p-load-question';
			data['oem_nonce'] = oemnonce;
			data['next_q_index'] = q_index;

			var currentQuestion = $('#oem-current-question');

			var student_roll_number = $('#student_roll_number').val();
			var student_exam_id = $('#student_exam_id').val();

			var questionType = currentQuestion.data('question-type');
			if('obj_single' === questionType) {
				var optionValue = $('.oem-response-input:checked').val();
				data['option'] = optionValue;

			} else if('obj_multi' === questionType) {
				var optionValues = [];
				$('.oem-response-input:checked').each(function() {
					optionValues.push($(this).val());
				});
				data['option[]'] = optionValues;

			} else {
				var optionValue = $('.oem-response-input').val();
				data['option'] = optionValue;
			}

			data['current_question_id'] = currentQuestion.val();
			data['student_roll_number'] = student_roll_number;
			data['student_exam_id'] = student_exam_id;

			$.ajax({
				url: oemajaxurl,
				data: data,
				type: 'POST',
				beforeSend: function() {
					return true;
				},
				success: function(response) {
					if(response.success) {
						// Show the question.
						$('.oem-question-box').html(response.data.html_question);

						// Update the current question index.
						oemCurrentQIndex = response.data.current_q_index;

						// Update the total number of questions.
						oemTotalQuestions = response.data.total_questions;

						// Update previous button.
						var oemPreviousQuestionBtn = $('#oem-previous-btn');
						if(oemCurrentQIndex < 2) {
							// Hide previous question button if current question index is less than 2.
							oemPreviousQuestionBtn.hide();
						} else {
							// Show the previous question button.
							oemPreviousQuestionBtn.show();
						}

						var finishExam = $('.oem-finish-exam');

						// Update next button.
						var oemNextQuestionBtn = $('#oem-save-next-btn');
						if(oemCurrentQIndex >= oemTotalQuestions) {
							// Rename next question button to "Save" if current question index is equal to or greater than total number of questions.
							oemNextQuestionBtn.html(oemNextQuestionBtn.data('save-text'));
							oemNextQuestionBtn.data('last-question', '1');
							finishExam.show();
						} else {
							// Rename next question button to "Next".
							oemNextQuestionBtn.html(oemNextQuestionBtn.data('next-text'));
							oemNextQuestionBtn.data('last-question', '');
							finishExam.hide();
						}

						// Mark or unmark for review.
						var showUnmarkForReview = response.data.show_unmark_for_review;

						var oemMarkUnmarkBtn = $('#oem-mark-for-review-next-btn');
						if(showUnmarkForReview) {
							oemMarkUnmarkBtn.html(oemMarkUnmarkBtn.data('unmark-text'));
							oemMarkUnmarkBtn.data('unmark', '1');
						} else {
							oemMarkUnmarkBtn.html(oemMarkUnmarkBtn.data('mark-text'));
							oemMarkUnmarkBtn.data('unmark', '');
						}

						// Update the questions navigation.
						$('.oem-question-palette-wrapper').html(response.data.html_question_palette);
					}
				},
				error: function(response) {
				},
				complete: function(event, xhr, settings) {
				},
			});
		}

		// When start exam button is clicked, show the first question.
		$(document).on('click', '#oem-start-exam-btn', function() {
			window.location.reload();
		});

		// When next button is clicked, show the next question.
		$(document).on('click', '#oem-save-next-btn', function() {
			if($(this).data('last-question')) {
				oemCurrentQIndex--;
			}
			oemLoadQuestion(oemCurrentQIndex + 1, { 'submit_response': true });
		});

		// When mark for review and next button is clicked, show the next question with additional parameter.
		$(document).on('click', '#oem-mark-for-review-next-btn', function() {
			if($(this).data('unmark')) {
				var data = { 'unmark_for_review': true };
			} else {
				var data = { 'mark_for_review': true };
			}
			oemLoadQuestion(oemCurrentQIndex, data);
		});

		// When previous button is clicked, show the previous question.
		$(document).on('click', '#oem-previous-btn', function() {
			oemLoadQuestion(oemCurrentQIndex - 1);
		});

		// When clear button is clicked, clear the response of the question.
		$(document).on('click', '#oem-clear-btn', function() {
			oemLoadQuestion(oemCurrentQIndex, { 'clear_response': true });
		});

		// When question index button is clicked, show the question with that index.
		$(document).on('click', '.oem-question-index-btn', function() {
			var qIndex = $(this).data('q-index');
			oemLoadQuestion(qIndex);
		});

		// When view exam instructions button is clicked, show the exam instructions.
		$(document).on('click', '.oem-view-exam-instructions-btn', function() {
			oemLoadExamInstructions();
		});

		// Finish exam button message.
		$(document).on('click', '.oem-finish-exam-button', function(e) {
			e.preventDefault();
			var button = $(this);
			if(window.confirm(button.data('confirm'))) {
				alert(button.data('message'));
				window.location.href = button.attr('href');
			
			}
		});

		//Download the answer key
		$(document).on('click', '.answer_key_download', function(e) {
			var exam_id    = $(this).data('exam_id');
			var student_id = $(this).data('student_id');
			// console.log(`${exam_id} and ${student_id}`);
			// oemDownloadanswewrkey(exam_id, student_id);
			$.ajax({
				url: oemajaxurl,
				data: {
					action: 'oem-p-download-exam-key',
					student_id: student_id,
					exam_id: exam_id
				},
				type: 'POST',
				success: function(response) {
					// answersheet
					$('#answersheet').toggle();
					$('.modal-content').html(response);
				}
			});
		});
		$('.close_cutom_modal').on('click', function(){
			$('#answersheet').hide(500);
		});
		// $( function() {
		// 	$( "#dialog" ).dialog();
		//   } );

		// Loading icon variables.
		var loaderContainer = $('<span/>', {
			'class': 'oem-loader oem-ml-2 oem-mt-1'
		});
		var loader = $('<img/>', {
			'src': oemadminurl + 'images/spinner.gif',
			'class': 'oem-loader-image'
		});

		function oemReloadSuccess(message) {
			toastr.success(
				message,
				'',
				{
					timeOut: 2500,
					fadeOut: 2500,
					closeButton: true,
					progressBar: true,
					onHidden: function() {
						window.location.reload();
					}
				}
			);
		}

		// Function: Before submit.
		function oemBeforeSubmit(button) {
			$('div.oem-text-danger').remove();
			$(".oem-is-invalid").removeClass("oem-is-invalid");
			button.prop('disabled', true);
			loaderContainer.insertAfter(button);
			loader.appendTo(loaderContainer);
			return true;
		}

		// Function: Display form erros.
		function oemDisplayFormErrors(response, formId) {
			if(response.data && $.isPlainObject(response.data)) {
				$(formId + ' :input').each(function() {
					var input = this;
					$(input).removeClass('oem-is-invalid');
					if(response.data[input.name]) {
						var errorSpan = '<div class="oem-text-danger mt-1">' + response.data[input.name] + '</div>';
						$(input).addClass('oem-is-invalid');
						$(errorSpan).insertAfter(input);
					}
				});
			} else {
				var errorSpan = '<div class="oem-text-danger mt-3">' + response.data + '<hr></div>';
				$(errorSpan).insertBefore(formId);
				toastr.error(response.data);
			}
		}

		// Function: Display form error.
		function oemDisplayFormError(response, formId, button) {
			button.prop('disabled', false);
			var errorSpan = '<div class="oem-text-danger mt-2"><span class="oem-font-bold">' + response.status + '</span>: ' + response.statusText + '<hr></div>';
			$(errorSpan).insertBefore(formId);
			toastr.error(response.data);
		}

		// Function: Complete.
		function oemComplete(button) {
			button.prop('disabled', false);
			loaderContainer.remove();
		}

		// Function: Action.
		function oemAction(event, element, data, performActions, color = 'red') {
			event.preventDefault();
			var title = $(element).data('message-title');
			var content = $(element).data('message-content');
			var cancel = $(element).data('cancel');
			var submit = $(element).data('submit');
			$.confirm({
				title: title,
				content: content,
				type: color,
				useBootstrap: false,
				buttons: {
					formSubmit: {
						text: submit,
           				btnClass: 'btn-' + color,
						action: function () {
							$.ajax({
								data: data,
								url: ajaxurl,
								type: 'POST',
								beforeSend: function(xhr) {
								},
								success: function(response) {
									if(response.success) {
										toastr.success(
											response.data.message,
											'',
											{
												timeOut: 600,
												fadeOut: 600,
												closeButton: true,
												progressBar: true,
												onHidden: function() {
													performActions(response);
												}
											}
										);
									} else {
										toastr.error(response.data);
									}
								},
								error: function(response) {
									toastr.error(response.status + ': ' + response.statusText);
								}
							});
						}
					},
					cancel: {
						text: cancel,
						action: function () {
						}
					}
				}
			});
		}

		// Custom file input.
		$(document).on('change', '.custom-file-input', function() {
			var fileName = $(this).val().split('\\').pop();
			$(this).siblings('.custom-file-label').addClass('selected').html(fileName);
		});

		// Shortcode: Load exam results.
		var loadExamResultsFormId = '#oem-p-load-exam-results-form';
		var loadExamResultsForm = $(loadExamResultsFormId);
		var loadExamResultsBtn = $('#oem-p-load-exam-results-btn');
		var examResults = $('.oem-exam-results');
		loadExamResultsForm.ajaxForm({
			beforeSubmit: function(arr, $form, options) {
				return oemBeforeSubmit(loadExamResultsBtn);
			},
			success: function(response) {
				if(response.success) {
					examResults.html(response.data.html);
				} else {
					oemDisplayFormErrors(response, loadExamResultsFormId);
					examResults.html('');
				}
			},
			error: function(response) {
				oemDisplayFormError(response, loadExamResultsFormId, loadExamResultsBtn);
				examResults.html('');
			},
			complete: function(event, xhr, settings) {
				oemComplete(loadExamResultsBtn);
			}
		});

		// Shortcode: Register.
		var registerFormId = '#oem-p-register-form';
		var registerForm = $(registerFormId);
		var registerBtn = $('#oem-p-register-btn');
		registerForm.ajaxForm({
			beforeSubmit: function(arr, $form, options) {
				return oemBeforeSubmit(registerBtn);
			},
			success: function(response) {
				if(response.success) {
					registerForm[0].reset();
					oemReloadSuccess(response.data.message);
				} else {
					oemDisplayFormErrors(response, registerFormId);
				}
			},
			error: function(response) {
				oemDisplayFormError(response, registerFormId, registerBtn);
			},
			complete: function(event, xhr, settings) {
				oemComplete(registerBtn);
			}
		});

		// photo capture.
		var photoFormId = '#oem-p-photo-form';
		var photoForm = $(photoFormId);
		var photoBtn = $('#oem-p-photo-btn');
		photoForm.ajaxForm({
			beforeSubmit: function(arr, $form, options) {
				return oemBeforeSubmit(photoBtn);
			},
			success: function(response) {
				if(response.success) {
					photoForm[0].reset();
					oemReloadSuccess(response.data.message);
				} else {
					oemDisplayFormErrors(response, photoFormId);
				}
			},
			error: function(response) {
				oemDisplayFormError(response, photoFormId, photoBtn);
			},
			complete: function(event, xhr, settings) {
				oemComplete(photoBtn);
			}
		});

		// Payment.
		var paymentFormId = '#oem-p-payment-form';
		var paymentForm = $(paymentFormId);
		var paymentBtn = $('#oem-p-payment-btn');
		var paymentResponse = $('.oem-payment-response');
		var paymentMethods = $('.oem-payment-methods');
		paymentForm.ajaxForm({
			beforeSubmit: function(arr, $form, options) {
				return oemBeforeSubmit(paymentBtn);
			},
			success: function(response) {
				if(response.success) {
					var data = response.data.json ? JSON.parse(response.data.json) : false;
					var html = response.data.html;
					paymentResponse.html(html);
					if(data.free) {
						oemReloadSuccess(data.message);
					} else {
						if('razorpay' === data.payment_method) {
							var options = {
								"key": data.razorpay_key,
								"amount": data.amount_x_100,
								"currency": data.currency,
								"name": data.title,
								"description": data.description,
								"image": data.image,
								"order_id": data.order_id,
								"handler": function (response) {
									// Send Razorpay data to server.
									var razorpayData = {
										'action': 'oem-razorpay-handler',
										'oem_nonce': oemnonce
									};

									if(response.error) {
										razorpayData['error_code'] = response.error.code;
										razorpayData['error_description'] = response.error.description;
										razorpayData['error_field'] = response.error.field;
									} else {
										for(var key in response) {
											razorpayData[key] = response[key];
										}
									}

									$.ajax({
										type: 'POST',
										url: oemajaxurl,
										data: razorpayData,
										success: function (response) {
											if (response.success) {
												oemReloadSuccess(response.data.message);
											} else {
												toastr.error(response.data);
											}
										},
										error: function (response) {
											toastr.error(response.statusText);
										},
										dataType: 'json'
									});
								},
								"prefill": {
									"name": data.name,
									"email": data.login_email,
									"contact": data.phone,
								},
								"notes": {
									"address": data.address,
								},
								"theme": {
									"color": "#F37254"
								}
							};

							var rzp = new Razorpay(options);
							rzp.open();
						} if('stripe' === data.payment_method) {
							var options = {
									'key': data.stripe_key,
									"image": data.image,
									"order_id": data.order_id,
									'token': function(token) {
										var stripeData = {
											'action': 'oem-stripe-handler',
											'oem_nonce': oemnonce,
											'security': data.security,
											"order_id": data.order_id,
											"amount": data.amount_x_100,
											'stripeToken': token.id,
											'stripeEmail': token.email
										}
									$.ajax({
										type: 'POST',
										url: oemajaxurl,
										data: stripeData,
										success: function (response) {
											if (response.success) {
												oemReloadSuccess(response.data.message);
											} else {
												toastr.error(response.data);
											}
										},
										error: function (response) {
											toastr.error(response.statusText);
										},
										dataType: 'json'
									});
								}};
								// Initialize Stripe.
						 		var stripe = StripeCheckout.configure(options);

						 		// Open Stripe payment window.
								$(document).on('click', '#oem-stripe-btn', function(e) {
									stripe.open({
										name: data.name,
										description: data.description,
										currency: data.currency,
										amount: parseFloat(data.amount_x_100)
									});
									e.preventDefault();
								});

								// Close stripe checkout on page navigation.
								$(window).on('popstate', function () {
									stripe.close();
								});
						}
					}
				} else {
					oemDisplayFormErrors(response, paymentFormId);
				}
			},
			error: function(response) {
				oemDisplayFormError(response, paymentFormId, paymentBtn);
			},
			complete: function(event, xhr, settings) {
				oemComplete(paymentBtn);
			}
		});

		// On selecting free exams.
		$(document).on('change', '.oem_select_exams', function(e) {
			var selected = $(this).find('option:selected', this);
			var paidExams = [];

			selected.each(function() {
				if(0 === $(this).data('free-exam')) {
					paidExams.push($(this).data('free-exam'));
				}
			});

			paymentBtn.show();
			$('.oem-payment-actions').show();

			if(paidExams.length > 0) {
				var paymentMethodAvailable = paymentBtn.data('payment-methods-available');

				paymentMethods.fadeIn();

				if(paymentMethodAvailable) {
					paymentBtn.fadeIn();
					paymentBtn.text(paymentBtn.data('proceed-to-pay'));
				} else {
					paymentBtn.hide();
				}
			} else {
				paymentMethods.hide();
				paymentBtn.text(paymentBtn.data('register'));
			}
		});
	});
})(jQuery);
