(function($) {
	'use strict';
	$(document).ready(function() {
    // Loading icon variables.
    var loaderContainer = $("<span/>", {
      class: "oem-loader ml-2",
    });
    var loader = $("<img/>", {
      src: oemadminurl + "images/spinner.gif",
      class: "oem-loader-image mb-1",
    });

    // Function: Before submit.
    function oemBeforeSubmit(button) {
      $("div.text-danger").remove();
      $(".is-invalid").removeClass("is-invalid");
      $(".oem .alert-dismissible").remove();
      button.prop("disabled", true);
      loaderContainer.insertAfter(button);
      loader.appendTo(loaderContainer);
      return true;
    }

    // Function: Display form erros.
    function oemDisplayFormErrors(response, formId) {
      if (response.data && $.isPlainObject(response.data)) {
        $(formId + " :input").each(function () {
          var input = this;
          $(input).removeClass("is-invalid");
          if (response.data[input.name]) {
            var errorSpan =
              '<div class="text-danger mt-1">' +
              response.data[input.name] +
              "</div>";
            $(input).addClass("is-invalid");
            $(errorSpan).insertAfter(input);
          }
        });
      } else {
        var errorSpan =
          '<div class="text-danger mt-3">' + response.data + "<hr></div>";
        $(errorSpan).insertBefore(formId);
        toastr.error(response.data);
      }
    }

    // Function: Show success alert.
    function oemShowSuccessAlert(message, formId) {
      var alertBox =
        '<div class="mt-2 alert alert-success alert-dismissible" exam="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><span class="oem-font-bold"><i class="fa fa-check"></i> &nbsp;' +
        message +
        "</span></div>";
      $(alertBox).insertBefore(formId);
    }

    // Function: Display form error.
    function oemDisplayFormError(response, formId, button) {
      button.prop("disabled", false);
      var errorSpan =
        '<div class="text-danger mt-2"><span class="oem-font-bold">' +
        response.status +
        "</span>: " +
        response.statusText +
        "<hr></div>";
      $(errorSpan).insertBefore(formId);
      toastr.error(response.data);
    }

    // Function: Complete.
    function oemComplete(button) {
      button.prop("disabled", false);
      loaderContainer.remove();
    }

    var subHeader = ".oem-sub-header-left";

    // Function: Action.
    function oemAction(event, element, data, performActions, color = "red") {
      event.preventDefault();
      $(".oem .alert-dismissible").remove();
      var title = $(element).data("message-title");
      var content = $(element).data("message-content");
      var cancel = $(element).data("cancel");
      var submit = $(element).data("submit");
      $.confirm({
        title: title,
        content: content,
        type: color,
        useBootstrap: false,
        buttons: {
          formSubmit: {
            text: submit,
            btnClass: "btn-" + color,
            action: function () {
              $.ajax({
                data: data,
                url: ajaxurl,
                type: "POST",
                beforeSend: function (xhr) {
                  $(".oem .alert-dismissible").remove();
                },
                success: function (response) {
                  if (response.success) {
                    var alertBox =
                      '<div class="alert alert-success alert-dismissible clearfix" exam="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><strong><i class="fa fa-check"></i> &nbsp;' +
                      response.data.message +
                      "</strong></div>";
                    $(alertBox).insertBefore(subHeader);
                    toastr.success(response.data.message, "", {
                      timeOut: 600,
                      fadeOut: 600,
                      closeButton: true,
                      progressBar: true,
                      onHidden: function () {
                        performActions(response);
                      },
                    });
                  } else {
                    toastr.error(response.data);
                    var errorSpan =
                      '<div class="alert alert-danger alert-dismissible clearfix" exam="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><strong>' +
                      response.data +
                      "</strong></div>";
                    $(errorSpan).insertBefore(subHeader);
                  }
                },
                error: function (response) {
                  toastr.error(response.status + ": " + response.statusText);
                  var errorSpan =
                    '<div class="alert alert-danger alert-dismissible clearfix" exam="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><strong>' +
                    response.status +
                    "</strong>: " +
                    response.statusText +
                    "</div>";
                  $(errorSpan).insertBefore(subHeader);
                },
              });
            },
          },
          cancel: {
            text: cancel,
            action: function () {
              $(".oem .alert-dismissible").remove();
            },
          },
        },
      });
    }

    // Function: Initialize Datatable.
    function oemInitializeTable(
      table,
      data,
      disableOrdering = [],
      lengthMenu = [25, 50, 100, 200],
      dataExport = false
    ) {
      table.DataTable({
        processing: true,
        serverSide: true,
		responsive: true,
	
        dom: 'Blfrtip',
        buttons: [
		
            {
                extend: 'print',
                exportOptions: {
                    columns: [ 0, 1, 2, 3,4,5,6,7 ]
                }
            },
			
        ],
        order: [],
        ajax: {
          url: ajaxurl,
          type: "POST",
          data: data,
          complete: function (event, xhr, settings) {
            var oemExportBtn = $("#oem-export-table-btn");
            oemExportBtn.hide();
            if (dataExport) {
              var json = event.responseJSON;
              if (
                json &&
                json.hasOwnProperty("recordsTotal") &&
                json.recordsTotal > 0 &&
                json.hasOwnProperty("export")
              ) {
                var exportFields = json.export;
                $("#oem-export-nonce").val(exportFields["nonce"]);
                $("#oem-export-action").val(exportFields["action"]);
                $("#oem-export-filter").val(exportFields["filter"]);
                oemExportBtn.show();
              }
            }
          },
        },
        deferRender: true,
        language: {
          processing: oemloadingtext,
        },
        lengthMenu: lengthMenu,
        columnDefs: [
          {
            targets: disableOrdering,
            orderable: false,
          },
        ],
      });
    }

    $(document).on("change", "#oem-select-all", function () {
      if ($(this).is(":checked")) {
        $(".oem-select-single").prop("checked", true);
      } else {
        $(".oem-select-single").prop("checked", false);
      }
    });

    // Function: Copy target content to clipboard on click.
    function oemCopyToClipboard(selector, target) {
      $(document).on("click", selector, function () {
        var value = $(target).text();
        var temp = $("<input>");
        $("body").append(temp);
        temp.val(value).select();
        document.execCommand("copy");
        temp.remove();
        toastr.success();
      });
    }

    // Print.
    function oemPrint(targetId, title, styleSheets, css = "") {
      var target = $(targetId).html();

      var frame = $("<iframe />");
      frame[0].name = "frame";
      frame.css({ position: "absolute", top: "-1000000px" });

      var that = frame.appendTo("body");
      var frameDoc = frame[0].contentWindow
        ? frame[0].contentWindow
        : frame[0].contentDocument.document
        ? frame[0].contentDocument.document
        : frame[0].contentDocument;
      frameDoc.document.open();

      // Create a new HTML document.
      frameDoc.document.write("<html><head>" + title);
      frameDoc.document.write("</head><body>");

      // Append the external CSS file.
      styleSheets.forEach(function (styleSheet, index) {
        $(that)
          .contents()
          .find("head")
          .append(
            '<link href="' +
              styleSheet +
              '" rel="stylesheet" type="text/css" referrerpolicy="origin" />'
          );
      });

      if (css) {
        frameDoc.document.write("<style>" + css + "</style>");
      }

      // Append the target.
      frameDoc.document.write(target);
      frameDoc.document.write("</body></html>");
      frameDoc.document.close();

      setTimeout(function () {
        window.frames["frame"].focus();
        window.frames["frame"].print();
        frame.remove();
      }, 1000);
    }

    // Custom file input.
    $(document).on("change", ".custom-file-input", function () {
      var fileName = $(this).val().split("\\").pop();
      $(this)
        .siblings(".custom-file-label")
        .addClass("selected")
        .html(fileName);
    });

    // Remove parent on click.
    $(document).on("click", ".oem-remove-item", function () {
      $(this).parent().remove();
    });

    // Function: Date picker.
    function oemDatePicker(selector) {
      $(selector).Zebra_DatePicker({
        format: oemdateformat,
        default_position: "below",
        readonly_element: false,
        show_clear_date: true,
        disable_time_picker: true,
      });
    }

    // Function: Time picker.
    function oemTimePicker(selector) {
      $(selector).Zebra_DatePicker({
        format: oemtimeformat,
        default_position: "below",
        readonly_element: false,
        show_clear_date: true,
        disable_time_picker: false,
        view: "time",
      });
    }

    // Function: Date and time picker.
    function oemAtPicker(selector) {
      $(selector).Zebra_DatePicker({
        format: oematformat,
        default_position: "below",
        readonly_element: false,
        show_clear_date: true,
        disable_time_picker: false,
      });
    }

    oemDatePicker(".oem_date");

    oemTimePicker(".oem_time");

    oemAtPicker(".oem_at");

    // Function: Trigger TinyMCE on submit.
    function oemTriggerTinyMCE(submitButton) {
      $(submitButton).mousedown(function () {
        tinyMCE.triggerSave();
      });
    }

    oemTriggerTinyMCE(".oem-trigger-tinymce");

    // Copy shortcodes.
    oemCopyToClipboard(
      "#oem_copy_online_exam_shortcode",
      "#oem_online_exam_shortcode"
    );
    oemCopyToClipboard(
      "#oem_copy_exam_results_shortcode",
      "#oem_exam_results_shortcode"
    );
    oemCopyToClipboard(
      "#oem_copy_exam_results_all_shortcode",
      "#oem_exam_results_all_shortcode"
    );
    oemCopyToClipboard(
      "#oem_copy_exam_registration_shortcode",
      "#oem_exam_registration_shortcode"
    );

    // Exams table.
    var examsTable = $("#oem-exams-table");
    oemInitializeTable(examsTable, { action: "oem-fetch-exams" }, [6, 7, 8, 9]);

    // Save exam.
    var saveExamFormId = "#oem-save-exam-form";
    var saveExamForm = $(saveExamFormId);
    var saveExamBtn = $("#oem-save-exam-btn");
    saveExamForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveExamBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(response.data.message, saveExamFormId);
          toastr.success(response.data.message);
          if (response.data.hasOwnProperty("url") && response.data.url) {
            window.location.href = response.data.url;
          } else {
            window.location.reload();
          }
        } else {
          oemDisplayFormErrors(response, saveExamFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(response, saveExamFormId, saveExamBtn);
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveExamBtn);
      },
    });

    // Setup and activate exam.
    $(document).on("click", ".oem-setup-activate-exam", function (event) {
      var examId = $(this).data("exam");
      var nonce = $(this).data("nonce");
      var data =
        "exam_id=" +
        examId +
        "&setup-activate-exam-" +
        examId +
        "=" +
        nonce +
        "&action=oem-setup-activate-exam";
      var performActions = function () {
        window.location.reload();
      };
      oemAction(event, this, data, performActions);
    });

    // Delete exam.
    $(document).on("click", ".oem-delete-exam", function (event) {
      var examId = $(this).data("exam");
      var nonce = $(this).data("nonce");
      var data =
        "exam_id=" +
        examId +
        "&delete-exam-" +
        examId +
        "=" +
        nonce +
        "&action=oem-delete-exam";
      var performActions = function () {
        examsTable.DataTable().ajax.reload(null, false);
      };
      oemAction(event, this, data, performActions);
    });

    // Questions table.
    var questionsTable = $("#oem-questions-table");
    oemInitializeTable(
      questionsTable,
      { action: "oem-fetch-questions", exam_id: questionsTable.data("exam") },
      [6]
    );

    // Rich text editor for options.
    var optionIdEditor = $("#oem_option_id_wpeditor");
    $(document).on("click", ".oem-option-editor-btn", function () {
      var optionId = $(this).data("id");
      var optionValue = $(".oem_option_" + optionId).val();
      tinyMCE.get("oem_option_wpeditor").setContent(optionValue);
      optionIdEditor.val(optionId);
    });

    $(document).on("click", ".oem-option-editor-continue-btn", function () {
      var optionId = optionIdEditor.val();
      var optionValue = tinyMCE.get("oem_option_wpeditor").getContent();
      $(".oem_option_" + optionId).val(optionValue);
    });

    // Save question.
    var saveQuestionFormId = "#oem-save-question-form";
    var saveQuestionForm = $(saveQuestionFormId);
    var saveQuestionBtn = $("#oem-save-question-btn");
    saveQuestionForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveQuestionBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(response.data.message, saveQuestionFormId);
          toastr.success(response.data.message);
          if (response.data.hasOwnProperty("reset") && response.data.reset) {
            saveQuestionForm.find("textarea").val("");
            questionsTable.DataTable().ajax.reload(null, false);
          } else {
            window.location.reload();
          }
        } else {
          oemDisplayFormErrors(response, saveQuestionFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(response, saveQuestionFormId, saveQuestionBtn);
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveQuestionBtn);
      },
    });

    // Delete question.
    $(document).on("click", ".oem-delete-question", function (event) {
      var questionId = $(this).data("question");
      var examId = $(this).data("exam");
      var nonce = $(this).data("nonce");
      var data =
        "question_id=" +
        questionId +
        "&exam_id=" +
        examId +
        "&delete-question-" +
        questionId +
        "=" +
        nonce +
        "&action=oem-delete-question";
      var performActions = function () {
        questionsTable.DataTable().ajax.reload(null, false);
      };
      oemAction(event, this, data, performActions);
    });

    // Set question options.
    $(document).on("click", "#oem_set_question_options", function () {
      var button = $(this);
      var questionOptionsCount = $("#oem_number_of_options").val();
      var questionType = $("#oem_question_type").val();
      var optionsContainer = $(".oem-section-options .oem-section-body");

      $.ajax({
        data: {
          action: "oem-set-question-options",
          security: button.data("security"),
          question_type: questionType,
          number_of_options: questionOptionsCount,
        },
        url: ajaxurl,
        type: "POST",
        beforeSend: function () {
          return oemBeforeSubmit(button);
        },
        success: function (response) {
          if (response.success) {
            optionsContainer.html(response.data.html);
          }
        },
        error: function (response) {
          if (response.data) {
            toastr.error(response.data);
          }
        },
        complete: function (event, xhr, settings) {
          oemComplete(button);
        },
      });
    });

    // Subjects table.
    var subjectsTable = $("#oem-subjects-table");
    oemInitializeTable(
      subjectsTable,
      { action: "oem-fetch-subjects", exam_id: subjectsTable.data("exam") },
      [4]
    );

    // Save subject.
    var saveSubjectFormId = "#oem-save-subject-form";
    var saveSubjectForm = $(saveSubjectFormId);
    var saveSubjectBtn = $("#oem-save-subject-btn");
    saveSubjectForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveSubjectBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(response.data.message, saveSubjectFormId);
          toastr.success(response.data.message);
          if (response.data.hasOwnProperty("reset") && response.data.reset) {
            saveSubjectForm[0].reset();
            subjectsTable.DataTable().ajax.reload(null, false);
          }
        } else {
          oemDisplayFormErrors(response, saveSubjectFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(response, saveSubjectFormId, saveSubjectBtn);
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveSubjectBtn);
      },
    });

    // Delete subject.
    $(document).on("click", ".oem-delete-subject", function (event) {
      var subjectId = $(this).data("subject");
      var examId = $(this).data("exam");
      var nonce = $(this).data("nonce");
      var data =
        "subject_id=" +
        subjectId +
        "&exam_id=" +
        examId +
        "&delete-subject-" +
        subjectId +
        "=" +
        nonce +
        "&action=oem-delete-subject";
      var performActions = function () {
        subjectsTable.DataTable().ajax.reload(null, false);
      };
      oemAction(event, this, data, performActions);
    });

    // Exams students table.
    var examsStudentsTable = $("#oem-exams-students-table");
    oemInitializeTable(
      examsStudentsTable,
      { action: "oem-fetch-exams-students" },
      [5]
    );

    // Students table.
    var studentsTable = $("#oem-students-table");
    oemInitializeTable(
      studentsTable,
      { action: "oem-fetch-students", exam_id: studentsTable.data("exam") },
      [0, 9]
    );

    // Function: Action.
    function oemAction(
      event,
      element,
      data,
      performActions,
      color = "red",
      showLoadingIcon = false
    ) {
      event.preventDefault();
      $(".oem .alert-dismissible").remove();
      var button = $(element);
      var title = button.data("message-title");
      var content = button.data("message-content");
      var cancel = button.data("cancel");
      var submit = button.data("submit");
      $.confirm({
        title: title,
        content: content,
        type: color,
        useBootstrap: false,
        buttons: {
          formSubmit: {
            text: submit,
            btnClass: "btn-" + color,
            action: function () {
              $.ajax({
                data: data,
                url: ajaxurl,
                type: "POST",
                beforeSend: function (xhr) {
                  $(".oem .alert-dismissible").remove();
                  if (showLoadingIcon) {
                    return oemBeforeSubmit(button);
                  }
                },
                success: function (response) {
                  if (response.success) {
                    var alertBox =
                      '<div class="alert alert-success alert-dismissible clearfix" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><strong><i class="fa fa-check"></i> &nbsp;' +
                      response.data.message +
                      "</strong></div>";
                    $(alertBox).insertBefore(subHeader);
                    toastr.success(response.data.message, "", {
                      timeOut: 600,
                      fadeOut: 600,
                      closeButton: true,
                      progressBar: true,
                      onHidden: function () {
                        performActions(response);
                      },
                    });
                  } else {
                    toastr.error(response.data);
                    var errorSpan =
                      '<div class="alert alert-danger alert-dismissible clearfix" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><strong>' +
                      response.data +
                      "</strong></div>";
                    $(errorSpan).insertBefore(subHeader);
                  }
                },
                error: function (response) {
                  toastr.error(response.status + ": " + response.statusText);
                  var errorSpan =
                    '<div class="alert alert-danger alert-dismissible clearfix" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><strong>' +
                    response.status +
                    "</strong>: " +
                    response.statusText +
                    "</div>";
                  $(errorSpan).insertBefore(subHeader);
                },
                complete: function (event, xhr, settings) {
                  if (showLoadingIcon) {
                    oemComplete(button);
                  }
                },
              });
            },
          },
          cancel: {
            text: cancel,
            action: function () {
              $(".oem .alert-dismissible").remove();
            },
          },
        },
      });
    }
    // Bulk Action.
    $(document).on("click", ".bulk-action-btn", function (event) {
      var button = $(this);
      var nonce = button.data("nonce");
      var tableId = "#" + button.parent().parent().parent().attr("id");
      var bulkActionSelect = $(".bulk-action-select");
      var bulkAction = bulkActionSelect.val();

      var entity = bulkActionSelect.data("entity");

      var bulkValues = $("input[name='bulk_data[]']:checked")
        .map(function () {
          return $(this).val();
        })
        .get();

      var data = {
        bulk_action: bulkAction,
        bulk_values: bulkValues,
        action: "oem-bulk-action",
        entity: entity,
        nonce: nonce,
      };

      var performActions = function () {
        location.reload();
      };

      oemAction(event, this, data, performActions, "red", true);
    });

    // Custom file input.
    $(document).on("change", ".custom-file-input", function () {
      var fileName = $(this).val().split("\\").pop();
      $(this)
        .siblings(".custom-file-label")
        .addClass("selected")
        .html(fileName);
    });

    // Add new or existing student user.
    var studentNewUser = $(".oem-student-new-user");
    var studentExistingUser = $(".oem-student-existing-user");

    var studentUser = $('input[name="student_new_or_existing"]:checked').val();
    if ("new_user" === studentUser) {
      studentExistingUser.fadeIn();
      studentNewUser.fadeIn();
    } else if ("existing_user" === studentUser) {
      studentExistingUser.fadeIn();
      studentNewUser.hide();
    } else {
      studentExistingUser.hide();
      studentNewUser.hide();
    }

    $(document).on(
      "change",
      'input[name="student_new_or_existing"]',
      function (event) {
        var studentUser = this.value;

        if ("new_user" === studentUser) {
          studentExistingUser.hide();
          studentNewUser.fadeIn();
        } else if ("existing_user" === studentUser) {
          studentNewUser.hide();
          studentExistingUser.fadeIn();
        } else {
          studentExistingUser.hide();
          studentNewUser.hide();
        }
      }
    );

    // Save student.
    var saveStudentFormId = "#oem-save-student-form";
    var saveStudentForm = $(saveStudentFormId);
    var saveStudentBtn = $("#oem-save-student-btn");
    saveStudentForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveStudentBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(response.data.message, saveStudentFormId);
          toastr.success(response.data.message);
          if (response.data.hasOwnProperty("reset") && response.data.reset) {
            saveStudentForm[0].reset();
            $(".oem-photo-box").load(
              location.href + " " + ".oem-photo-section",
              function () {}
            );
          } else {
            window.location.reload();
          }
        } else {
          oemDisplayFormErrors(response, saveStudentFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(response, saveStudentFormId, saveStudentBtn);
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveStudentBtn);
      },
    });

    // Delete student.
    $(document).on("click", ".oem-delete-student", function (event) {
      var studentId = $(this).data("student");
      var examId = $(this).data("exam");
      var nonce = $(this).data("nonce");
      var data =
        "student_id=" +
        studentId +
        "&exam_id=" +
        examId +
        "&delete-student-" +
        studentId +
        "=" +
        nonce +
        "&action=oem-delete-student";
      var performActions = function () {
        studentsTable.DataTable().ajax.reload(null, false);
      };
      oemAction(event, this, data, performActions);
    });

    // Select bulk import students from.
    var importFromExam = $(".oem-import-from-exam");
    var importFromCSV = $(".oem-import-from-csv");

    $(document).on("change", 'input[name="import_from"]', function (event) {
      var importFrom = this.value;
      if ("csv" === importFrom) {
        importFromExam.hide();
        importFromCSV.fadeIn();
      } else {
        importFromCSV.hide();
        importFromExam.fadeIn();
      }
    });

    // Autocomplete exam selection for bulk import students.
    var examSearch = $("#oem_exam_search");
    examSearch.autocomplete({
      minLength: 1,
      source: function (request, response) {
        $("div.text-danger").remove();
        $(".is-invalid").removeClass("is-invalid");
        $(".oem .alert-dismissible").remove();

        var data = {
          action: "oem-get-keyword-exams",
          keyword: request.term,
          exam: examSearch.data("exam"),
          oem_nonce: oemnonce,
        };

        $.ajax({
          data: data,
          url: ajaxurl,
          type: "POST",
          success: function (res) {
            if (res.success) {
              response(res.data);
            } else {
              response([]);
            }
          },
        });
      },
      select: function (event, ui) {
        examSearch.val("");
        var id = ui.item.ID;
        var label = ui.item.label;
        var exam = $(".oem_exam");
        if (exam) {
          var examToAdd = exam
            .map(function () {
              return $(this).val();
            })
            .get();
          if (-1 !== $.inArray(id, examToAdd)) {
            return false;
          }
        }
        if (id) {
          $(".oem_exam_input").html(
            "" +
              '<div class="oem-exam-item mb-1 mt-2">' +
              '<input class="oem_exam" type="hidden" name="exam" value="' +
              id +
              '">' +
              '<span class="oem-text-primary oem-font-bold">' +
              label +
              "</span>" +
              '&nbsp;<i class="fa fa-times bg-danger text-white oem-remove-item"></i>' +
              "</div>" +
              ""
          );
          return false;
        }
        return false;
      },
    });

    // Students CSV export.
    $(document).on("click", ".oem-students-csv-export-btn", function () {
      var formId = "oem-students-csv-export-form";
      var examId = $(this).data("exam");
      var form =
        "" +
        '<form action="' +
        ajaxurl +
        '" method="post" id="' +
        formId +
        '">' +
        '<input type="hidden" name="oem_nonce" value="' +
        oemnonce +
        '">' +
        '<input type="hidden" name="action" value="oem-students-csv-export">' +
        '<input type="hidden" name="exam" value="' +
        examId +
        '">' +
        "</form>" +
        "";

      $("#" + formId).remove();
      $(document.body).append(form);
      $("#" + formId).submit();
    });

    // Students sample CSV export.
    $(document).on(
      "click",
      "#oem-students-sample-csv-export-btn",
      function (e) {
        var formId = "oem-students-sample-csv-export-form";
        var examId = $('input[name="exam_id"]').val();
        var form =
          "" +
          '<form action="' +
          ajaxurl +
          '" method="post" id="' +
          formId +
          '">' +
          '<input type="hidden" name="oem_nonce" value="' +
          oemnonce +
          '">' +
          '<input type="hidden" name="action" value="oem-students-sample-csv-export">' +
          '<input type="hidden" name="exam" value="' +
          examId +
          '">' +
          "</form>" +
          "";

        $("#" + formId).remove();
        $(document.body).append(form);
        $("#" + formId).submit();
      }
    );

    // Bulk import students.
    var bulkImportStudentsFormId = "#oem-bulk-import-students-form";
    var bulkImportStudentsForm = $(bulkImportStudentsFormId);
    $(document).on("click", "#oem-bulk-import-students-btn", function (event) {
      event.preventDefault();
      var bulkImportStudentsBtn = $(this);

      var importFrom = $('input[name="import_from"]:checked').val();
      var confirmMessage = "";
      if ("exam" === importFrom) {
        confirmMessage = bulkImportStudentsBtn.data("message-exam");
      } else if ("csv" === importFrom) {
        confirmMessage = bulkImportStudentsBtn.data("message-csv");
      }

      if ("" === confirmMessage) {
        return;
      }

      if (confirm(confirmMessage)) {
        bulkImportStudentsForm.ajaxSubmit({
          beforeSubmit: function (arr, $form, options) {
            return oemBeforeSubmit(bulkImportStudentsBtn);
          },
          success: function (response) {
            if (response.success) {
              oemShowSuccessAlert(
                response.data.message,
                bulkImportStudentsFormId
              );
              toastr.success(response.data.message);
              bulkImportStudentsForm[0].reset();
              $(".oem_exam_input").html("");
            } else {
              oemDisplayFormErrors(response, bulkImportStudentsFormId);
            }
          },
          error: function (response) {
            oemDisplayFormError(
              response,
              bulkImportStudentsFormId,
              bulkImportStudentsBtn
            );
          },
          complete: function (event, xhr, settings) {
            oemComplete(bulkImportStudentsBtn);
          },
        });
      }
    });

    // Save record.
    var saveRecordFormId = "#oem-save-record-form";
    var saveRecordForm = $(saveRecordFormId);
    var saveRecordBtn = $("#oem-save-record-btn");
    saveRecordForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveRecordBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(response.data.message, saveRecordFormId);
          toastr.success(response.data.message);
          window.location.reload();
        } else {
          oemDisplayFormErrors(response, saveRecordFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(response, saveRecordFormId, saveRecordBtn);
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveRecordBtn);
      },
    });

    // Delete record.
    $(document).on("click", ".oem-delete-record", function (event) {
      var recordId = $(this).data("record");
      var nonce = $(this).data("nonce");
      var data =
        "record_id=" +
        recordId +
        "&delete-record-" +
        recordId +
        "=" +
        nonce +
        "&action=oem-delete-record";
      var performActions = function () {
        window.location.reload();
      };
      oemAction(event, this, data, performActions);
    });

    // Payments table.
    var paymentsTable = $("#oem-payments-table");
    oemInitializeTable(paymentsTable, { action: "oem-fetch-payments" }, [5, 6]);

    // Delete payment.
    $(document).on("click", ".oem-delete-payment", function (event) {
      var paymentId = $(this).data("payment");
      var nonce = $(this).data("nonce");
      var data =
        "payment_id=" +
        paymentId +
        "&delete-payment-" +
        paymentId +
        "=" +
        nonce +
        "&action=oem-delete-payment";
      var performActions = function () {
        paymentsTable.DataTable().ajax.reload(null, false);
      };
      oemAction(event, this, data, performActions);
    });

    // Exams results table.
    var examsResultsTable = $("#oem-exams-results-table");
    oemInitializeTable(
      examsResultsTable,
      { action: "oem-fetch-exams-results" },
      [6]
    );

    // Students results table.
    var studentsResultsTable = $("#oem-students-results-table");
    oemInitializeTable(
	  studentsResultsTable,
      {
        action: "oem-fetch-students-results",
		exam_id: studentsResultsTable.data("exam"),
		
      },
      [5, 6, 7],
      [50, 100, 200]
    );

    // Edit subjective obtained marks.
    var editSubjectiveObtainedMarksFormId =
      "#oem-edit-subjective-obtained-marks-form";
    var editSubjectiveObtainedMarksForm = $(editSubjectiveObtainedMarksFormId);
    var editSubjectiveObtainedMarksBtn = $(
      "#oem-edit-subjective-obtained-marks-btn"
    );
    editSubjectiveObtainedMarksForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(editSubjectiveObtainedMarksBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(
            response.data.message,
            editSubjectiveObtainedMarksFormId
          );
          toastr.success(response.data.message);
          window.location.reload();
        } else {
          oemDisplayFormErrors(response, editSubjectiveObtainedMarksFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(
          response,
          editSubjectiveObtainedMarksFormId,
          editSubjectiveObtainedMarksBtn
        );
      },
      complete: function (event, xhr, settings) {
        oemComplete(editSubjectiveObtainedMarksBtn);
      },
    });

    // Save general settings.
    var saveGeneralSettingsFormId = "#oem-save-general-settings-form";
    var saveGeneralSettingsForm = $(saveGeneralSettingsFormId);
    var saveGeneralSettingsBtn = $("#oem-save-general-settings-btn");
    saveGeneralSettingsForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveGeneralSettingsBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(response.data.message, saveGeneralSettingsFormId);
          toastr.success(response.data.message);
        } else {
          oemDisplayFormErrors(response, saveGeneralSettingsFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(
          response,
          saveGeneralSettingsFormId,
          saveGeneralSettingsBtn
        );
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveGeneralSettingsBtn);
      },
    });

    // Save general settings.
    var saveEmailSettingsFormId = "#oem-save-email-settings-form";
    var saveEmailSettingsForm = $(saveEmailSettingsFormId);
    var saveEmailSettingsBtn = $("#oem-save-email-settings-btn");
    saveEmailSettingsForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveEmailSettingsBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(response.data.message, saveEmailSettingsFormId);
          toastr.success(response.data.message);
        } else {
          oemDisplayFormErrors(response, saveEmailSettingsFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(
          response,
          saveEmailSettingsFormId,
          saveEmailSettingsBtn
        );
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveEmailSettingsBtn);
      },
    });

    // Save Email Templates settings.
    var saveEmailTemplatesFormId = "#oem-save-email-template-form";
    var saveEmailTemplatesForm = $(saveEmailTemplatesFormId);
    var saveEmailTemplatesBtn = $("#oem-save-email-template-btn");
    saveEmailTemplatesForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveEmailTemplatesBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(response.data.message, saveEmailTemplatesFormId);
          toastr.success(response.data.message);
        } else {
          oemDisplayFormErrors(response, saveEmailTemplatesFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(
          response,
          saveEmailTemplatesFormId,
          saveEmailTemplatesBtn
        );
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveEmailTemplatesBtn);
      },
    });

    // Send test email
    $(document).on('click', '.oem-send-test-email', function() {
      var button = $(this);
      var nonce = button.data('nonce');
      var template = button.data('template');
      var to = button.parent().find('.oem-send-test-email-to').val();
      var data = {
          'to': to,
          'template': template,
          'send-test-email': nonce,
          'action': 'oem-send-test-email'
      };
      $.ajax({
          data: data,
          url: ajaxurl,
          type: 'POST',
          beforeSend: function(xhr) {
              $('.oem .alert-dismissible').remove();
              return oemBeforeSubmit(button);
          },
          success: function(response) {
              if(response.success) {
                  toastr.success(response.data.message);
              } else {
                  if ( response.data ) {
                      toastr.error(response.data);
                  }
              }
          },
          error: function(response) {
              if ( response.data ) {
                  toastr.error(response.data);
              }
          },
          complete: function(xhr) {
              oemComplete(button);
          }
      });
  });

    // Save registration settings.
    var saveRegistrationSettingsFormId = "#oem-save-registration-settings-form";
    var saveRegistrationSettingsForm = $(saveRegistrationSettingsFormId);
    var saveRegistrationSettingsBtn = $("#oem-save-registration-settings-btn");
    saveRegistrationSettingsForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveRegistrationSettingsBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(
            response.data.message,
            saveRegistrationSettingsFormId
          );
          toastr.success(response.data.message);
        } else {
          oemDisplayFormErrors(response, saveRegistrationSettingsFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(
          response,
          saveRegistrationSettingsFormId,
          saveRegistrationSettingsBtn
        );
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveRegistrationSettingsBtn);
      },
    });

    // Save datetime settings.
    var saveDatetimeSettingsFormId = "#oem-save-datetime-settings-form";
    var saveDatetimeSettingsForm = $(saveDatetimeSettingsFormId);
    var saveDatetimeSettingsBtn = $("#oem-save-datetime-settings-btn");
    saveDatetimeSettingsForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(saveDatetimeSettingsBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(
            response.data.message,
            saveDatetimeSettingsFormId
          );
          toastr.success(response.data.message);
        } else {
          oemDisplayFormErrors(response, saveDatetimeSettingsFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(
          response,
          saveDatetimeSettingsFormId,
          saveDatetimeSettingsBtn
        );
      },
      complete: function (event, xhr, settings) {
        oemComplete(saveDatetimeSettingsBtn);
      },
    });

    // Save payment methods settings.
    var savePaymentMethodsSettingsFormId =
      "#oem-save-payment-methods-settings-form";
    var savePaymentMethodsSettingsForm = $(savePaymentMethodsSettingsFormId);
    var savePaymentMethodsSettingsBtn = $(
      "#oem-save-payment-methods-settings-btn"
    );
    savePaymentMethodsSettingsForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(savePaymentMethodsSettingsBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(
            response.data.message,
            savePaymentMethodsSettingsFormId
          );
          toastr.success(response.data.message);
        } else {
          oemDisplayFormErrors(response, savePaymentMethodsSettingsFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(
          response,
          savePaymentMethodsSettingsFormId,
          savePaymentMethodsSettingsBtn
        );
      },
      complete: function (event, xhr, settings) {
        oemComplete(savePaymentMethodsSettingsBtn);
      },
    });

    // Manager: Reset plugin.
    var resetPluginFormId = "#oem-reset-plugin-form";
    var resetPluginForm = $(resetPluginFormId);
    var resetPluginBtn = $("#oem-reset-plugin-btn");

    $(document).on("click", "#oem-reset-plugin-btn", function (event) {
      $.confirm({
        title: resetPluginBtn.data("message-title"),
        content: resetPluginBtn.data("message-content"),
        type: "red",
        useBootstrap: false,
        buttons: {
          confirm: {
            text: resetPluginBtn.data("submit"),
            btnClass: "btn-red",
            action: function () {
              resetPluginForm.ajaxSubmit({
                beforeSubmit: function (arr, $form, options) {
                  return oemBeforeSubmit(resetPluginBtn);
                },
                success: function (response) {
                  if (response.success) {
                    oemShowSuccessAlert(
                      response.data.message,
                      resetPluginFormId
                    );
                    toastr.success(response.data.message);
                    if (
                      response.data.hasOwnProperty("reload") &&
                      response.data.reload
                    ) {
                      window.location.reload();
                    } else if (
                      response.data.hasOwnProperty("reset") &&
                      response.data.reset
                    ) {
                      resetPluginForm[0].reset();
                    }
                  } else {
                    oemDisplayFormErrors(response, resetPluginFormId);
                  }
                },
                error: function (response) {
                  oemDisplayFormError(
                    response,
                    resetPluginFormId,
                    resetPluginBtn
                  );
                },
                complete: function (event, xhr, settings) {
                  oemComplete(resetPluginBtn);
                },
              });
            },
          },
          cancel: {
            text: resetPluginBtn.data("cancel"),
            action: function () {
              return;
            },
          },
        },
      });
    });

    // Save payment receipt settings.
    var savePaymentReceiptSettingsFormId =
      "#oem-save-payment-receipt-settings-form";
    var savePaymentReceiptSettingsForm = $(savePaymentReceiptSettingsFormId);
    var savePaymentReceiptSettingsBtn = $(
      "#oem-save-payment-receipt-settings-btn"
    );
    savePaymentReceiptSettingsForm.ajaxForm({
      beforeSubmit: function (arr, $form, options) {
        return oemBeforeSubmit(savePaymentReceiptSettingsBtn);
      },
      success: function (response) {
        if (response.success) {
          oemShowSuccessAlert(
            response.data.message,
            savePaymentReceiptSettingsFormId
          );
          toastr.success(response.data.message);
        } else {
          oemDisplayFormErrors(response, savePaymentReceiptSettingsFormId);
        }
      },
      error: function (response) {
        oemDisplayFormError(
          response,
          savePaymentReceiptSettingsFormId,
          savePaymentReceiptSettingsBtn
        );
      },
      complete: function (event, xhr, settings) {
        oemComplete(savePaymentReceiptSettingsBtn);
      },
    });

    // Print answer sheet.
    $(document).on("click", "#oem-print-answer-sheet-btn", function () {
      var targetId = "#oem-print-answer-sheet";
      var title = $(this).data("title");
      if (title) {
        title = "<title>" + title + "</title>";
      }
      var styleSheets = $(this).data("styles");

      oemPrint(targetId, title, styleSheets);
    });

     // Print student .
     $(document).on("click", "#oem-print-student-profile-btn", function () {
      var targetId = "#oem-print-student-profile";
      var title = $(this).data("title");
      if (title) {
        title = "<title>" + title + "</title>";
      }
      var styleSheets = $(this).data("styles");

      oemPrint(targetId, title, styleSheets);
    });
  });


	$(document).ready(function() {
		var table = $('#example').DataTable({     
		   'columnDefs': [
			  {
				 'targets': 0,
				 'checkboxes': {
					'selectRow': true
				 }
			  }
		   ],
		   'select': {
			  'style': 'multi'
		   },
		   'order': [[1, 'asc']]
		});
		
		// Handle form submission event 
		$('#frm-example').on('submit', function(e){
		   var form = this;
		   
		   var rows_selected = table.column(0).checkboxes.selected();
	 
		   // Iterate over all selected checkboxes
		   $.each(rows_selected, function(index, rowId){
			  // Create a hidden element 
			  $(form).append(
				  $('<input>')
					 .attr('type', 'hidden')
					 .attr('name', 'id[]')
					 .val(rowId)
			  );
		   });
	 
		   // FOR DEMONSTRATION ONLY
		   // The code below is not needed in production
		   
		   // Output form data to a console     
		   $('#example-console-rows').text(rows_selected.join(","));
		   
		   // Output form data to a console     
		   $('#example-console-form').text($(form).serialize());
			
		   // Remove added elements
		   $('input[name="id\[\]"]', form).remove();
			
		   // Prevent actual form submission
		   e.preventDefault();
		});   
	 });
	 
})(jQuery);
