<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam.php';
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam_title.php'; ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-clock"></i>&nbsp;
					<?php echo esc_html( 'View Exams', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-users"></i>
							<?php esc_html_e( 'Students', 'online-exam-management' ); ?>
						</span>
						<span class="float-right">
							<a href="<?php echo esc_url( $page_url . '&action=bulk_import&exam_id=' . $exam_id ); ?>" class="btn btn-sm oem-btn-outline-primary">
								<i class="fas fa-file-import"></i>&nbsp;
								<?php echo esc_html( 'Bulk Import', 'online-exam-management' ); ?>
							</a>
							<a class="btn btn-sm oem-btn-outline-primary" href="<?php echo esc_url( $page_url . '&action=save&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-plus"></i>
								<?php esc_html_e( 'Add Student', 'online-exam-management' ); ?>
							</a>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block oem-table-block-small">
							<table class="table table-hover table-bordered" id="oem-students-table" data-exam="<?php echo esc_attr( $exam_id ); ?>">
							<?php
							$entity = 'students';
							require OEM_PLUGIN_DIR_PATH . 'includes/partials/bulk_action.php'; ?>
								<thead>
									<tr class="text-white oem-bg-primary">
									<th><input type="checkbox" name="select_all" id="oem-select-all" value="1"></th>
										<th scope="col"><?php esc_html_e( 'Name', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Roll Number', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Class', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Section', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Phone', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Login Email', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Username', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( "Father's Name", 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( "Exam Photo", 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Action', 'online-exam-management' ); ?></th>
									</tr>
								</thead>
							</table>
							
						</div>
					</div>
				</div>

			</div>
		</div>

	</div>
</div>
