<?php
defined( 'ABSPATH' ) || die();
?>
<div class="oem-section">
	<div class="oem-section-header">
		<span><?php esc_html_e( 'Login Detail', 'online-exam-management' ); ?></span>
	</div>

	<div class="oem-section-body">
		<div class="form-row">
			<div class="form-group col-md-12">
				<div class="form-check form-check-inline">
					<input <?php checked( false, (bool) $username, true ); ?> class="form-check-input" type="radio" name="student_new_or_existing" id="oem_student_disallow_login" value="">
					<label class="ml-1 form-check-label text-secondary font-weight-bold" for="oem_student_disallow_login">
						<?php esc_html_e( 'Disable Login?', 'online-exam-management' ); ?>
					</label>
				</div>
				<div class="form-check form-check-inline">
					<input <?php checked( true, (bool) $username, true ); ?> class="form-check-input" type="radio" name="student_new_or_existing" id="oem_student_existing_user" value="existing_user">
					<label class="ml-1 form-check-label oem-text-primary font-weight-bold" for="oem_student_existing_user">
						<?php esc_html_e( 'Existing User?', 'online-exam-management' ); ?>
					</label>
				</div>
				<?php if ( ! $record ) { ?>
				<div class="form-check form-check-inline">
					<input class="form-check-input" type="radio" name="student_new_or_existing" id="oem_student_new_user" value="new_user">
					<label class="ml-1 form-check-label oem-text-danger font-weight-bold" for="oem_student_new_user">
						<?php esc_html_e( 'New User?', 'online-exam-management' ); ?>
					</label>
				</div>
				<?php } ?>
			</div>
		</div>

		<div class="form-row oem-student-existing-user">
			<div class="form-group col-md-4">
				<label for="oem_existing_username" class="oem-font-bold">
					<span class="oem-important">*</span> <?php esc_html_e( 'Existing Username', 'online-exam-management' ); ?>:
					<?php if ( $username ) { ?>
						<small>
							<em class="text-secondary">
							<?php esc_html_e( 'Usernames cannot be changed.', 'online-exam-management' ); ?>
							</em>
						</small>
					<?php } ?>
				</label>
				<input type="text" name="existing_username" class="form-control" id="oem_existing_username" placeholder="<?php esc_attr_e( 'Enter existing username', 'online-exam-management' ); ?>" value="<?php
						if ( $record && ! $username ) {
							echo esc_attr( $record->user_login );
						} else {
							echo esc_attr( $username );
						}
					?>" <?php
					if ( ( $record && ! $username ) || $username ) {
						echo 'readonly';
					}
					?>>
				<?php if ( ! $username ) { ?>
				<div class="form-check form-check-inline mt-2">
					<input class="form-check-input" type="checkbox" name="disconnect_user" id="oem_disconnect_user" value="1">
					<label class="form-check-label oem-text-danger oem-font-bold oem-font-small" for="oem_disconnect_user">
						<?php esc_html_e( 'Force disconnect this user if exists in other exam?', 'online-exam-management' ); ?>
					</label>
				</div>
				<?php } ?>
			</div>

			<?php if ( $username ) { ?>
			<div class="form-group col-md-4">
				<label for="oem_new_login_email" class="oem-font-bold">
					<?php esc_html_e( 'Login Email', 'online-exam-management' ); ?>:
				</label>
				<input type="email" name="new_login_email" class="form-control" id="oem_new_login_email" placeholder="<?php esc_attr_e( 'Enter login email', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $login_email ); ?>">
			</div>

			<div class="form-group col-md-4">
				<label for="oem_new_login_password" class="oem-font-bold">
					<?php esc_html_e( 'Password', 'online-exam-management' ); ?>:
				</label>
				<input type="password" name="new_password" class="form-control" id="oem_new_login_password" placeholder="<?php esc_attr_e( 'Enter password', 'online-exam-management' ); ?>">
			</div>
			<?php } ?>
		</div>

		<div class="form-row oem-student-new-user">
			<div class="form-group col-md-4">
				<label for="oem_username" class="oem-font-bold">
					<span class="oem-important">*</span> <?php esc_html_e( 'Username', 'online-exam-management' ); ?>:
				</label>
				<input type="text" name="username" class="form-control" id="oem_username" placeholder="<?php esc_attr_e( 'Enter username', 'online-exam-management' ); ?>">
			</div>

			<div class="form-group col-md-4">
				<label for="oem_login_email" class="oem-font-bold">
					<span class="oem-important">*</span> <?php esc_html_e( 'Login Email', 'online-exam-management' ); ?>:
				</label>
				<input type="email" name="login_email" class="form-control" id="oem_login_email" placeholder="<?php esc_attr_e( 'Enter login email', 'online-exam-management' ); ?>">
			</div>

			<div class="form-group col-md-4">
				<label for="oem_login_password" class="oem-font-bold">
					<span class="oem-important">*</span> <?php esc_html_e( 'Password', 'online-exam-management' ); ?>:
				</label>
				<input type="password" name="password" class="form-control" id="oem_login_password" placeholder="<?php esc_attr_e( 'Enter password', 'online-exam-management' ); ?>">
			</div>
		</div>
	</div>
</div>
