<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam.php';

$nonce_action_bulk_import = 'bulk-import-students-' . $exam_id;
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-file-import"></i>
				<?php
				printf(
					wp_kses(
						/* translators: 1: exam title, 2: exam code, 3: date and time, 4: number of minutes */
						__( 'Bulk Import: <span class="oem-font-light">%1$s (%2$s) (%3$s - %4$s minutes)</span>', 'online-exam-management' ),
						array(
							'span' => array( 'class' => array() )
						)
					),
					esc_html( OEM_Helper::stripslashes( $exam_title ) ),
					esc_html( $exam_code ),
					esc_html( OEM_Helper::get_at_text( $exam_at ) ),
					esc_html( $duration )
				);
				?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-users"></i>&nbsp;
					<?php echo esc_html( 'View Exams', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row justify-content-md-center">
			<div class="col-12 col-md-7">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-file-import"></i>
							<?php esc_html_e( 'Bulk Import Students', 'online-exam-management' ); ?>
						</span>
						<span>
							<a class="btn btn-sm oem-btn-outline-primary float-right" href="<?php echo esc_url( $page_url . '&action=list&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-users"></i>
								<?php esc_html_e( 'View Students', 'online-exam-management' ); ?>
							</a>
						</span>
					</div>

					<div class="oem-section-body">
						<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-bulk-import-students-form">

							<?php $nonce_bulk_import = wp_create_nonce( $nonce_action_bulk_import ); ?>
							<input type="hidden" name="<?php echo esc_attr( $nonce_action_bulk_import ); ?>" value="<?php echo esc_attr( $nonce_bulk_import ); ?>">

							<input type="hidden" name="action" value="oem-bulk-import-students">

							<input type="hidden" name="exam_id" value="<?php echo esc_attr( $exam->ID ); ?>">

							<div class="form-row">
								<div class="col-12 col-md-12">
									<div class="form-group">
										<label class="oem-font-bold">
											<?php esc_html_e( 'Import From', 'online-exam-management' ); ?>:
										</label>
										<br>
										<div class="form-check form-check-inline">
											<input checked class="form-check-input" type="radio" name="import_from" id="oem_import_from_exam" value="exam">
											<label class="form-check-label oem-text-primary oem-font-bold ml-1" for="oem_import_from_exam">
												<?php esc_html_e( 'Import Students from Other Exam', 'online-exam-management' ); ?>
											</label>
										</div>
										<div class="form-check form-check-inline">
											<input class="form-check-input" type="radio" name="import_from" id="oem_import_from_csv" value="csv">
											<label class="form-check-label oem-text-danger oem-font-bold ml-1" for="oem_import_from_csv">
												<?php esc_html_e( 'Import Students from CSV file', 'online-exam-management' ); ?>
											</label>
										</div>
									</div>
								</div>
							</div>

							<div class="form-row oem-import-from-exam">
								<div class="col-12 col-md-8">
									<div class="form-group">
										<label for="oem_exam_search" class="oem-font-bold">
											<span class="oem-important">*</span> <?php esc_html_e( 'Select Exam', 'online-exam-management' ); ?>:
										</label>
										<input data-exam="<?php echo esc_attr( $exam->ID ); ?>" type="text" name="keyword" class="form-control" id="oem_exam_search" placeholder="<?php esc_attr_e( "Type exam code or exam title, then click to select.", 'online-exam-management' ); ?>" autocomplete="off">
										<div class="oem_exam_input"></div>
									</div>
									<div class="form-check form-check-inline mt-2">
										<input class="form-check-input" type="checkbox" name="disconnect_user_exam" id="oem_disconnect_user_exam" value="1">
										<label class="form-check-label oem-text-danger oem-font-bold oem-font-small" for="oem_disconnect_user_exam">
											<?php esc_html_e( 'Force disconnect this user if exists in other exam?', 'online-exam-management' ); ?>
										</label>
									</div>
								</div>
							</div>

							<div class="form-row oem-import-from-csv">
								<div class="col-12 col-md-8">
									<div class="form-group">
										<label for="oem_students_csv" class="oem-font-bold">
											<span class="oem-important">*</span> <?php esc_html_e( 'CSV File', 'online-exam-management' ); ?>:
										</label>
										<div class="custom-file">
											<input type="file" class="custom-file-input" id="oem_students_csv" name="csv">
											<label class="custom-file-label" for="oem_students_csv">
												<?php esc_html_e( 'Choose CSV File', 'online-exam-management' ); ?>
											</label>
										</div>
									</div>
									<div class="form-check form-check-inline mt-2">
										<input class="form-check-input" type="checkbox" name="disconnect_user_csv" id="oem_disconnect_user_csv" value="1">
										<label class="form-check-label oem-text-danger oem-font-bold oem-font-small" for="oem_disconnect_user_csv">
											<?php esc_html_e( 'Force disconnect this user if exists in other exam?', 'online-exam-management' ); ?>
										</label>
									</div>
								</div>

								<hr>

								<div class="col-12 col-md-8">
									<div class="form-group">
										<label for="oem_students_sameple_csv" class="oem-font-bold">
											<?php esc_html_e( 'Export Sample CSV File', 'online-exam-management' ); ?>:
										</label>
										<br>
										<button type="button" class="btn btn-sm oem-btn-outline-primary" id="oem-students-sample-csv-export-btn">
											<i class="fas fa-file-export"></i>
											<?php esc_html_e( 'Export Sample CSV', 'online-exam-management' ); ?>
										</button>
									</div>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12 text-right">
									<button data-message-exam="<?php esc_attr_e( 'Importing students from other exam will disconnect students login accounts from that exam and transferred them to the exam where you are importing the students.', 'online-exam-management' ); ?>" data-message-csv="<?php esc_attr_e( 'Importing students from CSV file will disconnect student login accounts from exams and transferred them to the exam where you are importing import the students.', 'online-exam-management' ); ?>" type="submit" class="btn btn-sm oem-btn-primary" id="oem-bulk-import-students-btn">
										<i class="fas fa-file-import"></i>&nbsp;
										<?php esc_html_e( 'Bulk Import', 'online-exam-management' ); ?>
									</button>
								</div>
							</div>
						</form>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
