<?php
defined('ABSPATH') || die();

$registration = OEM_Helper::registration_settings();

$nonce_action_registration_settings = 'save-registration-settings';
?>
<div class="row tab-pane fade" id="oem-registration" role="tabpanel" aria-labelledby="oem-registration-tab">
	<div class="col-12 col-md-12">

		<div class="oem-section">
			<div class="oem-section-header">
				<span>
					<i class="fas fa-users"></i>
					<?php esc_html_e('Registration Settings', 'online-exam-management'); ?>
				</span>
			</div>

			<div class="oem-section-body">
				<form action="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" method="post" id="oem-save-registration-settings-form">

					<?php $nonce_registration_settings = wp_create_nonce($nonce_action_registration_settings); ?>
					<input type="hidden" name="<?php echo esc_attr($nonce_action_registration_settings); ?>" value="<?php echo esc_attr($nonce_registration_settings); ?>">

					<input type="hidden" name="action" value="oem-save-registration-settings">

					<div class="form-row">
						<div class="col-12 col-md-4">
							<div class="form-group">
								<label for="oem_reg_no_prefix" class="oem-font-bold">
									<?php esc_html_e('Registration Number Prefix', 'online-exam-management'); ?>:
								</label>
								<input type="text" name="reg_no_prefix" class="form-control" id="oem_reg_no_prefix" placeholder="<?php esc_attr_e('Enter registration number prefix', 'online-exam-management'); ?>" value="<?php echo esc_attr($registration['reg_no_prefix']); ?>">
								<p class="description"><?php esc_html_e('Prefix to add on auto-generated, new registration numbers.', 'online-exam-management'); ?></p>
							</div>

							<div class="form-group">
								<label for="oem_reg_no_base" class="oem-font-bold">
									<?php esc_html_e('Registration Number Base', 'online-exam-management'); ?>:
								</label>
								<input type="number" step="1" min="0" name="reg_no_base" class="form-control" id="oem_reg_no_base" placeholder="<?php esc_attr_e('Enter registration number base', 'online-exam-management'); ?>" value="<?php echo esc_attr($registration['reg_no_base']); ?>">
								<p class="description"><?php esc_html_e('If base is 100 and prefix is R, then first auto-generated registration number will be R101.', 'online-exam-management'); ?></p>
							</div>
						</div>
					</div>

					<div class="form-row">
						<div class="col-12 col-md-12">
							<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-save-registration-settings-btn">
								<?php esc_html_e('Save Settings', 'online-exam-management'); ?>
							</button>
						</div>
					</div>

				</form>
			</div>
		</div>

	</div>
</div>