<?php
defined( 'ABSPATH' ) || die();

$payment_receipt = OEM_Helper::payment_receipt_settings();

$nonce_action_payment_receipt_settings = 'save-payment-receipt-settings';
?>
<div class="row tab-pane fade" id="oem-payment-receipt" role="tabpanel" aria-labelledby="oem-payment-receipt-tab">
	<div class="col-12 col-md-12">

		<div class="oem-section">
			<div class="oem-section-header">
				<span>
					<i class="fas fa-users"></i>
					<?php esc_html_e( 'Payment Receipt Settings', 'online-exam-management' ); ?>
				</span>
			</div>

			<div class="oem-section-body">
				<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-payment-receipt-settings-form">

					<?php $nonce_payment_receipt_settings = wp_create_nonce( $nonce_action_payment_receipt_settings ); ?>
					<input type="hidden" name="<?php echo esc_attr( $nonce_action_payment_receipt_settings ); ?>" value="<?php echo esc_attr( $nonce_payment_receipt_settings ); ?>">

					<input type="hidden" name="action" value="oem-save-payment-receipt-settings">

					<div class="form-row">
						<div class="col-12 col-md-4">
							<div class="form-group">
								<label for="oem_payment_receipt_no_prefix" class="oem-font-bold">
									<?php esc_html_e( 'Receipt Number Prefix', 'online-exam-management' ); ?>:
								</label>
								<input type="text" name="payment_receipt_no_prefix" class="form-control" id="oem_payment_receipt_no_prefix" placeholder="<?php esc_attr_e( 'Enter receipt number prefix', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $payment_receipt['receipt_no_prefix'] ); ?>">
								<p class="description"><?php esc_html_e( 'Prefix to add on auto-generated, new receipt numbers.', 'online-exam-management' ); ?></p>
							</div>

							<div class="form-group">
								<label for="oem_payment_receipt_no_base" class="oem-font-bold">
									<?php esc_html_e( 'Receipt Number Base', 'online-exam-management' ); ?>:
								</label>
								<input type="number" step="1" min="0" name="payment_receipt_no_base" class="form-control" id="oem_payment_receipt_no_base" placeholder="<?php esc_attr_e( 'Enter receipt number base', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $payment_receipt['receipt_no_base'] ); ?>">
								<p class="description"><?php esc_html_e( 'If base is 100 and prefix is R, then first auto-generated receipt number will be R101.', 'online-exam-management' ); ?></p>
							</div>
						</div>
					</div>

					<div class="form-row">
						<div class="col-12 col-md-12">
							<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-save-payment-receipt-settings-btn">
								<?php esc_html_e( 'Save Settings', 'online-exam-management' ); ?>
							</button>
						</div>
					</div>

				</form>
			</div>
		</div>

	</div>
</div>
