<?php
defined('ABSPATH') || die();

$exam_page_url = OEM_Helper::online_exam_page_url();

$registration_page_url = OEM_Helper::registration_page_url();

$template    = OEM_Helper::get_email_template();
$placeholder = OEM_Helper::email_placeholder();

$registration_template   = $template['registration_template'];
$registration_subject    = $template['registration_subject'];
$email_registration_body = $template['email_registration_body'];
$result_template         = $template['result_template'];
$result_subject          = $template['result_subject'];
$email_result_body       = $template['email_result_body'];


$nonce_action_email_settings = 'save-email-template';
?>
<div class="row tab-pane fade show" id="oem-email-template" role="tabpanel" aria-labelledby="oem-email-template-tab">
	<div class="col-12 col-md-12">

		<div class="oem-section">
			<div class="oem-section-header">
				<span>
					<i class="fas fa-cog"></i>
					<?php esc_html_e('Email Templates', 'online-exam-management'); ?>
				</span>
			</div>

			<div class="oem-section-body">
				<form action="<?php echo esc_url(admin_url('admin-ajax.php')); ?>" method="post" id="oem-save-email-template-form">

					<?php $nonce_email_settings = wp_create_nonce($nonce_action_email_settings); ?>
					<input type="hidden" name="<?php echo esc_attr($nonce_action_email_settings); ?>" value="<?php echo esc_attr($nonce_email_settings); ?>">

					<input type="hidden" name="action" value="oem-save-email-template">

					<div class="form-row">
						<div class="col-12 col-md-6">
							<button type="button" class="mt-2 btn oem-btn-primary btn-block" data-toggle="collapse" data-target="#oem_registration_template" aria-expanded="true" aria-controls="oem_registration_template">
								<?php esc_html_e('Registration Template', 'online-exam-management'); ?>
							</button>
						</div>
					</div>

					<div class="collapse p-3" id="oem_registration_template">

						<div class="form-row">
							<div class="col-12">
								<div class="form-group">
									<label for="oem_registration_template" class="oem-font-bold">
										<input <?php checked($registration_template, true, true); ?> type="checkbox" name="registration_template" id="oem_registration_template" value="1">
										<?php esc_html_e('Enable', 'online-exam-management'); ?>
									</label>
								</div>

								<div class="col-md-12">
									<span class="wlsm-font-bold text-dark"><?php esc_html_e('You can use the following variables:', 'online-exam-management'); ?></span>
									<div class="row">
										<?php foreach ($placeholder as $key => $value) { ?>
											<div class="col-sm-6 col-md-3 pb-1 pt-1 border">
												<span class="wlsm-font-bold text-secondary"><?php echo esc_html($value); ?></span>
												<br>
												<span><?php echo esc_html($key); ?></span>
											</div>
										<?php } ?>
									</div>
								</div>
								<br>

								<div class="form-group">
									<label for="oem_registration_subject" class="oem-font-bold">
										<?php esc_html_e('Subject', 'online-exam-management'); ?>:
									</label>
									<input type="text" name="registration_subject" class="form-control" id="oem_registration_subject" placeholder="<?php esc_attr_e('Subject', 'online-exam-management'); ?>" value="<?php echo esc_attr($registration_subject); ?>">
								</div>

								<label for="oem_registration_subject" class="oem-font-bold">
									<?php esc_html_e('Body', 'online-exam-management'); ?>:
								</label>

								<div class="form-group">
									<?php
									$settings = array(
										'media_buttons' => false,
										'textarea_name' => 'email_registration_body',
										'textarea_rows' => 10,
										'wpautop'       => false,
									);
									wp_editor(wp_kses_post(stripslashes($email_registration_body)), 'email_registration_body', $settings);
									?>
								</div>
							</div>
						</div>

						<?php $email_template = 'registration_template'; ?>

						<div class="text-right">
							<input type="email" class="oem-send-test-email-to" placeholder="<?php esc_attr_e('Enter email', 'school-management'); ?>">
							<button type="button" class="btn btn-sm btn-outline-primary oem-send-test-email" data-template="<?php echo esc_attr($email_template); ?>" data-nonce="<?php echo esc_attr(wp_create_nonce('send-test-email')); ?>">
								<?php esc_html_e('Send Test Email', 'school-management'); ?>
							</button>
						</div>
					</div>



					<div class="form-row">
						<div class="col-12 col-md-6">
							<button type="button" class="mt-2 btn oem-btn-primary btn-block" data-toggle="collapse" data-target="#oem_result_template" aria-expanded="true" aria-controls="oem_result_template">
								<?php esc_html_e('Result Template', 'online-exam-management'); ?>
							</button>
						</div>
					</div>

					<div class="collapse p-3" id="oem_result_template">

						<div class="form-row">
							<div class="col-12">
								<div class="form-group">
									<label for="oem_result_template" class="oem-font-bold">
										<input <?php checked($result_template, true, true); ?> type="checkbox" name="result_template" id="oem_result_template" value="1">
										<?php esc_html_e('Enable', 'online-exam-management'); ?>
									</label>
								</div>

								<!-- <div class="col-md-12">
									<span class="wlsm-font-bold text-dark"><?php esc_html_e('You can use the following variables:', 'online-exam-management'); ?></span>
									<div class="row">
										<?php foreach ($placeholder as $key => $value) { ?>
											<div class="col-sm-6 col-md-3 pb-1 pt-1 border">
												<span class="wlsm-font-bold text-secondary"><?php echo esc_html($value); ?></span>
												<br>
												<span><?php echo esc_html($key); ?></span>
											</div>
										<?php } ?>
									</div>
								</div> -->
								<br>

								<div class="form-group">
									<label for="oem_result_subject" class="oem-font-bold">
										<?php esc_html_e('Subject', 'online-exam-management'); ?>:
									</label>
									<input type="text" name="result_subject" class="form-control" id="oem_result_subject" placeholder="<?php esc_attr_e('Subject', 'online-exam-management'); ?>" value="<?php echo esc_attr($result_subject); ?>">
								</div>

								<label for="oem_result_subject" class="oem-font-bold">
									<?php esc_html_e('Body', 'online-exam-management'); ?>:
								</label>
								<p><?php esc_html_e('[Student Result]', 'online-exam-management'); ?></p>

								<!-- <div class="form-group">
									<?php
									$settings = array(
										'media_buttons' => false,
										'textarea_name' => 'email_result_body',
										'textarea_rows' => 10,
										'wpautop'       => false,
									);
									wp_editor(wp_kses_post(stripslashes($email_result_body)), 'email_result_body', $settings);
									?>
								</div> -->
							</div>
						</div>
					</div>

					<br>
					<div class="form-row">
						<div class="col-12 col-md-12">
							<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-save-email-template-btn">
								<?php esc_html_e('Save Settings', 'online-exam-management'); ?>
							</button>
						</div>
					</div>

				</form>
			</div>
		</div>

	</div>
</div>