<?php
defined( 'ABSPATH' ) || die();

$exam_page_url = OEM_Helper::online_exam_page_url();

$registration_page_url = OEM_Helper::registration_page_url();


$email = OEM_Helper::get_email_settings();


$email_type            = $email['email_type'];
$email_from_name       = $email['email_from_name'];
$email_smtp_host       = $email['email_smtp_host'];
$email_smtp_username   = $email['email_smtp_username'];
$email_smtp_password   = $email['email_smtp_password'];
$email_smtp_encryption = $email['email_smtp_encryption'];
$email_smtp_port       = $email['email_smtp_port'];

$nonce_action_email_settings = 'save-email-settings';
?>
<div class="row tab-pane fade show" id="oem-email-settings" role="tabpanel" aria-labelledby="oem-email-settings-tab">
	<div class="col-12 col-md-12">

		<div class="oem-section">
			<div class="oem-section-header">
				<span>
					<i class="fas fa-cog"></i>
					<?php esc_html_e( 'Email Protocol', 'online-exam-management' ); ?>
				</span>
			</div>

			<div class="oem-section-body">
				<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-email-settings-form">

					<?php $nonce_email_settings = wp_create_nonce( $nonce_action_email_settings ); ?>
					<input type="hidden" name="<?php echo esc_attr( $nonce_action_email_settings ); ?>" value="<?php echo esc_attr( $nonce_email_settings ); ?>">

					<input type="hidden" name="action" value="oem-save-email-settings">

					<div class="form-row">
						<div class="col-12 col-md-3">
							<div class="form-group">
								<label for="oem_email_type" class="oem-font-bold">
									<?php esc_html_e( 'Email Protocol', 'online-exam-management' ); ?>:
								</label>
								<select name="email_type" class="form-control selectpicker" id="oem_email_type" data-live-search="true">
									<!-- <option value="wpmail" <?php if ( $email_type === "wpmail") { 
										echo 'selected'; 
										} ?>  >WP Mail (Temporary Disable)</option> -->
									<option value="smtp" <?php if ( $email_type === "smtp") { 
										echo 'selected'; 
										} ?> >SMTP</option>
								</select>
							</div>
						</div>
					</div>
					<div class="oem-section-header">
						<span>
							<i class="fas fa-cog"></i>
							<?php esc_html_e( 'Email SMTP Settings', 'online-exam-management' ); ?>
						</span>
					</div>
					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_email_from_name" class="oem-font-bold">
									<?php esc_html_e( 'From Name', 'online-exam-management' ); ?>:
								</label>
								<input type="text" name="email_from_name" class="form-control" id="oem_email_from_name" placeholder="<?php esc_attr_e( 'Enter Name', 'online-exam-management' ); ?>" value="<?php echo esc_attr_e( $email_from_name ); ?>">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_email_smtp_host" class="oem-font-bold">
									<?php esc_html_e( 'SMTP Host', 'online-exam-management' ); ?>:
								</label>
								<input type="text" name="email_smtp_host" class="form-control" id="oem_email_smtp_host" placeholder="<?php esc_attr_e( 'SMTP Host', 'online-exam-management' ); ?>" value="<?php echo esc_attr_e( $email_smtp_host ); ?>">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_email_smtp_username" class="oem-font-bold">
									<?php esc_html_e( 'SMTP Username', 'online-exam-management' ); ?>:
								</label>
								<input type="text" name="email_smtp_username" class="form-control" id="oem_email_smtp_username" placeholder="<?php esc_attr_e( 'SMTP Username', 'online-exam-management' ); ?>" value="<?php echo esc_attr_e( $email_smtp_username ); ?>">
							</div>
						</div>
					</div>

					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_email_smtp_password" class="oem-font-bold">
									<?php esc_html_e( 'SMTP Password', 'online-exam-management' ); ?>:
								</label>
								<input type="password" name="email_smtp_password" class="form-control" id="oem_email_smtp_password" placeholder="<?php esc_attr_e( 'SMTP Password', 'online-exam-management' ); ?>" value="<?php echo esc_attr_e( $email_smtp_password ); ?>">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_email_smtp_encryption" class="oem-font-bold">
									<?php esc_html_e( 'SMTP encryption', 'online-exam-management' ); ?>:
								</label>
								<input type="text" name="email_smtp_encryption" class="form-control" id="oem_email_smtp_encryption" placeholder="<?php esc_attr_e( 'SMTP encryption', 'online-exam-management' ); ?>" value="<?php echo esc_attr_e( $email_smtp_encryption ); ?>">
							</div>
						</div>
					</div>
					<div class="form-row">
						<div class="col-12 col-md-6">
							<div class="form-group">
								<label for="oem_email_smtp_port" class="oem-font-bold">
									<?php esc_html_e( 'SMTP port', 'online-exam-management' ); ?>:
								</label>
								<input type="text" name="email_smtp_port" class="form-control" id="oem_email_smtp_port" placeholder="<?php esc_attr_e( 'SMTP port', 'online-exam-management' ); ?>" value="<?php echo esc_attr_e( $email_smtp_port ); ?>">
							</div>
						</div>
					</div>

					<div class="form-row">
						<div class="col-12 col-md-12">
							<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-save-email-settings-btn">
								<?php esc_html_e( 'Save Settings', 'online-exam-management' ); ?>
							</button>
						</div>
					</div>

				</form>
			</div>
		</div>

	</div>
</div>
