<?php
defined( 'ABSPATH' ) || die();

$now = OEM_Helper::now();

$at_formats = OEM_Helper::at_formats();

$at_format = OEM_Helper::at_format();

$nonce_action_datetime_settings = 'save-datetime-settings';
?>
<div class="row tab-pane fade" id="oem-datetime" role="tabpanel" aria-labelledby="oem-datetime-tab">
	<div class="col-12 col-md-12">

		<div class="oem-section">
			<div class="oem-section-header">
				<span>
					<i class="fas fa-clock"></i>
					<?php esc_html_e( 'Date / Time Settings', 'online-exam-management' ); ?>
				</span>
			</div>

			<div class="oem-section-body">
				<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-datetime-settings-form">

					<?php $nonce_datetime_settings = wp_create_nonce( $nonce_action_datetime_settings ); ?>
					<input type="hidden" name="<?php echo esc_attr( $nonce_action_datetime_settings ); ?>" value="<?php echo esc_attr( $nonce_datetime_settings ); ?>">

					<input type="hidden" name="action" value="oem-save-datetime-settings">

					<div class="form-row">
						<div class="col-12 col-md-4">
							<div class="form-group">
								<label for="oem_at_format" class="oem-font-bold">
									<?php esc_html_e( 'Date / Time Format', 'online-exam-management' ); ?>:
								</label>
								<select name="at_format" class="form-control selectpicker" id="oem_at_format">
									<?php foreach ( $at_formats as $value ) { ?>
									<option value="<?php echo esc_attr( $value ); ?>" <?php selected( $at_format, $value, true ); ?>>
										<?php echo esc_html( OEM_Helper::get_at_text_from_format( $now, $value ) ); ?>
									</option>
									<?php } ?>
								</select>
							</div>
						</div>
					</div>

					<div class="form-row">
						<div class="col-12 col-md-12">
							<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-save-datetime-settings-btn">
								<?php esc_html_e( 'Save Settings', 'online-exam-management' ); ?>
							</button>
						</div>
					</div>

				</form>
			</div>
		</div>

	</div>
</div>
