<?php
defined('ABSPATH') || die();

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam.php';

$exam_status = OEM_Helper::get_exam_status_text($exam_at, $duration, true, true);

// Total questions in this exam.
$questions_count = OEM_M_Question::get_questions_count($exam_id);

// Total maximum marks of questions in this exam.
$maximum_marks_sum = OEM_M_Question::get_questions_maximum_marks_sum($exam_id);
?>
<style>
	.dt-buttons {
		display: block !important;
	}
</style>

<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-table"></i>
				<?php
				printf(
					wp_kses(
						/* translators: 1: exam title, 2: exam code, 3: date and time, 4: number of minutes */
						__('Manage Results: <span class="oem-font-light">%1$s (%2$s) (%3$s - %4$s minutes)</span>', 'online-exam-management'),
						array(
							'span' => array('class' => array())
						)
					),
					esc_html(OEM_Helper::stripslashes($exam_title)),
					esc_html($exam_code),
					esc_html(OEM_Helper::get_at_text($exam_at)),
					esc_html($duration)
				);
				?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url($page_url); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-table"></i>&nbsp;
					<?php echo esc_html('Manage Exam Results', 'online-exam-management'); ?>
				</a>
			</span>
		</div>

		<div class="row justify-content-center">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-clock"></i>
							<?php esc_html_e('Exam Detail', 'online-exam-management'); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="row">
							<div class="col-md-4">
								<ul class="list-group list-group-flush">
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e('Exam Title:', 'online-exam-management'); ?></span>
										<span><?php echo esc_html(OEM_Helper::stripslashes($exam_title)); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e('Exam Code:', 'online-exam-management'); ?></span>
										<span><?php echo esc_html($exam_code); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e('Exam Status:', 'online-exam-management'); ?></span>
										<span>
											<?php
											echo wp_kses(
												$exam_status['text'],
												array('span' => array('class' => array()))
											);
											?>
										</span>
									</li>
								</ul>
							</div>
							<div class="col-md-4">
								<ul class="list-group list-group-flush">
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e('Exam Date and Time:', 'online-exam-management'); ?></span>
										<span><?php echo esc_html(OEM_Helper::get_at_text($exam_at)); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e('Exam Duration (in minutes):', 'online-exam-management'); ?></span>
										<span><?php echo esc_html($duration); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e('Exam Center:', 'online-exam-management'); ?></span>
										<span><?php echo esc_html(OEM_Helper::stripslashes($exam_center)); ?></span>
									</li>
								</ul>
							</div>
							<div class="col-md-4">
								<ul class="list-group list-group-flush">
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e('Total Questions:', 'online-exam-management'); ?></span>
										<span><?php echo esc_html($questions_count); ?></span>
									</li>
									<li class="list-group-item">
										<span class="oem-font-bold"><?php esc_html_e('Maximum Marks:', 'online-exam-management'); ?></span>
										<span><?php echo esc_html($maximum_marks_sum); ?></span>
									</li>
								</ul>
							</div>
						</div>
					</div>
				</div>

			</div>

			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-table"></i>
							<?php esc_html_e('Students in this Exam', 'online-exam-management'); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block">
							<table class="table table-hover table-bordered" id="oem-students-results-table" data-exam="<?php echo esc_attr($exam_id); ?>">
								<thead>
									<tr class="text-white oem-bg-primary">
										<th scope="col"><?php esc_html_e('Name', 'online-exam-management'); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e('Roll Number', 'online-exam-management'); ?></th>
										<th scope="col"><?php esc_html_e('Class', 'online-exam-management'); ?></th>
										<th scope="col"><?php esc_html_e('Section', 'online-exam-management'); ?></th>
										<!-- <th scope="col"><?php esc_html_e('Phone', 'online-exam-management'); ?></th> -->
										<th scope="col"><?php esc_html_e('Total Questions Attempted', 'online-exam-management'); ?></th>
										<th scope="col"><?php esc_html_e('Total marks', 'online-exam-management'); ?></th>
										<th scope="col"><?php esc_html_e('Obtained marks', 'online-exam-management'); ?></th>
										<th scope="col"><?php esc_html_e('Percentage', 'online-exam-management'); ?></th>
										<th scope="col"><?php esc_html_e('Subjective Marks', 'online-exam-management'); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e('Action', 'online-exam-management'); ?></th>
									</tr>
								</thead>
							</table>
						</div>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>