<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Student.php';

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam.php';

$student    = '';
$student_id = '';

if ( isset( $_GET['student_id'] ) && ! empty( $_GET['student_id'] ) ) {
	$student_id = absint( $_GET['student_id'] );
	$student    = OEM_M_Student::fetch_student( $student_id, $exam_id );
}

if ( ! $student ) {
	die;
}

$nonce_action_subjective_obtained_marks = 'edit-subjective-obtained-marks-' . $student->ID;

$name         = $student->name;
$roll_number  = $student->roll_number;
$class        = $student->class;
$section      = $student->section;
$phone        = $student->phone;
$address      = $student->address;
$father_name  = $student->father_name;
$father_phone = $student->father_phone;
$photo_id     = $student->photo_id;
$username     = $student->username;
$login_email  = $student->login_email;

// Total questions in this exam.
$questions_count = OEM_M_Question::get_questions_count( $exam_id );

// Total maximum marks of questions in this exam.
$maximum_marks_sum = OEM_M_Question::get_questions_maximum_marks_sum( $exam_id );

// Subjective questions attempted with responses.
$subjective_questions = OEM_M_Result::get_subjective_questions_attempted_with_responses( $student_id, $exam_id );

$nonce_action_subjective_obtained_marks = 'edit-subjective-obtained-marks-' . $student_id;

require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result_stats.php';
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam_title.php'; ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url . '&action=list&exam_id=' . $exam_id ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-users"></i>&nbsp;
					<?php echo esc_html( 'View All', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row justify-content-md-center">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-table"></i>
							<?php esc_html_e( "Student's Result", 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="row justify-content-between">
							<div class="col-md-4">
								<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/student.php'; ?>
							</div>
							<div class="col-md-4">
								<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/result.php'; ?>
							</div>
							<div class="col-md-3 my-auto">
								<?php if ( ! empty ( $photo_id ) ) { ?>
									<img src="<?php echo esc_url( wp_get_attachment_url( $photo_id ) ); ?>" class="img-responsive oem-photo ml-1">
								<?php } ?>
								<br>
								<a href="<?php echo esc_url( $page_url . '&action=answer_sheet&exam_id=' . $exam_id . '&student_id=' . $student_id ); ?>" class="d-inline-block mt-2 btn btn-sm oem-btn-outline-primary oem-download-answer-sheet">
									<?php esc_html_e( 'View Answer Sheet', 'online-exam-management' ); ?>
								</a>
							</div>
						</div>
					</div>
				</div>

			</div>

			<?php if ( count( $subjective_questions ) > 0 ) { ?>
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-save"></i>
							<?php esc_html_e( 'Subjective Answers & Marks Obtained by the Student', 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-edit-subjective-obtained-marks-form">

							<?php $nonce_subjective_obtained_marks = wp_create_nonce( $nonce_action_subjective_obtained_marks ); ?>
							<input type="hidden" name="<?php echo esc_attr( $nonce_action_subjective_obtained_marks ); ?>" value="<?php echo esc_attr( $nonce_subjective_obtained_marks ); ?>">

							<input type="hidden" name="action" value="oem-edit-subjective-obtained-marks">

							<input type="hidden" name="student_id" value="<?php echo esc_attr( $student_id ); ?>">
							<input type="hidden" name="exam_id" value="<?php echo esc_attr( $exam_id ); ?>">

							<div class="oem-questions-box oem-subjective-questions-attempted">
								<?php
								foreach ( $subjective_questions as $question ) {
								?>
								<div class="oem-question-box oem-subjective-question-attempted col">
									<input type="hidden" name="question[<?php echo esc_attr( $question->ID ); ?>]" value="<?php echo esc_attr( $question->ID ); ?>">
									<div class="oem-subjective-question-detail">
										<div class="mb-1 oem-font-bold">
											<span class="border-bottom border-dark">
												<?php esc_html_e( "Subjective Question:", 'online-exam-management' ); ?>
											</span>
										</div>
										<span class="oem-subjective-question-maximum-marks oem-font-small-medium float-right d-inline-block ml-3">
											<?php
											printf(
												wp_kses(
													/* translators: %s: Maximum marks. */
													__( '<span class="oem-font-bold">Maximum marks:</span> <span class="oem-font-extra-bold">%s</span>', 'online-exam-management' ),
													array(
														'span' => array( 'class' => array() )
													)
												),
												esc_html( OEM_Helper::sanitize_marks( $question->maximum_marks ) )
											);
											?>
										</span>
										<span class="oem-subjective-question-description">
											<?php echo wp_kses_post( stripcslashes( $question->description ) ); ?>
										</span>
									</div>

									<hr>

									<div class="oem-subjective-question-response">
										<div class="mb-1 oem-font-bold">
											<span class="border-bottom border-dark text-danger">
												<?php esc_html_e( "Student's Answer:", 'online-exam-management' ); ?>
											</span>
										</div>
										<div class="oem-subjective-question-student-answer">
											<?php echo esc_html( $question->student_answer ); ?>
										</div>
									</div>
									<div class="oem-subjective-question-obtained-marks mt-2 row justify-content-end">
										<div class="col-sm-8 col-md-6 col-lg-2">
											<div class="form-group text-md-right">
												<label class="oem-font-bold oem-font-small-medium">
													<?php esc_html_e( 'Obtained Marks', 'online-exam-management' ); ?>:
												</label>
												<input type="number" min="0" step="any" name="obtained_marks[<?php echo esc_attr( $question->ID ); ?>]" class="form-control" placeholder="<?php esc_attr_e( 'Enter obtained marks', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $question->sbj_marks_obtained ); ?>">
											</div>
										</div>
									</div>
								</div>
								<?php
								}
								?>
							</div>

							<div class="form-row mt-3 mb-1">
								<div class="col-12 col-md-12 text-center">
									<button type="submit" class="btn btn-sm oem-btn-primary" id="oem-edit-subjective-obtained-marks-btn">
										<i class="fas fa-save"></i>&nbsp;
										<?php esc_html_e( 'Save Marks', 'online-exam-management' ); ?>
									</button>
								</div>
							</div>

						</form>
					</div>
				</div>

			</div>
			<?php } ?>
		</div>
	</div>
</div>
