<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Student.php';

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam.php';

$student    = '';
$student_id = '';

if ( isset( $_GET['student_id'] ) && ! empty( $_GET['student_id'] ) ) {
	$student_id = absint( $_GET['student_id'] );
	$student    = OEM_M_Student::fetch_student( $student_id, $exam_id );
}

if ( ! $student ) {
	die;
}

$name         = $student->name;
$roll_number  = $student->roll_number;
$class        = $student->class;
$section      = $student->section;
$phone        = $student->phone;
$address      = $student->address;
$father_name  = $student->father_name;
$father_phone = $student->father_phone;
$photo_id     = $student->photo_id;
$username     = $student->username;
$login_email  = $student->login_email;

// Questions.
$questions = OEM_M_Question::fetch_questions( $exam_id );

// Total questions in this exam.
$questions_count = count( $questions );

// Total maximum marks of questions in this exam.
$maximum_marks_sum = OEM_M_Question::get_questions_maximum_marks_sum( $exam_id );

// Exam question options.
$options = OEM_M_Question::get_exam_options( $exam_id );

require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_result_stats.php';
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam_title.php'; ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url . '&action=list&exam_id=' . $exam_id ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-users"></i>&nbsp;
					<?php echo esc_html( 'View All', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row justify-content-md-center">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-table"></i>
							<?php esc_html_e( "Student's Result", 'online-exam-management' ); ?>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="row justify-content-between">
							<div class="col-md-4">
								<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/student.php'; ?>
							</div>
							<div class="col-md-4">
								<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/result.php'; ?>
							</div>
							<div class="col-md-3 my-auto">
								<?php if ( ! empty ( $photo_id ) ) { ?>
									<img src="<?php echo esc_url( wp_get_attachment_url( $photo_id ) ); ?>" class="img-responsive oem-photo ml-1">
								<?php } ?>
								<br>
								<a href="<?php echo esc_url( $page_url . '&action=edit&exam_id=' . $exam_id . '&student_id=' . $student_id ); ?>" class="d-inline-block mt-2 btn btn-sm oem-btn-outline-primary oem-download-answer-sheet">
									<?php esc_html_e( 'Edit Subjective Marks', 'online-exam-management' ); ?>
								</a>
							</div>
						</div>
					</div>
				</div>

			</div>

			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span class="float-left">
							<i class="fas fa-table"></i>
							<?php esc_html_e( "Student's Answer Sheet", 'online-exam-management' ); ?>
						</span>
						<span class="float-right oem-print">
							<?php require OEM_PLUGIN_DIR_PATH . 'includes/print/answer_sheet_btn.php'; ?>
						</span>
					</div>

					<div class="oem-section-body">
						<?php require OEM_PLUGIN_DIR_PATH . 'includes/print/answer_sheet.php'; ?>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
