<ul class="list-group list-group-flush">
	<li class="list-group-item">
		<span class="oem-font-bold"><?php esc_html_e( 'Total Questions:', 'online-exam-management' ); ?></span>
		<span><?php echo esc_html( $questions_count ); ?></span>
	</li>
	<li class="list-group-item">
		<span class="oem-font-bold"><?php esc_html_e( 'Maximum Marks:', 'online-exam-management' ); ?></span>
		<span><?php echo esc_html( $maximum_marks_sum ); ?></span>
	</li>
	<li class="list-group-item">
		<span class="oem-font-bold"><?php esc_html_e( 'Questions Attempted:', 'online-exam-management' ); ?></span>
		<span><?php echo esc_html( $questions_attempted_count ); ?></span>
	</li>
	<li class="list-group-item">
		<span class="oem-font-bold"><?php esc_html_e( 'Correct Answers:', 'online-exam-management' ); ?></span>
		<span><?php echo esc_html( $correct_answers_count ); ?></span>
	</li>
	<li class="list-group-item">
		<span class="oem-font-bold"><?php esc_html_e( 'Incorrect Answers:', 'online-exam-management' ); ?></span>
		<span><?php echo esc_html( $incorrect_answers_count ); ?></span>
	</li>
	<li class="list-group-item">
		<span class="oem-font-bold"><?php esc_html_e( 'Obtained Marks:', 'online-exam-management' ); ?></span>
		<span><?php echo esc_html( $obtained_marks_sum ); ?></span>
	</li>
	<li class="list-group-item">
		<span class="oem-font-bold"><?php esc_html_e( 'Percentage:', 'online-exam-management' ); ?></span>
		<span><?php echo esc_html( OEM_Helper::get_percentage_text( $maximum_marks_sum, $obtained_marks_sum ) ); ?></span>
	</li>
	<?php
	// Passing percentage.
	$passing_percentage = OEM_Helper::sanitize_marks( $exam->passing_percentage );
	if ( $passing_percentage > 0 ) {
	?>
	<li class="list-group-item">
		<span class="oem-font-bold"><?php esc_html_e( 'Status:', 'online-exam-management' ); ?></span>
		<span><?php echo OEM_Helper::get_result_status_text( $passing_percentage, OEM_Helper::sanitize_percentage( $maximum_marks_sum, $obtained_marks_sum ) ); ?></span>
	</li>
	<?php
	}
	?>
</ul>
