<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Subject.php';

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam.php';

$subject    = '';
$subject_id = '';

$nonce_action_subject = 'add-subject';

$subject_name  = '';
$subject_order = '';
$is_default    = '';

if ( isset( $_GET['subject_id'] ) && ! empty( $_GET['subject_id'] ) ) {
	$subject_id = absint( $_GET['subject_id'] );
	$subject    = OEM_M_Subject::fetch_subject( $subject_id, $exam_id );
	if ( ! $subject ) {
		die;
	}

	$nonce_action_subject = 'edit-subject-' . $subject->ID;

	$subject_name  = $subject->subject_name;
	$subject_order = $subject->subject_order;
	$is_default    = $subject->is_default;
}
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam_title.php'; ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-clock"></i>&nbsp;
					<?php echo esc_html( 'View Exams', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row justify-content-md-center">
			<div class="col-12 col-md-5">

				<div class="oem-section">
					<div class="oem-section-header">
						<?php
						if ( $subject ) {
						?>
						<span>
							<i class="fas fa-save"></i>
							<?php esc_html_e( 'Update Subject', 'online-exam-management' ); ?>
						</span>
						<span>
							<a class="btn btn-sm oem-btn-outline-primary float-right" href="<?php echo esc_url( $page_url . '&action=subjects&exam_id=' . $exam_id ); ?>#oem-subjects-table_wrapper">
								<i class="fas fa-tags"></i>
								<?php esc_html_e( 'View Subjects', 'online-exam-management' ); ?>
							</a>
						</span>
						<?php
						} else {
						?>
						<span>
							<i class="fas fa-plus"></i>
							<?php esc_html_e( 'Add Subject', 'online-exam-management' ); ?>
						</span>
						<span>
							<a class="btn btn-sm oem-btn-outline-primary float-right" href="<?php echo esc_url( $page_url . '&action=save&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-edit"></i>
								<?php esc_html_e( 'Edit Exam', 'online-exam-management' ); ?>
							</a>
						</span>
						<?php
						}
						?>
						</span>
					</div>

					<div class="oem-section-body">
						<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-subject-form">

							<?php $nonce_subject = wp_create_nonce( $nonce_action_subject ); ?>
							<input type="hidden" name="<?php echo esc_attr( $nonce_action_subject ); ?>" value="<?php echo esc_attr( $nonce_subject ); ?>">

							<input type="hidden" name="action" value="oem-save-subject">

							<?php if ( $subject ) { ?>
							<input type="hidden" name="subject_id" value="<?php echo esc_attr( $subject->ID ); ?>">
							<?php } ?>

							<input type="hidden" name="exam_id" value="<?php echo esc_attr( $exam->ID ); ?>">

							<div class="form-row">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/subject/subject_name.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/subject/subject_order.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/subject/is_default.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12 text-right">
									<?php require_once 'fields/subject/submit_button.php'; ?>
								</div>
							</div>
						</form>
					</div>
				</div>

			</div>

			<?php if ( ! $subject ) { ?>
			<div class="col-12 col-md-7">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-tags"></i>
							<?php esc_html_e( 'Subjects', 'online-exam-management' ); ?>
						</span>
						<span class="float-right">
							<a class="btn btn-sm oem-btn-primary" href="<?php echo esc_url( $page_url . '&action=questions&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-question-circle"></i>
								<?php esc_html_e( 'Manage Questions', 'online-exam-management' ); ?>
							</a>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block oem-table-block-small">
							<table class="table table-hover table-bordered" id="oem-subjects-table" data-exam="<?php echo esc_attr( $exam_id ); ?>">
								<thead>
									<tr class="text-white oem-bg-primary">
										<th scope="col"><?php esc_html_e( 'Subject Name', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Number of Questions', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Is Default', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Order', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Action', 'online-exam-management' ); ?></th>
									</tr>
								</thead>
							</table>
						</div>
					</div>
				</div>

			</div>
			<?php } ?>
		</div>

	</div>
</div>
