<?php
defined( 'ABSPATH' ) || die();

$exam    = '';
$exam_id = '';

$nonce_action_exam = 'add-exam';

$exam_title                = '';
$exam_code                 = '';
$exam_center               = '';
$exam_at                   = '';
$duration                  = '';
$passing_percentage        = '';
$instructions              = '';
$is_randomized             = 0;
$is_activated              = 0;
$group_by_subject          = 0;
$show_result_on_completion = 0;
$show_result_in_form       = 0;
$exam_fee                  = '';
$show_in_payment_form      = 0;
$show_result_in_form       = 0;
$roll_no_prefix            = '';
$roll_no_base              = 0;
$last_roll_no_index        = 0;

if ( isset( $_GET['exam_id'] ) && ! empty( $_GET['exam_id'] ) ) {
	$exam_id = absint( $_GET['exam_id'] );
	$exam    = OEM_M_Exam::fetch_exam( $exam_id );
	if ( ! $exam ) {
		die;
	}

	$nonce_action_exam = 'edit-exam-' . $exam->ID;

	$exam_title                = $exam->exam_title;
	$exam_code                 = $exam->exam_code;
	$exam_center               = $exam->exam_center;
	$exam_at                   = $exam->exam_at;
	$duration                  = $exam->duration;
	$passing_percentage        = $exam->passing_percentage;
	$instructions              = $exam->instructions;
	$is_randomized             = $exam->is_randomized;
	$is_activated              = $exam->is_activated;
	$group_by_subject          = $exam->group_by_subject;
	$show_result_on_completion = $exam->show_result_on_completion;
	$exam_fee                  = $exam->exam_fee;
	$show_in_payment_form      = $exam->show_in_payment_form;
	$show_result_in_form       = $exam->show_result_in_form;
	$roll_no_prefix            = $exam->roll_no_prefix;
	$roll_no_base              = $exam->roll_no_base;
	$last_roll_no_index        = $exam->last_roll_no_index;
	$exam_explain_link		   = $exam->exam_explaination_link;
}
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<i class="fas fa-clock"></i>
				<?php
				if ( $exam ) {
					printf(
						wp_kses(
							/* translators: 1: exam title, 2: exam code, 3: date and time, 4: number of minutes */
							__( 'Edit Exam: <span class="oem-font-light">%1$s (%2$s) (%3$s - %4$s minutes)</span>', 'online-exam-management' ),
							array(
								'span' => array( 'class' => array() )
							)
						),
						esc_html( OEM_Helper::stripslashes( $exam_title ) ),
						esc_html( $exam_code ),
						esc_html( OEM_Helper::get_at_text( $exam_at ) ),
						esc_html( $duration )
					);
				} else {
					esc_html_e( 'Add New Exam', 'online-exam-management' );
				}
				?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-clock"></i>&nbsp;
					<?php echo esc_html( 'View All', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<?php
							if ( $exam ) {
								?>
								<i class="fas fa-save"></i>
								<?php
								esc_html_e( 'Update Exam Detail', 'online-exam-management' );
							} else {
								?>
								<i class="fas fa-plus"></i>
								<?php
								esc_html_e( 'Add Exam Detail', 'online-exam-management' );
							}
							?>
						</span>
						<?php if ( $exam ) { ?>
						<span class="float-right">
							<a class="btn btn-sm oem-btn-success" href="<?php echo esc_url( $page_url . '&action=subjects&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-tags"></i>
								<?php esc_html_e( 'Manage Subjects', 'online-exam-management' ); ?>
							</a>
							<a class="btn btn-sm oem-btn-primary" href="<?php echo esc_url( $page_url . '&action=questions&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-question-circle"></i>
								<?php esc_html_e( 'Manage Questions', 'online-exam-management' ); ?>
							</a>
						</span>
						<?php } ?>
					</div>

					<div class="oem-section-body">
						<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-exam-form">

							<?php $nonce_exam = wp_create_nonce( $nonce_action_exam ); ?>
							<input type="hidden" name="<?php echo esc_attr( $nonce_action_exam ); ?>" value="<?php echo esc_attr( $nonce_exam ); ?>">

							<input type="hidden" name="action" value="oem-save-exam">

							<?php if ( $exam ) { ?>
							<input type="hidden" name="exam_id" value="<?php echo esc_attr( $exam->ID ); ?>">
							<?php } ?>

							<div class="form-row">
								<div class="col-12 col-md-4">
									<?php require_once 'fields/exam/exam_title.php'; ?>
								</div>
								<div class="col-12 col-md-4">
									<?php require_once 'fields/exam/exam_code.php'; ?>
								</div>
								<div class="col-12 col-md-4">
									<?php require_once 'fields/exam/exam_center.php'; ?>
								</div>
								<div class="col-12 col-md-4">
									<?php require_once 'fields/exam/exam_at.php'; ?>
								</div>
								<div class="col-12 col-md-4">
									<?php require_once 'fields/exam/duration.php'; ?>
								</div>
								<div class="col-12 col-md-4">
									<?php require_once 'fields/exam/passing_percentage.php'; ?>
								</div>
								<div class="col-12 col-md-12">
									<div class="row">
										<?php require_once 'fields/exam/roll_no_fields.php'; ?>
										<?php if ( $exam ) { ?>
										<div class="col-12 col-md-4 oem-exam-status-box">
											<?php require_once 'fields/exam/exam_status.php'; ?>
										</div>
										<?php } ?>
										<?php if ( $exam && ( 'pending' === $exam_status['key'] ) ) { ?>
										<div class="col-12 col-md-3">
											<label class="oem-font-bold">
												<?php esc_html_e( 'Setup and Activate Exam', 'online-exam-management' ); ?>:
											</label>
											<button type="button" class="btn btn-sm oem-btn-danger oem-setup-activate-exam" data-exam="<?php echo esc_attr( $exam_id ); ?>" data-nonce="<?php echo esc_attr( wp_create_nonce( 'setup-activate-exam-' . $exam_id ) ); ?>" data-message-title="<?php esc_attr_e( 'Confirm Setup and Activation!', 'online-exam-management' ); ?>" data-message-content="<?php esc_attr_e( "This will setup registered user accounts and activate the exam. Use this just before start of the exam. Students will be able to read instructions, but won't be able to take the exam until the start time of exam is reached.", 'online-exam-management' ); ?>"  data-cancel="<?php esc_attr_e( 'Cancel', 'online-exam-management' ); ?>" data-submit="<?php esc_attr_e( 'Confirm', 'online-exam-management' ); ?>">
												<?php esc_html_e( 'Setup & Activate Exam', 'online-exam-management' ); ?>
											</button>
											<p class="description">
												<?php esc_html_e( "This will setup registered user accounts and activate the exam. Use this just before start of the exam. Students will be able to read instructions, but won't be able to take the exam until the start time of exam is reached.", 'online-exam-management' ); ?>
											</p>
										</div>
										<?php } ?>										
									</div>
								</div>
								<div class="col-12 col-md-4">
									<?php require_once 'fields/exam/exam_explaination_link.php'; ?>
								</div>
								<div class="col-12 col-md-12">
									<?php require_once 'fields/exam/instructions.php'; ?>
								</div>
								<div class="col-12 col-md-3">
									<?php require_once 'fields/exam/group_by_subject.php'; ?>
								</div>
								<div class="col-12 col-md-3">
									<?php require_once 'fields/exam/is_randomized.php'; ?>
								</div>
								<div class="col-12 col-md-3">
									<?php require_once 'fields/exam/is_activated.php'; ?>
								</div>
								<div class="col-12 col-md-12">
									<div class="row">
										<div class="col-12 col-md-3">
											<?php require_once 'fields/exam/exam_fee.php'; ?>
										</div>
										<div class="col-12 col-md-3">
											<?php require_once 'fields/exam/show_in_payment_form.php'; ?>
										</div>
									</div>
								</div>
								<div class="col-12 col-md-12">
									<div class="row">
										<!-- <div class="col-12 col-md-3">
											<?php //require_once 'fields/exam/show_result_on_completion.php'; ?>
										</div> -->
										<?php if ( $exam ) { ?>
										<div class="col-12 col-md-6">
											<?php require_once 'fields/exam/exam_results_shortcode.php'; ?>
										</div>
										<?php } ?>
										<div class="col-12 col-md-3">
											<?php require_once 'fields/exam/show_result_in_form.php'; ?>
										</div>
									</div>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-12 text-right">
									<?php require_once 'fields/exam/submit_button.php'; ?>
								</div>
							</div>

						</form>
					</div>
				</div>

			</div>
		</div>
	</div>
</div>
