<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Question.php';

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam.php';

$question    = '';
$question_id = '';

$nonce_action_question = 'add-question';

$question_subject_id     = '';
$question_description    = '';
$question_maximum_marks  = '';
$question_negative_marks = '';
$question_order          = '';
$question_type           = 'obj_single';

$options           = array();
$number_of_options = 4;

if ( isset( $_GET['question_id'] ) && ! empty( $_GET['question_id'] ) ) {
	$question_id = absint( $_GET['question_id'] );
	$question    = OEM_M_Question::fetch_question( $question_id, $exam_id );
	if ( ! $question ) {
		die;
	}

	$nonce_action_question = 'edit-question-' . $question->ID;

	$question_subject_id     = $question->subject_id;
	$question_description    = $question->description;
	$question_maximum_marks  = $question->maximum_marks;
	$question_negative_marks = $question->negative_marks;
	$question_order          = $question->question_order;
	$question_type           = $question->type;

	if ( OEM_Helper::is_objective( $question_type ) ) {
		$options           = OEM_M_Question::get_options( $question_id );
		$number_of_options = count( $options );
	}
}

$subjects = OEM_M_Question::get_subjects( $exam_id );
?>
<div class="row">
	<div class="col-12 col-md-12">
		<div class="text-center oem-section-heading-block">
			<span class="oem-section-heading">
				<?php require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/partials/exam_title.php'; ?>
			</span>
			<span class="float-right">
				<a href="<?php echo esc_url( $page_url ); ?>" class="btn btn-sm btn-outline-light">
					<i class="fas fa-clock"></i>&nbsp;
					<?php echo esc_html( 'View Exams', 'online-exam-management' ); ?>
				</a>
			</span>
		</div>

		<div class="row">
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<?php
						if ( $question ) {
						?>
						<span>
							<i class="fas fa-save"></i>
							<?php esc_html_e( 'Update Question', 'online-exam-management' ); ?>
						</span>
						<span class="float-right">
							<a class="btn btn-sm oem-btn-outline-primary" href="<?php echo esc_url( $page_url . '&action=questions&exam_id=' . $exam_id ); ?>#oem-questions-table_wrapper">
								<i class="fas fa-question-circle"></i>
								<?php esc_html_e( 'View Questions', 'online-exam-management' ); ?>
							</a>
						</span>
						<?php
						} else {
						?>
						<span>
							<i class="fas fa-plus"></i>
							<?php esc_html_e( 'Add Question', 'online-exam-management' ); ?>
						</span>
						<span class="float-right">
							<a class="btn btn-sm oem-btn-success" href="<?php echo esc_url( $page_url . '&action=subjects&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-tags"></i>
								<?php esc_html_e( 'Manage Subjects', 'online-exam-management' ); ?>
							</a>
							<a class="btn btn-sm oem-btn-outline-primary" href="<?php echo esc_url( $page_url . '&action=save&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-edit"></i>
								<?php esc_html_e( 'Edit Exam', 'online-exam-management' ); ?>
							</a>
						</span>
						<?php
						}
						?>
						</span>
					</div>

					<div class="oem-section-body">
						<form action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>" method="post" id="oem-save-question-form">

							<?php $nonce_question = wp_create_nonce( $nonce_action_question ); ?>
							<input type="hidden" name="<?php echo esc_attr( $nonce_action_question ); ?>" value="<?php echo esc_attr( $nonce_question ); ?>">

							<input type="hidden" name="action" value="oem-save-question">

							<?php if ( $question ) { ?>
							<input type="hidden" name="question_id" value="<?php echo esc_attr( $question->ID ); ?>">
							<?php } ?>

							<input type="hidden" name="exam_id" value="<?php echo esc_attr( $exam->ID ); ?>">

							<div class="form-row">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/question/description.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-3">
									<?php require_once 'fields/question/subject.php'; ?>
								</div>
								<div class="col-12 col-md-3">
									<?php require_once 'fields/question/type.php'; ?>
								</div>
								<div class="col-12 col-md-3">
									<?php require_once 'fields/question/maximum_marks.php'; ?>
								</div>
								<div class="col-12 col-md-3 oem_objective_fields">
									<?php require_once 'fields/question/negative_marks.php'; ?>
								</div>
								<div class="col-12 col-md-3 oem_objective_fields">
									<?php require_once 'fields/question/number_of_options.php'; ?>
								</div>
							</div>

							<div class="form-row oem_objective_fields">
								<div class="col-12 col-md-12">
									<?php require_once 'fields/question/options.php'; ?>
								</div>
							</div>

							<div class="form-row">
								<div class="col-12 col-md-3">
									<?php require_once 'fields/question/question_order.php'; ?>
								</div>
							</div>

							<div class="form-row mt-2">
								<div class="col-12 col-md-12 text-right">
									<?php require_once 'fields/question/submit_button.php'; ?>
								</div>
							</div>
						</form>
					</div>
				</div>

			</div>

			<?php if ( ! $question ) { ?>
			<div class="col-12 col-md-12">

				<div class="oem-section">
					<div class="oem-section-header">
						<span>
							<i class="fas fa-question-circle"></i>
							<?php esc_html_e( 'Questions', 'online-exam-management' ); ?>
						</span>
						<span class="float-right">
							<a class="btn btn-sm oem-btn-success" href="<?php echo esc_url( $page_url . '&action=subjects&exam_id=' . $exam_id ); ?>">
								<i class="fas fa-tags"></i>
								<?php esc_html_e( 'Manage Subjects', 'online-exam-management' ); ?>
							</a>
						</span>
					</div>

					<div class="oem-section-body">
						<div class="oem-table-block oem-table-block-small">
							<table class="table table-hover table-bordered" id="oem-questions-table" data-exam="<?php echo esc_attr( $exam_id ); ?>">
								<thead>
									<tr class="text-white oem-bg-primary">
										<th scope="col"><?php esc_html_e( 'Question', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Type', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Marks', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Negative Marks', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Subject', 'online-exam-management' ); ?></th>
										<th scope="col"><?php esc_html_e( 'Order', 'online-exam-management' ); ?></th>
										<th scope="col" class="text-nowrap"><?php esc_html_e( 'Action', 'online-exam-management' ); ?></th>
									</tr>
								</thead>
							</table>
						</div>
					</div>
				</div>

			</div>
			<?php } ?>
		</div>

	</div>
</div>
