<?php
defined( 'ABSPATH' ) || die();
?>
<div class="form-group">
	<label for="oem_question_type" class="oem-font-bold">
		<span class="oem-important">*</span> <?php esc_html_e( 'Question Type', 'online-exam-management' ); ?>:
	</label>
	<select name="type" class="form-control selectpicker" id="oem_question_type" data-live-search="true" title="<?php esc_attr_e( 'Question Type', 'online-exam-management' ); ?>">
		<?php foreach ( OEM_Helper::question_types() as $key => $value ) { ?>
		<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $question_type, $key, true ); ?>>
			<?php echo esc_html( $value ); ?>
		</option>
		<?php } ?>
	</select>
</div>

<?php
$js = "
(function($) {
	'use strict';
	$(document).ready(function() {
		var objectiveFields = $('.oem_objective_fields');
		if('subjective' === $('#oem_question_type').val()) {
			objectiveFields.hide();
		}
		$(document).on('change', '#oem_question_type', function() {
			var type = this.value;
			if('subjective' === type) {
				objectiveFields.hide();
			} else {
				objectiveFields.fadeIn();
				var options = $('textarea[name^=\"option[\"]');
				if('obj_multi' === type) {
					var correctInputs = $('input[name=\"correct_option\"]');
					correctInputs.each(function(key, value) {
						$(this)
						.attr('type', 'checkbox')
						.attr('name', 'correct_option[' + key + ']')
						.val(key);
					});
				} else {
					options.each(function(key, value) {
						$('input[name=\"correct_option[' + key + ']\"]')
						.attr('type', 'radio')
						.attr('name', 'correct_option')
						.val(key);
					});
				}
			}
		});
	});
})(jQuery);
";
wp_add_inline_script( 'oem-admin', $js );
