<?php
defined( 'ABSPATH' ) || die();
?>
<div class="form-group">
	<label for="oem_question_subject_id" class="oem-font-bold">
		<span class="oem-important">*</span> <?php esc_html_e( 'Subject', 'online-exam-management' ); ?>:
	</label>
	<select name="subject_id" class="form-control selectpicker" id="oem_question_subject_id" data-live-search="true" title="<?php esc_attr_e( 'Default Subject', 'online-exam-management' ); ?>">
		<option value=""><?php esc_html_e( 'Default Subject', 'online-exam-management' ); ?></option>
		<?php foreach ( $subjects as $subject ) { ?>
		<option value="<?php echo esc_attr( $subject->ID ); ?>" <?php selected( $question_subject_id, $subject->ID, true ); ?>>
			<?php echo esc_html( OEM_Helper::stripslashes( $subject->subject_name ) ); ?>
		</option>
		<?php } ?>
	</select>
</div>
