<?php
defined( 'ABSPATH' ) || die();
?>
<div class="form-row">
	<div class="col-12 col-md-12">
		<div class="oem-question-option-box input-group mb-3">
			<div class="input-group-prepend">
				<span class="input-group-text px-4 oem-text-small"><?php echo esc_html( OEM_Helper::get_option_number( $key + 1 ) ); ?>.</span>
			</div>

			<textarea class="form-control oem_option_<?php echo esc_attr( $key ); ?>" name="option[<?php echo esc_attr( $key ); ?>]" cols="30" rows="2" placeholder="<?php esc_attr_e( 'Enter option value', 'online-exam-management' ); ?>"><?php echo wp_kses_post( $value ); ?></textarea>

			<button type="button" data-id="<?php echo esc_attr( $key ); ?>" class="btn btn-sm oem-btn-primary oem-option-editor-btn" data-toggle="modal" data-target="#oem-option-editor-modal">
				<?php esc_html_e( 'Rich Text Editor', 'online-exam-management' ); ?>
			</button>

			<div class="input-group-append px-3 pb-3">
				<?php
				if ( isset( $question_type ) && 'obj_multi' === $question_type ) {
				?>
				<input type="checkbox" name="correct_option[<?php echo esc_attr( $key ); ?>]" class="mt-4 oem-correct-option" value="<?php echo esc_attr( $key ); ?>" id="oem-question-option-<?php echo esc_attr( $key ); ?>" <?php checked( $is_correct, true, true ); ?>>
				<?php
				} else {
				?>
				<input type="radio" name="correct_option" class="mt-4 oem-correct-option" value="<?php echo esc_attr( $key ); ?>" id="oem-question-option-<?php echo esc_attr( $key ); ?>" <?php checked( $is_correct, true, true ); ?>>
				<?php
				}
				?>
				<label for="oem-question-option-<?php echo esc_attr( $key ); ?>" class="ml-1 mt-3 pt-1 form-check-label oem-font-bold oem-text-primary oem-text-small">
					<?php esc_html_e( 'Is Correct?', 'online-exam-management' ); ?>
				</label>
			</div>
		</div>
	</div>
</div>
