<?php
defined( 'ABSPATH' ) || die();
?>
<div class="form-group">
	<label for="oem_number_of_options" class="oem-font-bold">
		<span class="oem-important">*</span> <?php esc_html_e( 'Number of Options', 'online-exam-management' ); ?>:
	</label>
	<div class="input-group">
		<input type="number" min="1" step="1" name="number_of_options" class="form-control" id="oem_number_of_options" placeholder="<?php esc_attr_e( 'Enter number of options', 'online-exam-management' ); ?>" value="<?php echo esc_attr( $number_of_options ); ?>">
		<div class="input-group-append">
			<button type="button" class="input-group-btn btn btn-sm oem-btn-outline-primary" id="oem_set_question_options" data-security="<?php echo esc_attr( wp_create_nonce( 'security' ) ); ?>">
				<?php esc_html_e( 'Set Options', 'online-exam-management' ); ?>
			</button>
		</div>
	</div>
</div>
