<?php
defined( 'ABSPATH' ) || die();
?>
<div class="form-group">
	<label class="oem-font-bold">
		<?php esc_html_e( 'Show Result on Completion', 'online-exam-management' ); ?>:
	</label>
	<br>
	<div class="form-check form-check-inline">
		<input <?php checked( $show_result_on_completion, 1, true ); ?> class="form-check-input" type="radio" name="show_result_on_completion" id="oem_show_result_on_completion_yes" value="1">
		<label class="form-check-label oem-text-success oem-font-bold ml-1" for="oem_show_result_on_completion_yes">
			<?php echo esc_html( OEM_Helper::get_yes_text() ); ?>
		</label>
	</div>
	<div class="form-check form-check-inline">
		<input <?php checked( $show_result_on_completion, 0, true ); ?> class="form-check-input" type="radio" name="show_result_on_completion" id="oem_show_result_on_completion_no" value="0">
		<label class="form-check-label oem-text-danger oem-font-bold ml-1" for="oem_show_result_on_completion_no">
			<?php echo esc_html( OEM_Helper::get_no_text() ); ?>
		</label>
	</div>
	<p class="description"><?php esc_html_e( 'Show results immediately after completion of an exam. This is valid only if obtained marks are assigned for each of the subjective question attempted by the student.', 'online-exam-management' ); ?></p>
</div>
