<?php
defined( 'ABSPATH' ) || die();
?>
<div class="form-group oem-exam-status">
	<label class="oem-font-bold">
		<?php esc_html_e( 'Exam Status', 'online-exam-management' ); ?>:
	</label>
	<br>
	<div class="oem-exam-status-text">
	<?php
	$exam_status = OEM_Helper::get_exam_status_text( $exam_at, $duration, true, true );

	echo wp_kses(
		$exam_status['text'],
		array( 'span' => array( 'class' => array() ) )
	);

	if ( 'active' === $exam_status['key'] ) {
		$js_handle = 'oem-admin';
		?>
		<span class="oem-time-remaining text-secondary"> - <?php esc_html_e( 'Time remaining:', 'online-exam-management' ); ?></span>
		<?php
		require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_timer.php';
	} elseif ( 'pending' === $exam_status['key'] ) {
		$js_handle = 'oem-admin';
		?>
		<span class="oem-time-remaining text-secondary"> - <?php esc_html_e( 'Starting in:', 'online-exam-management' ); ?></span>
		<?php
		require_once OEM_PLUGIN_DIR_PATH . 'includes/partials/exam_starting_in.php';
	}
	?>
	</div>
</div>
