<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';
require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_M_Payment.php';

class OEM_Payment {
	public static function fetch_payments() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		global $wpdb;

		$records_page_url = OEM_Helper::get_page_url('records');
		$page_url         = OEM_Helper::get_page_url('payments');

		$query = OEM_M_Payment::fetch_query();

		$query_filter = $query;

		// Grouping.
		$group_by = ' ' . OEM_M_Payment::fetch_query_group_by();

		$query        .= $group_by;
		$query_filter .= $group_by;

		// Searching.
		$condition = '';
		if ( isset( $_POST['search']['value'] ) ) {
			$search_value = sanitize_text_field( $_POST['search']['value'] );
			if ( '' !== $search_value ) {
				$condition .= '' .
				'(p.amount LIKE "%' . $search_value . '%") OR ' .
				'(p.status LIKE "%' . $search_value . '%") OR ' .
				'(p.transaction_id LIKE "%' . $search_value . '%") OR ' .
				'(p.payment_method LIKE "%' . $search_value . '%") OR ' .
				'(p.receipt LIKE "%' . $search_value . '%")';

				$date_filter = OEM_Helper::filter_by_date( $search_value );

				$created_at        = $date_filter['date'];
				$format_created_at = $date_filter['format'];

				if ( $created_at && ! empty( $format_created_at ) ) {
					$created_at = $created_at->format( $format_created_at );
					$created_at = ' OR (p.created_at LIKE "%' . $created_at . '%")';

					$condition .= $created_at;
				}

				$query_filter .= ( ' HAVING ' . $condition );
			}
		}

		// Ordering.
		$columns = array( 'p.receipt', 'p.amount', 'p.payment_method', 'p.transaction_id', 'p.created_at' );
		if ( isset( $_POST['order'] ) && isset( $columns[ $_POST['order']['0']['column'] ] ) ) {
			$order_by  = sanitize_text_field( $columns[ $_POST['order']['0']['column'] ] );
			$order_dir = sanitize_text_field( $_POST['order']['0']['dir'] );

			$query_filter .= ' ORDER BY ' . $order_by . ' ' . $order_dir;
		} else {
			$query_filter .= ' ORDER BY p.ID DESC';
		}

		// Limiting.
		$limit = '';
		if ( -1 != $_POST['length'] ) {
			$start  = absint( $_POST['start'] );
			$length = absint( $_POST['length'] );

			$limit  = ' LIMIT ' . $start . ', ' . $length;
		}

		// Total query.
		$rows_query = OEM_M_Payment::fetch_query_count();

		// Total rows count.
		$total_rows_count = $wpdb->get_var( $rows_query );

		// Filtered rows count.
		if ( $condition ) {
			$filter_rows_count = $wpdb->get_var( $rows_query . ' WHERE (' . $condition . ')' );
		} else {
			$filter_rows_count = $total_rows_count;
		}

		// Filtered limit rows.
		$filter_rows_limit = $wpdb->get_results( $query_filter . $limit );

		$data = array();
		if ( count( $filter_rows_limit ) ) {
			foreach ( $filter_rows_limit as $row ) {
				$record_user_id = $row->record_user_id;
				if ( $record_user_id ) {
					$registration = ( '<a target="_blank" href="' . esc_url( $records_page_url . '&action=exams&record_id=' . $record_user_id ) . '"><span class="dashicons dashicons-search"></span></a>' );
				} else {
					$registration = '-';
				}

				// Table columns.
				$data[] = array(
					esc_html( $row->receipt ),
					esc_html( OEM_Helper::get_money_text( $row->amount ) ),
					esc_html( OEM_Helper::get_payment_method_text( $row->payment_method ) ),
					esc_html( OEM_Helper::get_payment_status_text( $row->status ) ),
					esc_html( OEM_Helper::get_text( $row->transaction_id, '-' ) ),
					esc_html( OEM_Helper::get_at_text( $row->created_at ) ),
					$registration,
					'<a class="oem-text-primary" href="' . esc_url( $page_url . "&action=view&payment_id=" . $row->ID ) . '"><span class="dashicons dashicons-search"></span></a>&nbsp;&nbsp;
					<a class="oem-text-danger oem-delete-payment" data-nonce="' . esc_attr( wp_create_nonce( 'delete-payment-' . $row->ID ) ) . '" data-payment="' . esc_attr( $row->ID ) . '" href="#" data-message-title="' . esc_attr__( 'Please Confirm!', 'online-exam-management' ) . '" data-message-content="' . esc_attr__( 'This will delete the payment.', 'online-exam-management' ) . '" data-cancel="' . esc_attr__( 'Cancel', 'online-exam-management' ) . '" data-submit="' . esc_attr__( 'Confirm', 'online-exam-management' ) . '"><span class="dashicons dashicons-trash"></span></a>'
				);
			}
		}

		$output = array(
			'draw'            => absint( $_POST['draw'] ),
			'recordsTotal'    => $total_rows_count,
			'recordsFiltered' => $filter_rows_count,
			'data'            => $data,
		);

		echo json_encode( $output );
		die;
	}

	public static function delete_payment() {
		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}

		try {
			ob_start();
			global $wpdb;

			$payment_id = isset( $_POST['payment_id'] ) ? absint( $_POST['payment_id'] ) : 0;

			OEM_Helper::check_nonce( 'delete-payment-' . $payment_id );

			// Checks if payment exists.
			$payment = OEM_M_Payment::get_payment( $payment_id );
			if ( ! $payment ) {
				throw new Exception( esc_html__( 'Payment not found.', 'online-exam-management' ) );
			}

			OEM_Helper::check_buffer();

		} catch ( Exception $exception ) {
			wp_send_json_error( $exception->getMessage() );
		}

		try {
			$wpdb->query( 'BEGIN;' );

			$success = $wpdb->delete( OEM_PAYMENTS, array( 'ID' => $payment_id ) );

			$message = esc_html__( 'Payment deleted successfully.', 'online-exam-management' );

			OEM_Helper::check_buffer();

			if ( false === $success ) {
				throw new Exception( $wpdb->last_error );
			}

			$wpdb->query( 'COMMIT;' );

			wp_send_json_success( array( 'message' => $message ) );
		} catch ( Exception $exception ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}
	}
}
