<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'includes/helpers/OEM_Helper.php';

class OEM_Menu {
	public static function create_menu() {
		if ( OEM_Helper::lm_valid() ) {
			$exam_management = add_menu_page( esc_html__( 'Online Exam', 'online-exam-management' ), esc_html__( 'Online Exam', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, OEM_MENU_EM, array( 'OEM_Menu', 'exam_management' ), 'dashicons-clock', 30);
			add_action( 'admin_print_styles-' . $exam_management, array( 'OEM_Menu', 'menu_page_assets' ) );

			$dashboard_submenu = add_submenu_page( OEM_MENU_EM, esc_html__( 'Dashboard', 'online-exam-management' ), esc_html__( 'Dashboard', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, OEM_MENU_EM, array( 'OEM_Menu', 'exam_management' ) );
			add_action( 'admin_print_styles-' . $dashboard_submenu, array( 'OEM_Menu', 'menu_page_assets' ) );

			$exams_submenu = add_submenu_page( OEM_MENU_EM, esc_html__( 'Exams', 'online-exam-management' ), esc_html__( 'Exams', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, OEM_MENU_EXAMS, array( 'OEM_Menu', 'exams' ) );
			add_action( 'admin_print_styles-' . $exams_submenu, array( 'OEM_Menu', 'menu_page_assets' ) );

			$students_submenu = add_submenu_page( OEM_MENU_EM, esc_html__( 'Students', 'online-exam-management' ), esc_html__( 'Students', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, OEM_MENU_STUDENTS, array( 'OEM_Menu', 'students' ) );
			add_action( 'admin_print_styles-' . $students_submenu, array( 'OEM_Menu', 'menu_page_assets' ) );

			$records_submenu = add_submenu_page( OEM_MENU_EM, esc_html__( 'Registrations', 'online-exam-management' ), esc_html__( 'Registrations', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, OEM_MENU_RECORDS, array( 'OEM_Menu', 'records' ) );
			add_action( 'admin_print_styles-' . $records_submenu, array( 'OEM_Menu', 'menu_page_assets' ) );

			$payments_submenu = add_submenu_page( OEM_MENU_EM, esc_html__( 'Payments', 'online-exam-management' ), esc_html__( 'Payments', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, OEM_MENU_PAYMENTS, array( 'OEM_Menu', 'payments' ) );
			add_action( 'admin_print_styles-' . $payments_submenu, array( 'OEM_Menu', 'menu_page_assets' ) );

			$results_submenu = add_submenu_page( OEM_MENU_EM, esc_html__( 'Results', 'online-exam-management' ), esc_html__( 'Results', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, OEM_MENU_RESULTS, array( 'OEM_Menu', 'results' ) );
			add_action( 'admin_print_styles-' . $results_submenu, array( 'OEM_Menu', 'menu_page_assets' ) );

			$settings_submenu = add_submenu_page( OEM_MENU_EM, esc_html__( 'Settings', 'online-exam-management' ), esc_html__( 'Settings', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, OEM_MENU_SETTINGS, array( 'OEM_Menu', 'settings' ) );
			add_action( 'admin_print_styles-' . $settings_submenu, array( 'OEM_Menu', 'menu_page_assets' ) );

			$exam_management_submenu = add_submenu_page( OEM_MENU_EM, esc_html__( 'License', 'online-exam-management' ), esc_html__( 'License', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, 'online-exam-management-license', array( 'OEM_Menu', 'admin_menu' ) );
			add_action( 'admin_print_styles-' . $exam_management_submenu, array( 'OEM_Menu', 'admin_menu_assets' ) );
		} else {
			$exam_management = add_menu_page( esc_html__( 'Online Exam', 'online-exam-management' ), esc_html__( 'Online Exam', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, 'online-exam-management-license', array( 'OEM_Menu', 'admin_menu' ), 'dashicons-clock', 30 );
			add_action( 'admin_print_styles-' . $exam_management, array( 'OEM_Menu', 'admin_menu_assets' ) );

			$exam_management_submenu = add_submenu_page( 'online-exam-management-license', esc_html__( 'License', 'online-exam-management' ), esc_html__( 'License', 'online-exam-management' ), OEM_ADMIN_CAPABILITY, 'online-exam-management-license', array( 'OEM_Menu', 'admin_menu' ) );
			add_action( 'admin_print_styles-' . $exam_management_submenu, array( 'OEM_Menu', 'admin_menu_assets' ) );
		}
	}

	public static function admin_menu() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/admin_menu.php';
	}

	public static function admin_menu_assets() {
		wp_enqueue_style( 'oem_lc', OEM_PLUGIN_URL . 'assets/css/admin_menu.css' );
	}

	public static function exam_management() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/dashboard/route.php';
	}

	public static function exams() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/exams/route.php';
	}

	public static function students() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/students/route.php';
	}

	public static function records() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/records/route.php';
	}

	public static function payments() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/payments/route.php';
	}

	public static function results() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/results/route.php';
	}

	public static function settings() {
		require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/settings/route.php';
	}

	public static function menu_page_assets() {
		wp_enqueue_style( 'bootstrap', OEM_PLUGIN_URL . 'assets/css/bootstrap.min.css' );
		wp_enqueue_style( 'jquery-confirm', OEM_PLUGIN_URL . 'assets/css/jquery-confirm.min.css' );
		wp_enqueue_style( 'toastr', OEM_PLUGIN_URL . 'assets/css/toastr.min.css' );
		wp_enqueue_style( 'font-awesome-free', OEM_PLUGIN_URL . 'assets/css/all.min.css' );
		wp_enqueue_style( 'zebra-datepicker', OEM_PLUGIN_URL . 'assets/css/zebra_datepicker.min.css' );
		wp_enqueue_style( 'bootstrap-select', OEM_PLUGIN_URL . 'assets/css/bootstrap-select.min.css' );

		wp_enqueue_style( 'dataTables-bootstrap4', OEM_PLUGIN_URL . 'assets/css/datatable/dataTables.bootstrap4.min.css' );
		wp_enqueue_style( 'responsive-bootstrap4', OEM_PLUGIN_URL . 'assets/css/datatable/responsive.bootstrap4.min.css' );
		
		wp_enqueue_style( 'jquery-dataTables', OEM_PLUGIN_URL . 'assets/css/datatable/jquery.dataTables.min.css' );
		wp_enqueue_style( 'datatable-checkbox', OEM_PLUGIN_URL . 'assets/css/datatable/dataTables.checkboxes.css' );

		wp_enqueue_style( 'oem-admin', OEM_PLUGIN_URL . 'assets/css/oem-admin.css', array(), '1.4', 'all' );
		wp_enqueue_style('datatable', 'https://cdn.datatables.net/buttons/1.6.5/css/buttons.dataTables.min.css', array(), '1.4', 'all');

		wp_enqueue_script( 'popper', OEM_PLUGIN_URL . 'assets/js/popper.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'bootstrap', OEM_PLUGIN_URL . 'assets/js/bootstrap.min.js', array( 'popper' ), true, true );
		wp_enqueue_script( 'jquery-confirm', OEM_PLUGIN_URL . 'assets/js/jquery-confirm.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'toastr', OEM_PLUGIN_URL . 'assets/js/toastr.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'zebra-datepicker', OEM_PLUGIN_URL . 'assets/js/zebra_datepicker.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'bootstrap-select', OEM_PLUGIN_URL . 'assets/js/bootstrap-select.min.js', array( 'bootstrap' ), true, true );

		wp_enqueue_script( 'jquery-dataTables', OEM_PLUGIN_URL . 'assets/js/datatable/jquery.dataTables.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'dataTables-bootstrap4', OEM_PLUGIN_URL . 'assets/js/datatable/dataTables.bootstrap4.min.js', array( 'jquery' ), true, true );
		
		wp_enqueue_script( 'dataTables-responsive', OEM_PLUGIN_URL . 'assets/js/datatable/dataTables.responsive.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'responsive-bootstrap4', OEM_PLUGIN_URL . 'assets/js/datatable/responsive.bootstrap4.min.js', array( 'jquery' ), true, true );
		wp_enqueue_script( 'dataTables-checkbox', OEM_PLUGIN_URL . 'assets/js/datatable/dataTables.checkboxes.min.js', array( 'jquery' ), true, true );

		// export
		wp_enqueue_script('dataTables1', 'https://cdn.datatables.net/buttons/1.6.5/js/dataTables.buttons.min.js', array('jquery'), true, true);
		wp_enqueue_script('dataTables2', 'https://cdn.datatables.net/buttons/1.6.5/js/buttons.flash.min.js', array('jquery'), true, true);
		wp_enqueue_script('dataTables3', 'https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js', array('jquery'), true, true);
		wp_enqueue_script('dataTables4', 'https://cdn.datatables.net/buttons/1.6.5/js/buttons.html5.min.js', array('jquery'), true, true);
		wp_enqueue_script('dataTables5', 'https://cdn.datatables.net/buttons/1.6.5/js/buttons.print.min.js', array('jquery'), true, true);

		wp_enqueue_script( 'jquery-ui-autocomplete' );

		wp_enqueue_script( 'oem-admin', OEM_PLUGIN_URL . 'assets/js/oem-admin.js', array( 'jquery', 'jquery-form' ), '1.4', true );
		wp_localize_script( 'oem-admin', 'oemnonce', wp_create_nonce( 'oem_nonce' ) );
		wp_localize_script( 'oem-admin', 'oemdateformat', OEM_Helper::date_format() );
		wp_localize_script( 'oem-admin', 'oemtimeformat', OEM_Helper::time_format() );
		wp_localize_script( 'oem-admin', 'oematformat', OEM_Helper::at_format() );
		wp_localize_script( 'oem-admin', 'oemadminurl', admin_url() );
		wp_localize_script( 'oem-admin', 'oemloadingtext', esc_html__( 'Loading...', 'online-exam-management' ) );
	}
}
