<?php
defined( 'ABSPATH' ) || die();

class OEM_Database {
	public static function activation() {
		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();
		require_once ABSPATH . 'wp-admin/includes/upgrade.php';

		// Create exams table.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_EXAMS . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				exam_code varchar(191) DEFAULT NULL,
				exam_title varchar(255) DEFAULT NULL,
				exam_center varchar(255) DEFAULT NULL,
				exam_at timestamp NULL DEFAULT NULL,
				duration smallint(4) UNSIGNED DEFAULT NULL,
				instructions text DEFAULT NULL,
				is_randomized tinyint(1) NOT NULL DEFAULT '0',
				is_activated tinyint(1) NOT NULL DEFAULT '0',
				group_by_subject tinyint(1) NOT NULL DEFAULT '0',
				show_result_on_completion tinyint(1) NOT NULL DEFAULT '0',
				show_result_in_form tinyint(1) NOT NULL DEFAULT '0',
				results_published tinyint(1) NOT NULL DEFAULT '0',
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID)
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );

		$row = $wpdb->get_results( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" . DB_NAME . "' AND TABLE_NAME = '" . OEM_EXAMS . "' AND COLUMN_NAME = 'exam_explaination_link'" );
		if ( empty( $row ) ) {
			$wpdb->query( "ALTER TABLE " . OEM_EXAMS . " ADD exam_explaination_link varchar(255) DEFAULT NULL" );
		}

		// Create subjects table.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_SUBJECTS . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				subject_name varchar(191) DEFAULT NULL,
				subject_order text DEFAULT NULL,
				is_default tinyint(1) NOT NULL DEFAULT '0',
				exam_id bigint(20) UNSIGNED DEFAULT NULL,
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID),
				INDEX (exam_id),
				FOREIGN KEY (exam_id) REFERENCES " . OEM_EXAMS . " (ID) ON DELETE CASCADE
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );

		// Create questions table.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_QUESTIONS . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				description text DEFAULT NULL,
				maximum_marks text DEFAULT NULL,
				negative_marks text DEFAULT NULL,
				type varchar(25) DEFAULT NULL,
				question_order text DEFAULT NULL,
				subject_id bigint(20) UNSIGNED DEFAULT NULL,
				exam_id bigint(20) UNSIGNED DEFAULT NULL,
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID),
				INDEX (subject_id),
				INDEX (exam_id),
				FOREIGN KEY (subject_id) REFERENCES " . OEM_SUBJECTS . " (ID) ON DELETE SET NULL,
				FOREIGN KEY (exam_id) REFERENCES " . OEM_EXAMS . " (ID) ON DELETE CASCADE
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );

		// Create options table.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_OPTIONS . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				value text DEFAULT NULL,
				question_id bigint(20) UNSIGNED DEFAULT NULL,
				is_correct tinyint(1) NOT NULL DEFAULT '0',
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID),
				INDEX (question_id),
				FOREIGN KEY (question_id) REFERENCES " . OEM_QUESTIONS . " (ID) ON DELETE CASCADE
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );

		$wpdb->query( "ALTER TABLE " . OEM_USERS . " ENGINE = InnoDB" );
		$wpdb->query( "ALTER TABLE " . OEM_POSTS . " ENGINE = InnoDB" );

		// Create students table.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_STUDENTS . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				name varchar(60) DEFAULT NULL,
				phone varchar(40) DEFAULT NULL,
				father_name varchar(60) DEFAULT NULL,
				father_phone varchar(40) DEFAULT NULL,
				class varchar(191) DEFAULT NULL,
				section varchar(191) DEFAULT NULL,
				roll_number varchar(40) DEFAULT NULL,
				photo_id bigint(20) UNSIGNED DEFAULT NULL,
				user_id bigint(20) UNSIGNED DEFAULT NULL,
				record_user_id bigint(20) UNSIGNED DEFAULT NULL,
				exam_id bigint(20) UNSIGNED DEFAULT NULL,
				is_active tinyint(1) NOT NULL DEFAULT '1',
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID),
				UNIQUE (roll_number, exam_id),
				UNIQUE (record_user_id, exam_id),
				INDEX (user_id),
				INDEX (record_user_id),
				INDEX (exam_id),
				FOREIGN KEY (exam_id) REFERENCES " . OEM_EXAMS . " (ID) ON DELETE CASCADE,
				FOREIGN KEY (user_id) REFERENCES " . OEM_USERS . " (ID) ON DELETE SET NULL,
				FOREIGN KEY (record_user_id) REFERENCES " . OEM_USERS . " (ID) ON DELETE SET NULL,
				FOREIGN KEY (photo_id) REFERENCES " . OEM_POSTS . " (ID) ON DELETE SET NULL
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );

		$row = $wpdb->get_results( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" . DB_NAME . "' AND TABLE_NAME = '" . OEM_STUDENTS . "' AND COLUMN_NAME = 'exam_photos'" );
		if ( empty( $row ) ) {
			$wpdb->query( "ALTER TABLE " . OEM_STUDENTS . " ADD exam_photos text DEFAULT NULL AFTER phone" );
		}

		$row = $wpdb->get_results( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" . DB_NAME . "' AND TABLE_NAME = '" . OEM_STUDENTS . "' AND COLUMN_NAME = 'gender'" );
		if ( empty( $row ) ) {
			$wpdb->query( "ALTER TABLE " . OEM_STUDENTS . " ADD gender text DEFAULT NULL" );
			$wpdb->query( "ALTER TABLE " . OEM_STUDENTS . " ADD dob timestamp NULL DEFAULT NULL" );
			$wpdb->query( "ALTER TABLE " . OEM_STUDENTS . " ADD id_number bigint(20) UNSIGNED DEFAULT NULL" );
		}

		// Drop user_id contraint from student table
		// $row = $wpdb->get_results( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" . DB_NAME . "' AND TABLE_NAME = '" . OEM_STUDENTS . "' AND COLUMN_NAME = 'user_id_remove'" );
		// if ( empty( $row ) ) {
		// 	$wpdb->query( "ALTER TABLE " . OEM_STUDENTS . " DROP CONSTRAINT user_id" );
		// }
		// Create responses table.
		// is_marked: Question is marked for review.
		// is_submitted: Answer of the question is saved or submitted.
		// sbj_marks_obtained: Total marks obtained by the student if the question is of type: subjective.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_RESPONSES . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				value text DEFAULT NULL,
				question_id bigint(20) UNSIGNED DEFAULT NULL,
				student_id bigint(20) UNSIGNED DEFAULT NULL,
				is_marked tinyint(1) NOT NULL DEFAULT '0',
				is_submitted tinyint(1) NOT NULL DEFAULT '0',
				sbj_marks_obtained text DEFAULT NULL,
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID),
				INDEX (question_id),
				INDEX (student_id),
				FOREIGN KEY (question_id) REFERENCES " . OEM_QUESTIONS . " (ID) ON DELETE CASCADE,
				FOREIGN KEY (student_id) REFERENCES " . OEM_STUDENTS . " (ID) ON DELETE CASCADE
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );

		// Create answers table to store single or multiple options selected by the student for a question.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_ANSWERS . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				option_id bigint(20) UNSIGNED DEFAULT NULL,
				response_id bigint(20) UNSIGNED DEFAULT NULL,
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID),
				INDEX (option_id),
				INDEX (response_id),
				FOREIGN KEY (option_id) REFERENCES " . OEM_OPTIONS . " (ID) ON DELETE CASCADE,
				FOREIGN KEY (response_id) REFERENCES " . OEM_RESPONSES . " (ID) ON DELETE CASCADE
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );

		// Create registrations / record_users table.
		// Keeps track of the latest details of student and having unique reg_number.
		// Meta keys: oem_account_type, oem_access_type, oem_access_till.
		// Student user account - oem_account_type: student.
		// if account_type is student, then allow student to make payments and view exams from student dashboard.
		// access_type: lifetime, limited, specified.
		// check exam_payment if access_type is specified.
		// check access_till if access_type is limited.
		// ignore access_till if access_type is lifetime.

		// Add address column if not exists to students table.
		$row = $wpdb->get_results( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" . DB_NAME . "' AND TABLE_NAME = '" . OEM_STUDENTS . "' AND COLUMN_NAME = 'address'" );
		if ( empty( $row ) ) {
			$wpdb->query( "ALTER TABLE " . OEM_STUDENTS . " ADD address text DEFAULT NULL AFTER phone" );
		}

		// Add exam_fee, show_in_payment_form, passing_percentage, roll_no_prefix, roll_no_base, last_roll_no_index columns if not exists to exams table.
		$row = $wpdb->get_results( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" . DB_NAME . "' AND TABLE_NAME = '" . OEM_EXAMS . "' AND COLUMN_NAME = 'exam_fee'" );
		if ( empty( $row ) ) {
			$wpdb->query( "ALTER TABLE " . OEM_EXAMS . " ADD exam_fee decimal(12,2) UNSIGNED DEFAULT '0.00' AFTER duration" );
			$wpdb->query( "ALTER TABLE " . OEM_EXAMS . " ADD show_in_payment_form tinyint(1) NOT NULL DEFAULT '0' AFTER show_result_in_form" );
			$wpdb->query( "ALTER TABLE " . OEM_EXAMS . " ADD passing_percentage text DEFAULT NULL AFTER results_published" );
			$wpdb->query( "ALTER TABLE " . OEM_EXAMS . " ADD roll_no_prefix varchar(25) DEFAULT '' AFTER passing_percentage" );
			$wpdb->query( "ALTER TABLE " . OEM_EXAMS . " ADD roll_no_base int(11) UNSIGNED DEFAULT '0' AFTER roll_no_prefix" );
			$wpdb->query( "ALTER TABLE " . OEM_EXAMS . " ADD last_roll_no_index bigint(20) UNSIGNED NOT NULL DEFAULT '0' AFTER roll_no_base" );
		}

		$row_eel = $wpdb->get_results( "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = '" . DB_NAME . "' AND TABLE_NAME = '" . OEM_EXAMS . "' AND COLUMN_NAME = 'exam_explaination_link'" );
		if ( empty( $row_eel ) ) { 
			$wpdb->query( "ALTER TABLE " . OEM_EXAMS . " ADD exam_explaination_link varchar(255) DEFAULT NULL AFTER last_roll_no_index" );
		}

		// Create payments table.
		// access_type: lifetime, limited, specified.
		// if specified, then save to exam_payment.
		// log: log errors if payment fails.
		// log: save the payment message, depending on lifetime, limited, specified access-type.
		// log: limited - save extension period length detail.
		// log: specified - save exams access detail.
		// status: pending, awaiting-payment, failed, completed.
		// pending: started the checkout process but did not complete it.
		// awaiting-payment: completed the checkout process, but payment has yet to be confirmed.
		// completed: payment has been confirmed and receipt is confirmed.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_PAYMENTS . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				amount decimal(12,2) UNSIGNED DEFAULT '0.00',
				transaction_id varchar(80) DEFAULT NULL,
				order_id text DEFAULT NULL,
				payment_method varchar(50) DEFAULT NULL,
				currency varchar(10) DEFAULT NULL,
				receipt varchar(50) DEFAULT NULL,
				note text DEFAULT NULL,
				log text DEFAULT NULL,
				record_user_id bigint(20) UNSIGNED DEFAULT NULL,
				access_type varchar(30) DEFAULT 'specified',
				status varchar(30) DEFAULT 'pending',
				payment_date timestamp NULL DEFAULT NULL,
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID),
				INDEX (record_user_id),
				FOREIGN KEY (record_user_id) REFERENCES " . OEM_USERS . " (ID) ON DELETE SET NULL
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );

		// Create exam_payment table.
		// This is used for payment purpose only.
		// Valid only if access_type in payments table is specified.
		$sql = "CREATE TABLE IF NOT EXISTS " . OEM_EXAM_PAYMENT . " (
				ID bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
				exam_id bigint(20) UNSIGNED DEFAULT NULL,
				payment_id bigint(20) UNSIGNED DEFAULT NULL,
				created_at timestamp NULL DEFAULT CURRENT_TIMESTAMP,
				updated_at timestamp NULL DEFAULT NULL,
				PRIMARY KEY (ID),
				UNIQUE (exam_id, payment_id),
				INDEX (exam_id),
				INDEX (payment_id),
				FOREIGN KEY (exam_id) REFERENCES " . OEM_EXAMS . " (ID) ON DELETE CASCADE,
				FOREIGN KEY (payment_id) REFERENCES " . OEM_PAYMENTS . " (ID) ON DELETE CASCADE
				) ENGINE=InnoDB " . $charset_collate;
		dbDelta( $sql );
	}

	public static function deactivation() {
		delete_option( 'oem-key' );
		delete_option( 'oem-valid' );
		delete_option( 'oem-cache' );
		delete_option( 'oem-updation-detail' );
	}

	public static function uninstall() {
		delete_option( 'oem-key' );
		delete_option( 'oem-valid' );
		delete_option( 'oem-cache' );
		delete_option( 'oem-updation-detail' );
	}

	public static function remove_data() {
		global $wpdb;
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_EXAM_PAYMENT );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_PAYMENTS );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_ANSWERS );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_RESPONSES );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_STUDENTS );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_OPTIONS );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_QUESTIONS );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_SUBJECTS );
		$wpdb->query( 'DROP TABLE IF EXISTS ' . OEM_EXAMS );

		delete_option( 'oem_registration' );
		delete_option( 'oem_exam_page_url' );
		delete_option( 'oem_date_format' );
		delete_option( 'oem_time_format' );
		delete_option( 'oem_at_format' );
		delete_option( 'oem_delete_on_uninstall' );
	}
}
