<?php
defined( 'ABSPATH' ) || die();

require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Menu.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Exam.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Subject.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Question.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Student.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Record.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Payment.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Result.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/inc/OEM_Setting.php';
require_once OEM_PLUGIN_DIR_PATH . 'admin/OEM_Bulk_Action.php';
add_filter('doing_it_wrong_trigger_error', function () {return false;}, 10, 0);

add_action( 'admin_menu', array( 'OEM_Menu', 'create_menu' ) );

// Exams.
add_action( 'wp_ajax_oem-fetch-exams', array( 'OEM_Exam', 'fetch_exams' ) );
add_action( 'wp_ajax_oem-save-exam', array( 'OEM_Exam', 'save_exam' ) );
add_action( 'wp_ajax_oem-delete-exam', array( 'OEM_Exam', 'delete_exam' ) );
add_action( 'wp_ajax_oem-get-keyword-exams', array( 'OEM_Exam', 'get_keyword_exams' ) );
add_action( 'wp_ajax_oem-setup-activate-exam', array( 'OEM_Exam', 'setup_activate' ) );

// Subjects.
add_action( 'wp_ajax_oem-fetch-subjects', array( 'OEM_Subject', 'fetch_subjects' ) );
add_action( 'wp_ajax_oem-save-subject', array( 'OEM_Subject', 'save_subject' ) );
add_action( 'wp_ajax_oem-delete-subject', array( 'OEM_Subject', 'delete_subject' ) );

// Questions and options.
add_action( 'wp_ajax_oem-fetch-questions', array( 'OEM_Question', 'fetch_questions' ) );
add_action( 'wp_ajax_oem-save-question', array( 'OEM_Question', 'save_question' ) );
add_action( 'wp_ajax_oem-delete-question', array( 'OEM_Question', 'delete_question' ) );
add_action( 'wp_ajax_oem-set-question-options', array( 'OEM_Question', 'set_question_options' ) );

// Students.
add_action( 'wp_ajax_oem-fetch-exams-students', array( 'OEM_Student', 'fetch_exams_students' ) );
add_action( 'wp_ajax_oem-fetch-students', array( 'OEM_Student', 'fetch_students' ) );
add_action( 'wp_ajax_oem-save-student', array( 'OEM_Student', 'save_student' ) );
add_action( 'wp_ajax_oem-students-csv-export', array( 'OEM_Student', 'students_csv_export' ) );
add_action( 'wp_ajax_oem-students-sample-csv-export', array( 'OEM_Student', 'students_sample_csv_export' ) );
add_action( 'wp_ajax_oem-bulk-import-students', array( 'OEM_Student', 'bulk_import_students' ) );
add_action( 'wp_ajax_oem-delete-student', array( 'OEM_Student', 'delete_student' ) );

// Records.
add_action( 'wp_ajax_oem-save-record', array( 'OEM_Record', 'save_record' ) );
add_action( 'wp_ajax_oem-delete-record', array( 'OEM_Record', 'delete_record' ) );

// Payments.
add_action( 'wp_ajax_oem-fetch-payments', array( 'OEM_Payment', 'fetch_payments' ) );
add_action( 'wp_ajax_oem-delete-payment', array( 'OEM_Payment', 'delete_payment' ) );

// Results.
add_action( 'wp_ajax_oem-fetch-exams-results', array( 'OEM_Result', 'fetch_exams_results' ) );
add_action( 'wp_ajax_oem-fetch-students-results', array( 'OEM_Result', 'fetch_students_results' ) );
add_action( 'wp_ajax_oem-edit-subjective-obtained-marks', array( 'OEM_Result', 'edit_subjective_obtained_marks' ) );

// Settings.
add_action( 'wp_ajax_oem-save-general-settings', array( 'OEM_Setting', 'save_general' ) );
add_action( 'wp_ajax_oem-save-registration-settings', array( 'OEM_Setting', 'save_registration' ) );
add_action( 'wp_ajax_oem-save-datetime-settings', array( 'OEM_Setting', 'save_datetime' ) );
add_action( 'wp_ajax_oem-save-payment-methods-settings', array( 'OEM_Setting', 'save_payment_methods' ) );
add_action( 'wp_ajax_oem-save-payment-receipt-settings', array( 'OEM_Setting', 'save_payment_receipt' ) );

add_action( 'wp_ajax_oem-save-email-settings', array( 'OEM_Setting', 'save_email_settings' ) );
add_action( 'wp_ajax_oem-save-email-template', array( 'OEM_Setting', 'save_email_templates' ) );

add_action( 'wp_ajax_oem-send-test-email', array( 'OEM_Setting', 'send_test_email' ) );

add_action( 'wp_ajax_oem-reset-plugin', array( 'OEM_Setting', 'reset_plugin' ) );

// Bulk Action.
add_action( 'wp_ajax_oem-bulk-action', array( 'oem_Bulk_Action', 'bulk_action' ) );