<?php
defined( 'ABSPATH' ) || die();

class OEM_Bulk_Action {
	public static function bulk_action() {
		
		$action = isset( $_POST['bulk_action'] ) ? sanitize_text_field( $_POST['bulk_action'] ) : '';
		$entity = isset( $_POST['entity'] ) ? sanitize_text_field( $_POST['entity'] ) : '';

		if ( ! wp_verify_nonce( $_POST[ 'nonce' ], 'bulk-action-' . $entity ) ) {
			die();
		}

		if ( empty( $action ) ) {
			wp_send_json_error( esc_html__( 'Please select an option.', 'online-exam-management' ) );
		}

		$method_name = $action . '_' . $entity;

		// Call action_entity() method.
		if ( ! method_exists( 'OEM_Bulk_Action', $method_name ) ) {
			wp_send_json_error( esc_html__( 'Invalid selection.', 'online-exam-management' ) );
		}

		self::$method_name();
	}

	public static function delete_students() {
		global $wpdb;
		$student_ids = ( isset( $_POST['bulk_values'] ) && is_array( $_POST['bulk_values'] ) ) ? array_map( 'absint', $_POST['bulk_values'] ) : array();

		if ( empty( $student_ids ) ) {
			wp_send_json_error( esc_html__( 'Please select atleast one student.', 'online-exam-management' ) );
		}

		try {
			$wpdb->query( 'BEGIN;' );

			ob_start();

			foreach ( $student_ids as $student_id ) {
				// Checks if student exists.

				$success = $wpdb->delete( OEM_STUDENTS, array( 'ID' => $student_id ) );

				OEM_Helper::check_buffer();

				if ( false === $success ) {
					throw new Exception( $wpdb->last_error );
				}
			}

			$wpdb->query( 'COMMIT;' );

			$message = esc_html__( 'Students deleted successfully.', 'online-exam-management' );

			wp_send_json_success( array( 'message' => $message ) );
		} catch ( Exception $exception ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}
	}

	public static function delete_registered() {

		if ( ! current_user_can( OEM_ADMIN_CAPABILITY ) ) {
			die();
		}
		global $wpdb;
		$student_ids = ( isset( $_POST['bulk_values'] ) && is_array( $_POST['bulk_values'] ) ) ? array_map( 'absint', $_POST['bulk_values'] ) : array();
	
		if ( empty( $student_ids ) ) {
			wp_send_json_error( esc_html__( 'Please select atleast one student.', 'online-exam-management' ) );
		}

		try {
			$wpdb->query( 'BEGIN;' );

			ob_start();
			global $wpdb;

			foreach ( $student_ids as $student_id ) {

				// Checks if record exists.
				$record = OEM_M_Record::find( $student_id );

				
				if ( ! $record ) {
					throw new Exception( esc_html__( 'Registration not found.', 'online-exam-management' ) );
				}
				// Checks if student exists.

				OEM_M_Record::delete( $student_id );

			   $success = esc_html__( 'Registration deleted successfully.', 'online-exam-management' );

				

			}

			$wpdb->query( 'COMMIT;' );

			$message = esc_html__( 'Students deleted successfully.', 'online-exam-management' );

			wp_send_json_success( array( 'message' => $message ) );
		} catch ( Exception $exception ) {
			$wpdb->query( 'ROLLBACK;' );
			wp_send_json_error( $exception->getMessage() );
		}
	}
}
